/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.filter;

import com.netflix.hollow.Internal;
import com.netflix.hollow.PublicApi;
import com.netflix.hollow.core.read.filter.Resolver;
import com.netflix.hollow.core.read.filter.UnresolvedTypeFilter;
import com.netflix.hollow.core.schema.HollowSchema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;

@PublicApi
public interface TypeFilter {
    public static Builder newTypeFilter() {
        return new Builder().includeAll();
    }

    public boolean includes(String var1);

    public boolean includes(String var1, String var2);

    default public TypeFilter resolve(List<HollowSchema> schemas) {
        return this;
    }

    @PublicApi
    public static final class Builder {
        List<Rule> rules = new ArrayList<Rule>();
        private static final Rule INCLUDE_ALL = (type, field) -> Action.include;
        private static final Rule EXCLUDE_ALL = (type, field) -> Action.exclude;

        private Builder() {
        }

        public Builder includeAll() {
            this.rules.clear();
            this.rules.add(INCLUDE_ALL);
            return this;
        }

        public Builder excludeAll() {
            this.rules.clear();
            this.rules.add(EXCLUDE_ALL);
            return this;
        }

        public Builder include(String type) {
            Objects.requireNonNull(type, "type required");
            this.rules.add((t, f) -> type.equals(t) ? Action.include : Action.next);
            return this;
        }

        public Builder includeRecursive(String type) {
            Objects.requireNonNull(type, "type required");
            this.rules.add((t, f) -> type.equals(t) ? Action.includeRecursive : Action.next);
            return this;
        }

        @Internal
        public Builder include(String type, String field) {
            Objects.requireNonNull(type, "type required");
            Objects.requireNonNull(field, "field name required");
            this.rules.add((t, f) -> type.equals(t) && field.equals(f) ? Action.include : Action.next);
            return this;
        }

        @Internal
        public Builder includeRecursive(String type, String field) {
            Objects.requireNonNull(type, "type required");
            Objects.requireNonNull(field, "field name required");
            this.rules.add((t, f) -> type.equals(t) && field.equals(f) ? Action.includeRecursive : Action.next);
            return this;
        }

        public Builder exclude(String type) {
            Objects.requireNonNull(type, "type required");
            this.rules.add((t, f) -> type.equals(t) ? Action.exclude : Action.next);
            return this;
        }

        public Builder excludeRecursive(String type) {
            Objects.requireNonNull(type, "type required");
            this.rules.add((t, f) -> type.equals(t) ? Action.excludeRecursive : Action.next);
            return this;
        }

        public Builder exclude(String type, String field) {
            Objects.requireNonNull(type, "type required");
            Objects.requireNonNull(field, "field name required");
            this.rules.add((t, f) -> type.equals(t) && field.equals(f) ? Action.exclude : Action.next);
            return this;
        }

        public Builder excludeRecursive(String type, String field) {
            Objects.requireNonNull(type, "type required");
            Objects.requireNonNull(field, "field name required");
            this.rules.add((t, f) -> type.equals(t) && field.equals(f) ? Action.excludeRecursive : Action.next);
            return this;
        }

        public TypeFilter resolve(List<HollowSchema> schemas) {
            return new Resolver(this.rules, schemas).resolve();
        }

        public TypeFilter build() {
            return new UnresolvedTypeFilter(this.rules);
        }

        @Internal
        static enum Action {
            next(false, false),
            include(true, false),
            includeRecursive(true, true),
            exclude(false, false),
            excludeRecursive(false, true);

            final boolean included;
            final boolean recursive;

            private Action(boolean included, boolean recursive) {
                this.included = included;
                this.recursive = recursive;
            }
        }

        @FunctionalInterface
        @Internal
        static interface Rule
        extends BiFunction<String, String, Action> {
            @Override
            public Action apply(String var1, String var2);
        }
    }
}

