/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.filter;

import com.netflix.hollow.Internal;
import com.netflix.hollow.core.read.filter.ResolvedTypeFilter;
import com.netflix.hollow.core.read.filter.TypeActions;
import com.netflix.hollow.core.read.filter.TypeFilter;
import com.netflix.hollow.core.schema.HollowCollectionSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

@Internal
final class Resolver {
    private final Map<String, HollowSchema> schemas;
    private final List<TypeFilter.Builder.Rule> rules;

    Resolver(List<TypeFilter.Builder.Rule> rules, List<HollowSchema> schemas) {
        assert (!rules.isEmpty());
        this.rules = rules;
        this.schemas = schemas.stream().collect(Collectors.toMap(HollowSchema::getName, Function.identity()));
    }

    TypeFilter resolve() {
        Map<String, TypeActions> resolved = this.rules.stream().flatMap(rule -> this.schemas.values().stream().flatMap(schema -> this.descendants((TypeFilter.Builder.Rule)rule, (HollowSchema)schema))).filter(ta -> ta.actions().values().stream().anyMatch(a -> a != TypeFilter.Builder.Action.next)).collect(Collectors.toMap(TypeActions::type, Function.identity(), TypeActions::merge));
        return new ResolvedTypeFilter(resolved);
    }

    private Stream<TypeActions> descendants(TypeFilter.Builder.Rule rule, HollowSchema schema) {
        String type = schema.getName();
        TypeFilter.Builder.Action action = rule.apply(type, null);
        TypeActions parent = TypeActions.newTypeActions(type, action);
        switch (schema.getSchemaType()) {
            case OBJECT: {
                HollowObjectSchema os = (HollowObjectSchema)schema;
                return IntStream.range(0, os.numFields()).boxed().flatMap(i -> {
                    TypeFilter.Builder.Action descendantAction;
                    String field = os.getFieldName((int)i);
                    TypeFilter.Builder.Action fa = rule.apply(type, field);
                    if (fa == TypeFilter.Builder.Action.next) {
                        return Stream.empty();
                    }
                    TypeActions child = TypeActions.newTypeActions(type, field, fa);
                    TypeFilter.Builder.Action action2 = descendantAction = fa.recursive ? fa : action;
                    if (descendantAction.recursive && os.getFieldType((int)i) == HollowObjectSchema.FieldType.REFERENCE) {
                        String refType = os.getReferencedType((int)i);
                        HollowSchema refSchema = this.schemas.get(refType);
                        assert (refSchema != null);
                        Stream<TypeActions> descendants = this.descendants((t, f) -> descendantAction, refSchema);
                        return Stream.concat(Stream.of(parent, child), descendants);
                    }
                    return Stream.of(parent, child);
                });
            }
            case SET: 
            case LIST: {
                if (action == TypeFilter.Builder.Action.next) {
                    return Stream.empty();
                }
                if (action.recursive) {
                    HollowCollectionSchema cs = (HollowCollectionSchema)schema;
                    HollowSchema elemSchema = this.schemas.get(cs.getElementType());
                    assert (elemSchema != null);
                    Stream<TypeActions> descendants = this.descendants((t, f) -> action, elemSchema);
                    return Stream.concat(Stream.of(parent), descendants);
                }
                return Stream.of(parent);
            }
            case MAP: {
                if (action == TypeFilter.Builder.Action.next) {
                    return Stream.empty();
                }
                if (action.recursive) {
                    HollowMapSchema ms = (HollowMapSchema)schema;
                    HollowSchema kSchema = this.schemas.get(ms.getKeyType());
                    HollowSchema vSchema = this.schemas.get(ms.getValueType());
                    Stream<TypeActions> descendants = Stream.concat(this.descendants((t, f) -> action, kSchema), this.descendants((t1, f1) -> action, vSchema));
                    return Stream.concat(Stream.of(parent), descendants);
                }
                return Stream.of(parent);
            }
        }
        throw new HollowSchema.SchemaType.UnrecognizedSchemaTypeException(type, schema.getSchemaType());
    }
}

