/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.set;

import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.read.dataaccess.HollowSetTypeDataAccess;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;

public class PotentialMatchHollowSetOrdinalIterator
implements HollowOrdinalIterator {
    private final int setOrdinal;
    private final HollowSetTypeDataAccess dataAccess;
    private final int numBuckets;
    private int currentBucket;

    public PotentialMatchHollowSetOrdinalIterator(int setOrdinal, HollowSetTypeDataAccess dataAccess, int hashCode) {
        this.setOrdinal = setOrdinal;
        this.dataAccess = dataAccess;
        this.numBuckets = HashCodes.hashTableSize(dataAccess.size(setOrdinal));
        this.currentBucket = HashCodes.hashInt(hashCode) & this.numBuckets - 1;
    }

    @Override
    public int next() {
        int currentBucketValue = this.dataAccess.relativeBucketValue(this.setOrdinal, this.currentBucket);
        if (currentBucketValue == -1) {
            return Integer.MAX_VALUE;
        }
        ++this.currentBucket;
        this.currentBucket &= this.numBuckets - 1;
        return currentBucketValue;
    }
}

