/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.set;

import com.netflix.hollow.core.index.key.HollowPrimaryKeyValueDeriver;
import com.netflix.hollow.core.memory.HollowUnsafeHandle;
import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.read.engine.SetMapKeyHasher;
import com.netflix.hollow.core.read.engine.set.HollowSetTypeDataElements;
import com.netflix.hollow.tools.checksum.HollowChecksum;
import java.util.BitSet;

class HollowSetTypeReadStateShard {
    private volatile HollowSetTypeDataElements currentDataVolatile;
    private HollowPrimaryKeyValueDeriver keyDeriver;

    HollowSetTypeReadStateShard() {
    }

    public int size(int ordinal) {
        int size;
        HollowSetTypeDataElements currentData;
        do {
            currentData = this.currentDataVolatile;
            size = (int)currentData.setPointerAndSizeData.getElementValue((long)ordinal * (long)currentData.bitsPerFixedLengthSetPortion + (long)currentData.bitsPerSetPointer, currentData.bitsPerSetSizeValue);
        } while (this.readWasUnsafe(currentData));
        return size;
    }

    /*
     * Unable to fully structure code
     */
    public boolean contains(int ordinal, int value, int hashCode) {
        block0: do lbl-1000:
        // 3 sources

        {
            currentData = this.currentDataVolatile;
            startBucket = this.getAbsoluteBucketStart(currentData, ordinal);
            endBucket = currentData.setPointerAndSizeData.getElementValue((long)ordinal * (long)currentData.bitsPerFixedLengthSetPortion, currentData.bitsPerSetPointer);
            if (this.readWasUnsafe(currentData)) ** GOTO lbl-1000
            hashCode = HashCodes.hashInt(hashCode);
            bucket = startBucket + ((long)hashCode & endBucket - startBucket - 1L);
            bucketOrdinal = this.absoluteBucketValue(currentData, bucket);
            while (bucketOrdinal != currentData.emptyBucketValue) {
                if (bucketOrdinal == value) {
                    foundData = true;
                    continue block0;
                }
                if (++bucket == endBucket) {
                    bucket = startBucket;
                }
                bucketOrdinal = this.absoluteBucketValue(currentData, bucket);
            }
            foundData = false;
        } while (this.readWasUnsafe(currentData));
        return foundData;
    }

    /*
     * Unable to fully structure code
     */
    public int findElement(int ordinal, Object ... hashKey) {
        hashCode = SetMapKeyHasher.hash(hashKey, this.keyDeriver.getFieldTypes());
        do lbl-1000:
        // 3 sources

        {
            currentData = this.currentDataVolatile;
            startBucket = this.getAbsoluteBucketStart(currentData, ordinal);
            endBucket = currentData.setPointerAndSizeData.getElementValue((long)ordinal * (long)currentData.bitsPerFixedLengthSetPortion, currentData.bitsPerSetPointer);
            if (this.readWasUnsafe(currentData)) ** GOTO lbl-1000
            bucket = startBucket + ((long)hashCode & endBucket - startBucket - 1L);
            bucketOrdinal = this.absoluteBucketValue(currentData, bucket);
            while (bucketOrdinal != currentData.emptyBucketValue && !this.readWasUnsafe(currentData)) {
                if (this.keyDeriver.keyMatches(bucketOrdinal, hashKey)) {
                    return bucketOrdinal;
                }
                if (++bucket == endBucket) {
                    bucket = startBucket;
                }
                bucketOrdinal = this.absoluteBucketValue(currentData, bucket);
            }
        } while (this.readWasUnsafe(currentData));
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    public int relativeBucketValue(int setOrdinal, int bucketIndex) {
        do lbl-1000:
        // 3 sources

        {
            currentData = this.currentDataVolatile;
            startBucket = this.getAbsoluteBucketStart(currentData, setOrdinal);
            if (this.readWasUnsafe(currentData)) ** GOTO lbl-1000
            value = this.absoluteBucketValue(currentData, startBucket + (long)bucketIndex);
            if (value != currentData.emptyBucketValue) continue;
            value = -1;
        } while (this.readWasUnsafe(currentData));
        return value;
    }

    private long getAbsoluteBucketStart(HollowSetTypeDataElements currentData, int ordinal) {
        return ordinal == 0 ? 0L : currentData.setPointerAndSizeData.getElementValue((long)(ordinal - 1) * (long)currentData.bitsPerFixedLengthSetPortion, currentData.bitsPerSetPointer);
    }

    private int absoluteBucketValue(HollowSetTypeDataElements currentData, long absoluteBucketIndex) {
        return (int)currentData.elementData.getElementValue(absoluteBucketIndex * (long)currentData.bitsPerElement, currentData.bitsPerElement);
    }

    void invalidate() {
        this.setCurrentData(null);
    }

    HollowSetTypeDataElements currentDataElements() {
        return this.currentDataVolatile;
    }

    private boolean readWasUnsafe(HollowSetTypeDataElements data) {
        HollowUnsafeHandle.getUnsafe().loadFence();
        return data != this.currentDataVolatile;
    }

    void setCurrentData(HollowSetTypeDataElements data) {
        this.currentDataVolatile = data;
    }

    protected void applyToChecksum(HollowChecksum checksum, BitSet populatedOrdinals, int shardNumber, int numShards) {
        HollowSetTypeDataElements currentData = this.currentDataVolatile;
        int ordinal = populatedOrdinals.nextSetBit(shardNumber);
        while (ordinal != -1) {
            if ((ordinal & numShards - 1) == shardNumber) {
                int shardOrdinal = ordinal / numShards;
                int numBuckets = HashCodes.hashTableSize(this.size(shardOrdinal));
                long offset = this.getAbsoluteBucketStart(currentData, shardOrdinal);
                checksum.applyInt(ordinal);
                for (int i = 0; i < numBuckets; ++i) {
                    int bucketValue = this.absoluteBucketValue(currentData, offset + (long)i);
                    if (bucketValue == currentData.emptyBucketValue) continue;
                    checksum.applyInt(i);
                    checksum.applyInt(bucketValue);
                }
                ordinal += numShards;
            } else {
                int r = (ordinal & -numShards) + shardNumber;
                ordinal = r <= ordinal ? r + numShards : r;
            }
            ordinal = populatedOrdinals.nextSetBit(ordinal);
        }
    }

    public long getApproximateHeapFootprintInBytes() {
        HollowSetTypeDataElements currentData = this.currentDataVolatile;
        long requiredBitsForSetPointers = ((long)currentData.maxOrdinal + 1L) * (long)currentData.bitsPerFixedLengthSetPortion;
        long requiredBitsForBuckets = currentData.totalNumberOfBuckets * (long)currentData.bitsPerElement;
        long requiredBits = requiredBitsForSetPointers + requiredBitsForBuckets;
        return requiredBits / 8L;
    }

    public long getApproximateHoleCostInBytes(BitSet populatedOrdinals, int shardNumber, int numShards) {
        HollowSetTypeDataElements currentData = this.currentDataVolatile;
        long holeBits = 0L;
        int holeOrdinal = populatedOrdinals.nextClearBit(0);
        while (holeOrdinal <= currentData.maxOrdinal) {
            if ((holeOrdinal & numShards - 1) == shardNumber) {
                holeBits += (long)currentData.bitsPerFixedLengthSetPortion;
            }
            holeOrdinal = populatedOrdinals.nextClearBit(holeOrdinal + 1);
        }
        return holeBits / 8L;
    }

    public void setKeyDeriver(HollowPrimaryKeyValueDeriver keyDeriver) {
        this.keyDeriver = keyDeriver;
    }
}

