/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.set;

import com.netflix.hollow.api.sampling.DisabledSamplingDirector;
import com.netflix.hollow.api.sampling.HollowSampler;
import com.netflix.hollow.api.sampling.HollowSamplingDirector;
import com.netflix.hollow.api.sampling.HollowSetSampler;
import com.netflix.hollow.core.index.key.HollowPrimaryKeyValueDeriver;
import com.netflix.hollow.core.memory.MemoryMode;
import com.netflix.hollow.core.memory.encoding.GapEncodedVariableLengthIntegerReader;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import com.netflix.hollow.core.read.HollowBlobInput;
import com.netflix.hollow.core.read.dataaccess.HollowSetTypeDataAccess;
import com.netflix.hollow.core.read.engine.HollowCollectionTypeReadState;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.PopulatedOrdinalListener;
import com.netflix.hollow.core.read.engine.SnapshotPopulatedOrdinalsReader;
import com.netflix.hollow.core.read.engine.set.HollowSetTypeDataElements;
import com.netflix.hollow.core.read.engine.set.HollowSetTypeReadStateShard;
import com.netflix.hollow.core.read.engine.set.PotentialMatchHollowSetOrdinalIterator;
import com.netflix.hollow.core.read.filter.HollowFilterConfig;
import com.netflix.hollow.core.read.iterator.EmptyOrdinalIterator;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;
import com.netflix.hollow.core.read.iterator.HollowSetOrdinalIterator;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.schema.HollowSetSchema;
import com.netflix.hollow.tools.checksum.HollowChecksum;
import java.io.IOException;
import java.util.BitSet;

public class HollowSetTypeReadState
extends HollowCollectionTypeReadState
implements HollowSetTypeDataAccess {
    private final HollowSetSampler sampler;
    private final int shardNumberMask;
    private final int shardOrdinalShift;
    private final HollowSetTypeReadStateShard[] shards;
    private HollowPrimaryKeyValueDeriver keyDeriver;
    private int maxOrdinal;

    public HollowSetTypeReadState(HollowReadStateEngine stateEngine, HollowSetSchema schema, int numShards) {
        this(stateEngine, MemoryMode.ON_HEAP, schema, numShards);
    }

    public HollowSetTypeReadState(HollowReadStateEngine stateEngine, MemoryMode memoryMode, HollowSetSchema schema, int numShards) {
        super(stateEngine, memoryMode, schema);
        this.sampler = new HollowSetSampler(schema.getName(), DisabledSamplingDirector.INSTANCE);
        this.shardNumberMask = numShards - 1;
        this.shardOrdinalShift = 31 - Integer.numberOfLeadingZeros(numShards);
        if (numShards < 1 || 1 << this.shardOrdinalShift != numShards) {
            throw new IllegalArgumentException("Number of shards must be a power of 2!");
        }
        HollowSetTypeReadStateShard[] shards = new HollowSetTypeReadStateShard[numShards];
        for (int i = 0; i < shards.length; ++i) {
            shards[i] = new HollowSetTypeReadStateShard();
        }
        this.shards = shards;
    }

    @Override
    public void readSnapshot(HollowBlobInput in, ArraySegmentRecycler memoryRecycler) throws IOException {
        if (this.shards.length > 1) {
            this.maxOrdinal = VarInt.readVInt(in);
        }
        for (int i = 0; i < this.shards.length; ++i) {
            HollowSetTypeDataElements snapshotData = new HollowSetTypeDataElements(this.memoryMode, memoryRecycler);
            snapshotData.readSnapshot(in);
            this.shards[i].setCurrentData(snapshotData);
        }
        if (this.shards.length == 1) {
            this.maxOrdinal = this.shards[0].currentDataElements().maxOrdinal;
        }
        SnapshotPopulatedOrdinalsReader.readOrdinals(in, this.stateListeners);
    }

    @Override
    public void applyDelta(HollowBlobInput in, HollowSchema schema, ArraySegmentRecycler memoryRecycler) throws IOException {
        if (this.shards.length > 1) {
            this.maxOrdinal = VarInt.readVInt(in);
        }
        for (int i = 0; i < this.shards.length; ++i) {
            HollowSetTypeDataElements deltaData = new HollowSetTypeDataElements(this.memoryMode, memoryRecycler);
            deltaData.readDelta(in);
            if (this.stateEngine.isSkipTypeShardUpdateWithNoAdditions() && deltaData.encodedAdditions.isEmpty()) {
                GapEncodedVariableLengthIntegerReader oldRemovals;
                if (!deltaData.encodedRemovals.isEmpty()) {
                    this.notifyListenerAboutDeltaChanges(deltaData.encodedRemovals, deltaData.encodedAdditions, i, this.shards.length);
                }
                HollowSetTypeDataElements currentData = this.shards[i].currentDataElements();
                GapEncodedVariableLengthIntegerReader gapEncodedVariableLengthIntegerReader = oldRemovals = currentData.encodedRemovals == null ? GapEncodedVariableLengthIntegerReader.EMPTY_READER : currentData.encodedRemovals;
                if (oldRemovals.isEmpty()) {
                    currentData.encodedRemovals = deltaData.encodedRemovals;
                    oldRemovals.destroy();
                } else {
                    if (!deltaData.encodedRemovals.isEmpty()) {
                        currentData.encodedRemovals = GapEncodedVariableLengthIntegerReader.combine(oldRemovals, deltaData.encodedRemovals, memoryRecycler);
                        oldRemovals.destroy();
                    }
                    deltaData.encodedRemovals.destroy();
                }
                deltaData.encodedAdditions.destroy();
            } else {
                HollowSetTypeDataElements nextData = new HollowSetTypeDataElements(this.memoryMode, memoryRecycler);
                HollowSetTypeDataElements oldData = this.shards[i].currentDataElements();
                nextData.applyDelta(oldData, deltaData);
                this.shards[i].setCurrentData(nextData);
                this.notifyListenerAboutDeltaChanges(deltaData.encodedRemovals, deltaData.encodedAdditions, i, this.shards.length);
                oldData.destroy();
            }
            deltaData.destroy();
            this.stateEngine.getMemoryRecycler().swap();
        }
        if (this.shards.length == 1) {
            this.maxOrdinal = this.shards[0].currentDataElements().maxOrdinal;
        }
    }

    public static void discardSnapshot(HollowBlobInput in, int numShards) throws IOException {
        HollowSetTypeReadState.discardType(in, numShards, false);
    }

    public static void discardDelta(HollowBlobInput in, int numShards) throws IOException {
        HollowSetTypeReadState.discardType(in, numShards, true);
    }

    public static void discardType(HollowBlobInput in, int numShards, boolean delta) throws IOException {
        HollowSetTypeDataElements.discardFromStream(in, numShards, delta);
        if (!delta) {
            SnapshotPopulatedOrdinalsReader.discardOrdinals(in);
        }
    }

    @Override
    public int maxOrdinal() {
        return this.maxOrdinal;
    }

    @Override
    public int size(int ordinal) {
        this.sampler.recordSize();
        return this.shards[ordinal & this.shardNumberMask].size(ordinal >> this.shardOrdinalShift);
    }

    @Override
    public boolean contains(int ordinal, int value) {
        return this.contains(ordinal, value, value);
    }

    @Override
    public boolean contains(int ordinal, int value, int hashCode) {
        this.sampler.recordGet();
        return this.shards[ordinal & this.shardNumberMask].contains(ordinal >> this.shardOrdinalShift, value, hashCode);
    }

    @Override
    public int findElement(int ordinal, Object ... hashKey) {
        this.sampler.recordGet();
        if (this.keyDeriver == null) {
            return -1;
        }
        HollowObjectSchema.FieldType[] fieldTypes = this.keyDeriver.getFieldTypes();
        if (hashKey.length != fieldTypes.length) {
            return -1;
        }
        return this.shards[ordinal & this.shardNumberMask].findElement(ordinal >> this.shardOrdinalShift, hashKey);
    }

    @Override
    public int relativeBucketValue(int setOrdinal, int bucketIndex) {
        return this.shards[setOrdinal & this.shardNumberMask].relativeBucketValue(setOrdinal >> this.shardOrdinalShift, bucketIndex);
    }

    @Override
    public HollowOrdinalIterator potentialMatchOrdinalIterator(int ordinal, int hashCode) {
        this.sampler.recordGet();
        if (this.size(ordinal) == 0) {
            return EmptyOrdinalIterator.INSTANCE;
        }
        return new PotentialMatchHollowSetOrdinalIterator(ordinal, this, hashCode);
    }

    @Override
    public HollowOrdinalIterator ordinalIterator(int ordinal) {
        this.sampler.recordIterator();
        if (this.size(ordinal) == 0) {
            return EmptyOrdinalIterator.INSTANCE;
        }
        return new HollowSetOrdinalIterator(ordinal, this);
    }

    @Override
    public HollowSetSchema getSchema() {
        return (HollowSetSchema)this.schema;
    }

    @Override
    public HollowSampler getSampler() {
        return this.sampler;
    }

    @Override
    public void setSamplingDirector(HollowSamplingDirector director) {
        this.sampler.setSamplingDirector(director);
    }

    @Override
    public void setFieldSpecificSamplingDirector(HollowFilterConfig fieldSpec, HollowSamplingDirector director) {
        this.sampler.setFieldSpecificSamplingDirector(fieldSpec, director);
    }

    @Override
    public void ignoreUpdateThreadForSampling(Thread t) {
        this.sampler.setUpdateThread(t);
    }

    @Override
    protected void invalidate() {
        this.stateListeners = EMPTY_LISTENERS;
        for (int i = 0; i < this.shards.length; ++i) {
            this.shards[i].invalidate();
        }
    }

    HollowSetTypeDataElements[] currentDataElements() {
        HollowSetTypeDataElements[] currentDataElements = new HollowSetTypeDataElements[this.shards.length];
        for (int i = 0; i < this.shards.length; ++i) {
            currentDataElements[i] = this.shards[i].currentDataElements();
        }
        return currentDataElements;
    }

    void setCurrentData(HollowSetTypeDataElements data) {
        if (this.shards.length > 1) {
            throw new UnsupportedOperationException("Cannot directly set data on sharded type state");
        }
        this.shards[0].setCurrentData(data);
        this.maxOrdinal = data.maxOrdinal;
    }

    @Override
    protected void applyToChecksum(HollowChecksum checksum, HollowSchema withSchema) {
        if (!this.getSchema().equals(withSchema)) {
            throw new IllegalArgumentException("HollowSetTypeReadState cannot calculate checksum with unequal schemas: " + this.getSchema().getName());
        }
        BitSet populatedOrdinals = this.getListener(PopulatedOrdinalListener.class).getPopulatedOrdinals();
        for (int i = 0; i < this.shards.length; ++i) {
            this.shards[i].applyToChecksum(checksum, populatedOrdinals, i, this.shards.length);
        }
    }

    @Override
    public long getApproximateHeapFootprintInBytes() {
        long totalApproximateHeapFootprintInBytes = 0L;
        for (int i = 0; i < this.shards.length; ++i) {
            totalApproximateHeapFootprintInBytes += this.shards[i].getApproximateHeapFootprintInBytes();
        }
        return totalApproximateHeapFootprintInBytes;
    }

    @Override
    public long getApproximateHoleCostInBytes() {
        long totalApproximateHoleCostInBytes = 0L;
        BitSet populatedOrdinals = this.getPopulatedOrdinals();
        for (int i = 0; i < this.shards.length; ++i) {
            totalApproximateHoleCostInBytes += this.shards[i].getApproximateHoleCostInBytes(populatedOrdinals, i, this.shards.length);
        }
        return totalApproximateHoleCostInBytes;
    }

    public HollowPrimaryKeyValueDeriver getKeyDeriver() {
        return this.keyDeriver;
    }

    public void buildKeyDeriver() {
        if (this.getSchema().getHashKey() != null) {
            this.keyDeriver = new HollowPrimaryKeyValueDeriver(this.getSchema().getHashKey(), this.getStateEngine());
        }
        for (int i = 0; i < this.shards.length; ++i) {
            this.shards[i].setKeyDeriver(this.keyDeriver);
        }
    }

    @Override
    public int numShards() {
        return this.shards.length;
    }
}

