/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.set;

import com.netflix.hollow.core.memory.FixedLengthData;
import com.netflix.hollow.core.memory.FixedLengthDataFactory;
import com.netflix.hollow.core.memory.MemoryMode;
import com.netflix.hollow.core.memory.encoding.GapEncodedVariableLengthIntegerReader;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import com.netflix.hollow.core.read.HollowBlobInput;
import com.netflix.hollow.core.read.engine.set.HollowSetDeltaApplicator;
import java.io.IOException;

public class HollowSetTypeDataElements {
    int maxOrdinal;
    FixedLengthData setPointerAndSizeData;
    FixedLengthData elementData;
    GapEncodedVariableLengthIntegerReader encodedRemovals;
    GapEncodedVariableLengthIntegerReader encodedAdditions;
    int bitsPerSetPointer;
    int bitsPerSetSizeValue;
    int bitsPerFixedLengthSetPortion;
    int bitsPerElement;
    int emptyBucketValue;
    long totalNumberOfBuckets;
    final ArraySegmentRecycler memoryRecycler;
    final MemoryMode memoryMode;

    public HollowSetTypeDataElements(ArraySegmentRecycler memoryRecycler) {
        this(MemoryMode.ON_HEAP, memoryRecycler);
    }

    public HollowSetTypeDataElements(MemoryMode memoryMode, ArraySegmentRecycler memoryRecycler) {
        this.memoryMode = memoryMode;
        this.memoryRecycler = memoryRecycler;
    }

    void readSnapshot(HollowBlobInput in) throws IOException {
        this.readFromInput(in, false);
    }

    void readDelta(HollowBlobInput in) throws IOException {
        this.readFromInput(in, true);
    }

    private void readFromInput(HollowBlobInput in, boolean isDelta) throws IOException {
        this.maxOrdinal = VarInt.readVInt(in);
        if (isDelta) {
            this.encodedRemovals = GapEncodedVariableLengthIntegerReader.readEncodedDeltaOrdinals(in, this.memoryRecycler);
            this.encodedAdditions = GapEncodedVariableLengthIntegerReader.readEncodedDeltaOrdinals(in, this.memoryRecycler);
        }
        this.bitsPerSetPointer = VarInt.readVInt(in);
        this.bitsPerSetSizeValue = VarInt.readVInt(in);
        this.bitsPerElement = VarInt.readVInt(in);
        this.bitsPerFixedLengthSetPortion = this.bitsPerSetPointer + this.bitsPerSetSizeValue;
        this.emptyBucketValue = (1 << this.bitsPerElement) - 1;
        this.totalNumberOfBuckets = VarInt.readVLong(in);
        this.setPointerAndSizeData = FixedLengthDataFactory.get(in, this.memoryMode, this.memoryRecycler);
        this.elementData = FixedLengthDataFactory.get(in, this.memoryMode, this.memoryRecycler);
    }

    static void discardFromStream(HollowBlobInput in, int numShards, boolean isDelta) throws IOException {
        if (numShards > 1) {
            VarInt.readVInt(in);
        }
        for (int i = 0; i < numShards; ++i) {
            VarInt.readVInt(in);
            if (isDelta) {
                GapEncodedVariableLengthIntegerReader.discardEncodedDeltaOrdinals(in);
                GapEncodedVariableLengthIntegerReader.discardEncodedDeltaOrdinals(in);
            }
            VarInt.readVInt(in);
            VarInt.readVInt(in);
            VarInt.readVInt(in);
            VarInt.readVLong(in);
            FixedLengthData.discardFrom(in);
            FixedLengthData.discardFrom(in);
        }
    }

    public void applyDelta(HollowSetTypeDataElements fromData, HollowSetTypeDataElements deltaData) {
        new HollowSetDeltaApplicator(fromData, deltaData, this).applyDelta();
    }

    public void destroy() {
        FixedLengthDataFactory.destroy(this.setPointerAndSizeData, this.memoryRecycler);
        FixedLengthDataFactory.destroy(this.elementData, this.memoryRecycler);
    }
}

