/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.object;

import com.netflix.hollow.core.memory.ByteData;
import com.netflix.hollow.core.memory.HollowUnsafeHandle;
import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.memory.encoding.ZigZag;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeDataElements;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.write.HollowObjectWriteRecord;
import com.netflix.hollow.tools.checksum.HollowChecksum;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;

class HollowObjectTypeReadStateShard {
    private volatile HollowObjectTypeDataElements currentDataVolatile;
    private final HollowObjectSchema schema;
    private static final ThreadLocal<char[]> chararr = new ThreadLocal();

    HollowObjectTypeReadStateShard(HollowObjectSchema schema) {
        this.schema = schema;
    }

    public boolean isNull(int ordinal, int fieldIndex) {
        long fixedLengthValue;
        HollowObjectTypeDataElements currentData;
        do {
            currentData = this.currentDataVolatile;
            long bitOffset = this.fieldOffset(currentData, ordinal, fieldIndex);
            int numBitsForField = currentData.bitsPerField[fieldIndex];
            long l = fixedLengthValue = numBitsForField <= 56 ? currentData.fixedLengthData.getElementValue(bitOffset, numBitsForField) : currentData.fixedLengthData.getLargeElementValue(bitOffset, numBitsForField);
        } while (this.readWasUnsafe(currentData));
        switch (this.schema.getFieldType(fieldIndex)) {
            case BYTES: 
            case STRING: {
                int numBits = currentData.bitsPerField[fieldIndex];
                return (fixedLengthValue & (long)(1 << numBits - 1)) != 0L;
            }
            case FLOAT: {
                return (int)fixedLengthValue == HollowObjectWriteRecord.NULL_FLOAT_BITS;
            }
            case DOUBLE: {
                return fixedLengthValue == HollowObjectWriteRecord.NULL_DOUBLE_BITS;
            }
        }
        return fixedLengthValue == currentData.nullValueForField[fieldIndex];
    }

    public int readOrdinal(int ordinal, int fieldIndex) {
        long refOrdinal;
        HollowObjectTypeDataElements currentData;
        do {
            currentData = this.currentDataVolatile;
            refOrdinal = this.readFixedLengthFieldValue(currentData, ordinal, fieldIndex);
        } while (this.readWasUnsafe(currentData));
        if (refOrdinal == currentData.nullValueForField[fieldIndex]) {
            return -1;
        }
        return (int)refOrdinal;
    }

    public int readInt(int ordinal, int fieldIndex) {
        long value;
        HollowObjectTypeDataElements currentData;
        do {
            currentData = this.currentDataVolatile;
            value = this.readFixedLengthFieldValue(currentData, ordinal, fieldIndex);
        } while (this.readWasUnsafe(currentData));
        if (value == currentData.nullValueForField[fieldIndex]) {
            return Integer.MIN_VALUE;
        }
        return ZigZag.decodeInt((int)value);
    }

    public float readFloat(int ordinal, int fieldIndex) {
        int value;
        HollowObjectTypeDataElements currentData;
        do {
            currentData = this.currentDataVolatile;
            value = (int)this.readFixedLengthFieldValue(currentData, ordinal, fieldIndex);
        } while (this.readWasUnsafe(currentData));
        if (value == HollowObjectWriteRecord.NULL_FLOAT_BITS) {
            return Float.NaN;
        }
        return Float.intBitsToFloat(value);
    }

    public double readDouble(int ordinal, int fieldIndex) {
        long value;
        HollowObjectTypeDataElements currentData;
        do {
            currentData = this.currentDataVolatile;
            long bitOffset = this.fieldOffset(currentData, ordinal, fieldIndex);
            value = currentData.fixedLengthData.getLargeElementValue(bitOffset, 64, -1L);
        } while (this.readWasUnsafe(currentData));
        if (value == HollowObjectWriteRecord.NULL_DOUBLE_BITS) {
            return Double.NaN;
        }
        return Double.longBitsToDouble(value);
    }

    public long readLong(int ordinal, int fieldIndex) {
        long value;
        HollowObjectTypeDataElements currentData;
        do {
            currentData = this.currentDataVolatile;
            long bitOffset = this.fieldOffset(currentData, ordinal, fieldIndex);
            int numBitsForField = currentData.bitsPerField[fieldIndex];
            value = currentData.fixedLengthData.getLargeElementValue(bitOffset, numBitsForField);
        } while (this.readWasUnsafe(currentData));
        if (value == currentData.nullValueForField[fieldIndex]) {
            return Long.MIN_VALUE;
        }
        return ZigZag.decodeLong(value);
    }

    public Boolean readBoolean(int ordinal, int fieldIndex) {
        long value;
        HollowObjectTypeDataElements currentData;
        do {
            currentData = this.currentDataVolatile;
            value = this.readFixedLengthFieldValue(currentData, ordinal, fieldIndex);
        } while (this.readWasUnsafe(currentData));
        if (value == currentData.nullValueForField[fieldIndex]) {
            return null;
        }
        return value == 1L ? Boolean.TRUE : Boolean.FALSE;
    }

    private long readFixedLengthFieldValue(HollowObjectTypeDataElements currentData, int ordinal, int fieldIndex) {
        long bitOffset = this.fieldOffset(currentData, ordinal, fieldIndex);
        int numBitsForField = currentData.bitsPerField[fieldIndex];
        long value = currentData.fixedLengthData.getElementValue(bitOffset, numBitsForField);
        return value;
    }

    /*
     * Unable to fully structure code
     */
    public byte[] readBytes(int ordinal, int fieldIndex) {
        do lbl-1000:
        // 3 sources

        {
            currentData = this.currentDataVolatile;
            numBitsForField = currentData.bitsPerField[fieldIndex];
            currentBitOffset = this.fieldOffset(currentData, ordinal, fieldIndex);
            endByte = currentData.fixedLengthData.getElementValue(currentBitOffset, numBitsForField);
            v0 = startByte = ordinal != 0 ? currentData.fixedLengthData.getElementValue(currentBitOffset - (long)currentData.bitsPerRecord, numBitsForField) : 0L;
            if (this.readWasUnsafe(currentData)) ** GOTO lbl-1000
            if ((endByte & 1L << numBitsForField - 1) != 0L) {
                return null;
            }
            length = (int)(endByte - (startByte &= (1L << numBitsForField - 1) - 1L));
            result = new byte[length];
            for (i = 0; i < length; ++i) {
                result[i] = currentData.varLengthData[fieldIndex].get(startByte + (long)i);
            }
        } while (this.readWasUnsafe(currentData));
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public String readString(int ordinal, int fieldIndex) {
        do lbl-1000:
        // 3 sources

        {
            currentData = this.currentDataVolatile;
            numBitsForField = currentData.bitsPerField[fieldIndex];
            currentBitOffset = this.fieldOffset(currentData, ordinal, fieldIndex);
            endByte = currentData.fixedLengthData.getElementValue(currentBitOffset, numBitsForField);
            v0 = startByte = ordinal != 0 ? currentData.fixedLengthData.getElementValue(currentBitOffset - (long)currentData.bitsPerRecord, numBitsForField) : 0L;
            if (this.readWasUnsafe(currentData)) ** GOTO lbl-1000
            if ((endByte & 1L << numBitsForField - 1) != 0L) {
                return null;
            }
            length = (int)(endByte - (startByte &= (1L << numBitsForField - 1) - 1L));
            result = this.readString(currentData.varLengthData[fieldIndex], startByte, length);
        } while (this.readWasUnsafe(currentData));
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public boolean isStringFieldEqual(int ordinal, int fieldIndex, String testValue) {
        do lbl-1000:
        // 3 sources

        {
            currentData = this.currentDataVolatile;
            numBitsForField = currentData.bitsPerField[fieldIndex];
            currentBitOffset = this.fieldOffset(currentData, ordinal, fieldIndex);
            endByte = currentData.fixedLengthData.getElementValue(currentBitOffset, numBitsForField);
            v0 = startByte = ordinal != 0 ? currentData.fixedLengthData.getElementValue(currentBitOffset - (long)currentData.bitsPerRecord, numBitsForField) : 0L;
            if (this.readWasUnsafe(currentData)) ** GOTO lbl-1000
            if ((endByte & 1L << numBitsForField - 1) != 0L) {
                return testValue == null;
            }
            if (testValue == null) {
                return false;
            }
            length = (int)(endByte - (startByte &= (1L << numBitsForField - 1) - 1L));
            result = this.testStringEquality(currentData.varLengthData[fieldIndex], startByte, length, testValue);
        } while (this.readWasUnsafe(currentData));
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public int findVarLengthFieldHashCode(int ordinal, int fieldIndex) {
        do lbl-1000:
        // 3 sources

        {
            currentData = this.currentDataVolatile;
            numBitsForField = currentData.bitsPerField[fieldIndex];
            currentBitOffset = this.fieldOffset(currentData, ordinal, fieldIndex);
            endByte = currentData.fixedLengthData.getElementValue(currentBitOffset, numBitsForField);
            v0 = startByte = ordinal != 0 ? currentData.fixedLengthData.getElementValue(currentBitOffset - (long)currentData.bitsPerRecord, numBitsForField) : 0L;
            if (this.readWasUnsafe(currentData)) ** GOTO lbl-1000
            if ((endByte & 1L << numBitsForField - 1) != 0L) {
                return -1;
            }
            length = (int)(endByte - (startByte &= (1L << numBitsForField - 1) - 1L));
            hashCode = HashCodes.hashCode(currentData.varLengthData[fieldIndex], startByte, length);
        } while (this.readWasUnsafe(currentData));
        return hashCode;
    }

    public int bitsRequiredForField(String fieldName) {
        int fieldIndex = this.schema.getPosition(fieldName);
        return fieldIndex == -1 ? 0 : this.currentDataVolatile.bitsPerField[fieldIndex];
    }

    private long fieldOffset(HollowObjectTypeDataElements currentData, int ordinal, int fieldIndex) {
        return (long)currentData.bitsPerRecord * (long)ordinal + (long)currentData.bitOffsetPerField[fieldIndex];
    }

    private String readString(ByteData data, long position, int length) {
        long endPosition = position + (long)length;
        char[] chararr = this.getCharArray();
        if (length > chararr.length) {
            chararr = new char[length];
        }
        int count = 0;
        while (position < endPosition) {
            int c = VarInt.readVInt(data, position);
            chararr[count++] = (char)c;
            position += (long)VarInt.sizeOfVInt(c);
        }
        return new String(chararr, 0, count);
    }

    private boolean testStringEquality(ByteData data, long position, int length, String testValue) {
        if (length < testValue.length()) {
            return false;
        }
        long endPosition = position + (long)length;
        int count = 0;
        while (position < endPosition && count < testValue.length()) {
            int c = VarInt.readVInt(data, position);
            if (testValue.charAt(count++) != (char)c) {
                return false;
            }
            position += (long)VarInt.sizeOfVInt(c);
        }
        return position == endPosition && count == testValue.length();
    }

    private char[] getCharArray() {
        char[] ch = chararr.get();
        if (ch == null) {
            ch = new char[100];
            chararr.set(ch);
        }
        return ch;
    }

    void invalidate() {
        this.setCurrentData(null);
    }

    HollowObjectTypeDataElements currentDataElements() {
        return this.currentDataVolatile;
    }

    private boolean readWasUnsafe(HollowObjectTypeDataElements data) {
        HollowUnsafeHandle.getUnsafe().loadFence();
        return data != this.currentDataVolatile;
    }

    void setCurrentData(HollowObjectTypeDataElements data) {
        this.currentDataVolatile = data;
    }

    protected void applyToChecksum(HollowChecksum checksum, HollowSchema withSchema, BitSet populatedOrdinals, int shardNumber, int numShards) {
        if (!(withSchema instanceof HollowObjectSchema)) {
            throw new IllegalArgumentException("HollowObjectTypeReadState can only calculate checksum with a HollowObjectSchema: " + this.schema.getName());
        }
        HollowObjectSchema commonSchema = this.schema.findCommonSchema((HollowObjectSchema)withSchema);
        ArrayList<String> commonFieldNames = new ArrayList<String>();
        for (int i = 0; i < commonSchema.numFields(); ++i) {
            commonFieldNames.add(commonSchema.getFieldName(i));
        }
        Collections.sort(commonFieldNames);
        int[] fieldIndexes = new int[commonFieldNames.size()];
        for (int i = 0; i < commonFieldNames.size(); ++i) {
            fieldIndexes[i] = this.schema.getPosition((String)commonFieldNames.get(i));
        }
        HollowObjectTypeDataElements currentData = this.currentDataVolatile;
        int ordinal = populatedOrdinals.nextSetBit(0);
        while (ordinal != -1) {
            if ((ordinal & numShards - 1) == shardNumber) {
                int shardOrdinal = ordinal / numShards;
                checksum.applyInt(ordinal);
                for (int i = 0; i < fieldIndexes.length; ++i) {
                    int fieldIdx = fieldIndexes[i];
                    if (!this.schema.getFieldType(fieldIdx).isVariableLength()) {
                        long fixedLengthValue;
                        long bitOffset = this.fieldOffset(currentData, shardOrdinal, fieldIdx);
                        int numBitsForField = currentData.bitsPerField[fieldIdx];
                        long l = fixedLengthValue = numBitsForField <= 56 ? currentData.fixedLengthData.getElementValue(bitOffset, numBitsForField) : currentData.fixedLengthData.getLargeElementValue(bitOffset, numBitsForField);
                        if (fixedLengthValue == currentData.nullValueForField[fieldIdx]) {
                            checksum.applyInt(Integer.MAX_VALUE);
                            continue;
                        }
                        checksum.applyLong(fixedLengthValue);
                        continue;
                    }
                    checksum.applyInt(this.findVarLengthFieldHashCode(shardOrdinal, fieldIdx));
                }
            }
            ordinal = populatedOrdinals.nextSetBit(ordinal + 1);
        }
    }

    public long getApproximateHeapFootprintInBytes() {
        HollowObjectTypeDataElements currentData = this.currentDataVolatile;
        long bitsPerFixedLengthData = (long)currentData.bitsPerRecord * (long)(currentData.maxOrdinal + 1);
        long requiredBytes = bitsPerFixedLengthData / 8L;
        for (int i = 0; i < currentData.varLengthData.length; ++i) {
            if (currentData.varLengthData[i] == null) continue;
            requiredBytes += currentData.varLengthData[i].size();
        }
        return requiredBytes;
    }

    public long getApproximateHoleCostInBytes(BitSet populatedOrdinals, int shardNumber, int numShards) {
        HollowObjectTypeDataElements currentData = this.currentDataVolatile;
        long holeBits = 0L;
        int holeOrdinal = populatedOrdinals.nextClearBit(0);
        while (holeOrdinal <= currentData.maxOrdinal) {
            if ((holeOrdinal & numShards - 1) == shardNumber) {
                holeBits += (long)currentData.bitsPerRecord;
            }
            holeOrdinal = populatedOrdinals.nextClearBit(holeOrdinal + 1);
        }
        return holeBits / 8L;
    }
}

