/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.object;

import com.netflix.hollow.api.sampling.DisabledSamplingDirector;
import com.netflix.hollow.api.sampling.HollowObjectSampler;
import com.netflix.hollow.api.sampling.HollowSampler;
import com.netflix.hollow.api.sampling.HollowSamplingDirector;
import com.netflix.hollow.core.memory.MemoryMode;
import com.netflix.hollow.core.memory.encoding.GapEncodedVariableLengthIntegerReader;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import com.netflix.hollow.core.read.HollowBlobInput;
import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.engine.SnapshotPopulatedOrdinalsReader;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeDataElements;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadStateShard;
import com.netflix.hollow.core.read.filter.HollowFilterConfig;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.tools.checksum.HollowChecksum;
import java.io.IOException;
import java.util.BitSet;

public class HollowObjectTypeReadState
extends HollowTypeReadState
implements HollowObjectTypeDataAccess {
    private final HollowObjectSchema unfilteredSchema;
    private final HollowObjectSampler sampler;
    private final int shardNumberMask;
    private final int shardOrdinalShift;
    private final HollowObjectTypeReadStateShard[] shards;
    private int maxOrdinal;

    public HollowObjectTypeReadState(HollowReadStateEngine fileEngine, HollowObjectSchema schema) {
        this(fileEngine, MemoryMode.ON_HEAP, schema, schema, 1);
    }

    public HollowObjectTypeReadState(HollowReadStateEngine fileEngine, MemoryMode memoryMode, HollowObjectSchema schema, HollowObjectSchema unfilteredSchema, int numShards) {
        super(fileEngine, memoryMode, schema);
        this.sampler = new HollowObjectSampler(schema, DisabledSamplingDirector.INSTANCE);
        this.unfilteredSchema = unfilteredSchema;
        this.shardNumberMask = numShards - 1;
        this.shardOrdinalShift = 31 - Integer.numberOfLeadingZeros(numShards);
        if (numShards < 1 || 1 << this.shardOrdinalShift != numShards) {
            throw new IllegalArgumentException("Number of shards must be a power of 2!");
        }
        HollowObjectTypeReadStateShard[] shards = new HollowObjectTypeReadStateShard[numShards];
        for (int i = 0; i < shards.length; ++i) {
            shards[i] = new HollowObjectTypeReadStateShard(schema);
        }
        this.shards = shards;
    }

    @Override
    public HollowObjectSchema getSchema() {
        return (HollowObjectSchema)this.schema;
    }

    @Override
    public int maxOrdinal() {
        return this.maxOrdinal;
    }

    @Override
    public void readSnapshot(HollowBlobInput in, ArraySegmentRecycler memoryRecycler) throws IOException {
        if (this.shards.length > 1) {
            this.maxOrdinal = VarInt.readVInt(in);
        }
        for (int i = 0; i < this.shards.length; ++i) {
            HollowObjectTypeDataElements snapshotData = new HollowObjectTypeDataElements(this.getSchema(), this.memoryMode, memoryRecycler);
            snapshotData.readSnapshot(in, this.unfilteredSchema);
            this.shards[i].setCurrentData(snapshotData);
        }
        if (this.shards.length == 1) {
            this.maxOrdinal = this.shards[0].currentDataElements().maxOrdinal;
        }
        SnapshotPopulatedOrdinalsReader.readOrdinals(in, this.stateListeners);
    }

    @Override
    public void applyDelta(HollowBlobInput in, HollowSchema deltaSchema, ArraySegmentRecycler memoryRecycler) throws IOException {
        if (this.shards.length > 1) {
            this.maxOrdinal = VarInt.readVInt(in);
        }
        for (int i = 0; i < this.shards.length; ++i) {
            HollowObjectTypeDataElements deltaData = new HollowObjectTypeDataElements((HollowObjectSchema)deltaSchema, this.memoryMode, memoryRecycler);
            deltaData.readDelta(in);
            if (this.stateEngine.isSkipTypeShardUpdateWithNoAdditions() && deltaData.encodedAdditions.isEmpty()) {
                GapEncodedVariableLengthIntegerReader oldRemovals;
                if (!deltaData.encodedRemovals.isEmpty()) {
                    this.notifyListenerAboutDeltaChanges(deltaData.encodedRemovals, deltaData.encodedAdditions, i, this.shards.length);
                }
                HollowObjectTypeDataElements currentData = this.shards[i].currentDataElements();
                GapEncodedVariableLengthIntegerReader gapEncodedVariableLengthIntegerReader = oldRemovals = currentData.encodedRemovals == null ? GapEncodedVariableLengthIntegerReader.EMPTY_READER : currentData.encodedRemovals;
                if (oldRemovals.isEmpty()) {
                    currentData.encodedRemovals = deltaData.encodedRemovals;
                    oldRemovals.destroy();
                } else {
                    if (!deltaData.encodedRemovals.isEmpty()) {
                        currentData.encodedRemovals = GapEncodedVariableLengthIntegerReader.combine(oldRemovals, deltaData.encodedRemovals, memoryRecycler);
                        oldRemovals.destroy();
                    }
                    deltaData.encodedRemovals.destroy();
                }
                deltaData.encodedAdditions.destroy();
            } else {
                HollowObjectTypeDataElements nextData = new HollowObjectTypeDataElements(this.getSchema(), this.memoryMode, memoryRecycler);
                HollowObjectTypeDataElements oldData = this.shards[i].currentDataElements();
                nextData.applyDelta(oldData, deltaData);
                this.shards[i].setCurrentData(nextData);
                this.notifyListenerAboutDeltaChanges(deltaData.encodedRemovals, deltaData.encodedAdditions, i, this.shards.length);
                oldData.destroy();
            }
            deltaData.destroy();
            this.stateEngine.getMemoryRecycler().swap();
        }
        if (this.shards.length == 1) {
            this.maxOrdinal = this.shards[0].currentDataElements().maxOrdinal;
        }
    }

    public static void discardSnapshot(HollowBlobInput in, HollowObjectSchema schema, int numShards) throws IOException {
        HollowObjectTypeReadState.discardType(in, schema, numShards, false);
    }

    public static void discardDelta(HollowBlobInput in, HollowObjectSchema schema, int numShards) throws IOException {
        HollowObjectTypeReadState.discardType(in, schema, numShards, true);
    }

    public static void discardType(HollowBlobInput in, HollowObjectSchema schema, int numShards, boolean delta) throws IOException {
        HollowObjectTypeDataElements.discardFromInput(in, schema, numShards, delta);
        if (!delta) {
            SnapshotPopulatedOrdinalsReader.discardOrdinals(in);
        }
    }

    @Override
    public boolean isNull(int ordinal, int fieldIndex) {
        this.sampler.recordFieldAccess(fieldIndex);
        return this.shards[ordinal & this.shardNumberMask].isNull(ordinal >> this.shardOrdinalShift, fieldIndex);
    }

    @Override
    public int readOrdinal(int ordinal, int fieldIndex) {
        this.sampler.recordFieldAccess(fieldIndex);
        return this.shards[ordinal & this.shardNumberMask].readOrdinal(ordinal >> this.shardOrdinalShift, fieldIndex);
    }

    @Override
    public int readInt(int ordinal, int fieldIndex) {
        this.sampler.recordFieldAccess(fieldIndex);
        return this.shards[ordinal & this.shardNumberMask].readInt(ordinal >> this.shardOrdinalShift, fieldIndex);
    }

    @Override
    public float readFloat(int ordinal, int fieldIndex) {
        this.sampler.recordFieldAccess(fieldIndex);
        return this.shards[ordinal & this.shardNumberMask].readFloat(ordinal >> this.shardOrdinalShift, fieldIndex);
    }

    @Override
    public double readDouble(int ordinal, int fieldIndex) {
        this.sampler.recordFieldAccess(fieldIndex);
        return this.shards[ordinal & this.shardNumberMask].readDouble(ordinal >> this.shardOrdinalShift, fieldIndex);
    }

    @Override
    public long readLong(int ordinal, int fieldIndex) {
        this.sampler.recordFieldAccess(fieldIndex);
        return this.shards[ordinal & this.shardNumberMask].readLong(ordinal >> this.shardOrdinalShift, fieldIndex);
    }

    @Override
    public Boolean readBoolean(int ordinal, int fieldIndex) {
        this.sampler.recordFieldAccess(fieldIndex);
        return this.shards[ordinal & this.shardNumberMask].readBoolean(ordinal >> this.shardOrdinalShift, fieldIndex);
    }

    @Override
    public byte[] readBytes(int ordinal, int fieldIndex) {
        this.sampler.recordFieldAccess(fieldIndex);
        return this.shards[ordinal & this.shardNumberMask].readBytes(ordinal >> this.shardOrdinalShift, fieldIndex);
    }

    @Override
    public String readString(int ordinal, int fieldIndex) {
        this.sampler.recordFieldAccess(fieldIndex);
        return this.shards[ordinal & this.shardNumberMask].readString(ordinal >> this.shardOrdinalShift, fieldIndex);
    }

    @Override
    public boolean isStringFieldEqual(int ordinal, int fieldIndex, String testValue) {
        this.sampler.recordFieldAccess(fieldIndex);
        return this.shards[ordinal & this.shardNumberMask].isStringFieldEqual(ordinal >> this.shardOrdinalShift, fieldIndex, testValue);
    }

    @Override
    public int findVarLengthFieldHashCode(int ordinal, int fieldIndex) {
        this.sampler.recordFieldAccess(fieldIndex);
        return this.shards[ordinal & this.shardNumberMask].findVarLengthFieldHashCode(ordinal >> this.shardOrdinalShift, fieldIndex);
    }

    public int bitsRequiredForField(String fieldName) {
        int maxBitsRequiredForField = this.shards[0].bitsRequiredForField(fieldName);
        for (int i = 1; i < this.shards.length; ++i) {
            int shardRequiredBits = this.shards[i].bitsRequiredForField(fieldName);
            if (shardRequiredBits <= maxBitsRequiredForField) continue;
            maxBitsRequiredForField = shardRequiredBits;
        }
        return maxBitsRequiredForField;
    }

    @Override
    public HollowSampler getSampler() {
        return this.sampler;
    }

    @Override
    protected void invalidate() {
        this.stateListeners = EMPTY_LISTENERS;
        for (int i = 0; i < this.shards.length; ++i) {
            this.shards[i].invalidate();
        }
    }

    @Override
    public void setSamplingDirector(HollowSamplingDirector director) {
        this.sampler.setSamplingDirector(director);
    }

    @Override
    public void setFieldSpecificSamplingDirector(HollowFilterConfig fieldSpec, HollowSamplingDirector director) {
        this.sampler.setFieldSpecificSamplingDirector(fieldSpec, director);
    }

    @Override
    public void ignoreUpdateThreadForSampling(Thread t) {
        this.sampler.setUpdateThread(t);
    }

    HollowObjectTypeDataElements[] currentDataElements() {
        HollowObjectTypeDataElements[] currentDataElements = new HollowObjectTypeDataElements[this.shards.length];
        for (int i = 0; i < this.shards.length; ++i) {
            currentDataElements[i] = this.shards[i].currentDataElements();
        }
        return currentDataElements;
    }

    @Override
    protected void applyToChecksum(HollowChecksum checksum, HollowSchema withSchema) {
        if (!(withSchema instanceof HollowObjectSchema)) {
            throw new IllegalArgumentException("HollowObjectTypeReadState can only calculate checksum with a HollowObjectSchema: " + this.getSchema().getName());
        }
        BitSet populatedOrdinals = this.getPopulatedOrdinals();
        for (int i = 0; i < this.shards.length; ++i) {
            this.shards[i].applyToChecksum(checksum, withSchema, populatedOrdinals, i, this.shards.length);
        }
    }

    @Override
    public long getApproximateHeapFootprintInBytes() {
        long totalApproximateHeapFootprintInBytes = 0L;
        for (int i = 0; i < this.shards.length; ++i) {
            totalApproximateHeapFootprintInBytes += this.shards[i].getApproximateHeapFootprintInBytes();
        }
        return totalApproximateHeapFootprintInBytes;
    }

    @Override
    public long getApproximateHoleCostInBytes() {
        long totalApproximateHoleCostInBytes = 0L;
        BitSet populatedOrdinals = this.getPopulatedOrdinals();
        for (int i = 0; i < this.shards.length; ++i) {
            totalApproximateHoleCostInBytes += this.shards[i].getApproximateHoleCostInBytes(populatedOrdinals, i, this.shards.length);
        }
        return totalApproximateHoleCostInBytes;
    }

    void setCurrentData(HollowObjectTypeDataElements data) {
        if (this.shards.length > 1) {
            throw new UnsupportedOperationException("Cannot directly set data on sharded type state");
        }
        this.shards[0].setCurrentData(data);
        this.maxOrdinal = data.maxOrdinal;
    }

    @Override
    public int numShards() {
        return this.shards.length;
    }
}

