/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.object;

import com.netflix.hollow.core.memory.FixedLengthData;
import com.netflix.hollow.core.memory.FixedLengthDataFactory;
import com.netflix.hollow.core.memory.MemoryMode;
import com.netflix.hollow.core.memory.VariableLengthData;
import com.netflix.hollow.core.memory.VariableLengthDataFactory;
import com.netflix.hollow.core.memory.encoding.FixedLengthElementArray;
import com.netflix.hollow.core.memory.encoding.GapEncodedVariableLengthIntegerReader;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import com.netflix.hollow.core.read.HollowBlobInput;
import com.netflix.hollow.core.read.engine.object.HollowObjectDeltaApplicator;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import java.io.IOException;

public class HollowObjectTypeDataElements {
    final HollowObjectSchema schema;
    int maxOrdinal;
    FixedLengthData fixedLengthData;
    final VariableLengthData[] varLengthData;
    GapEncodedVariableLengthIntegerReader encodedAdditions;
    GapEncodedVariableLengthIntegerReader encodedRemovals;
    final int[] bitsPerField;
    final int[] bitOffsetPerField;
    final long[] nullValueForField;
    int bitsPerRecord;
    private int[] bitsPerUnfilteredField;
    private boolean[] unfilteredFieldIsIncluded;
    final ArraySegmentRecycler memoryRecycler;
    final MemoryMode memoryMode;

    public HollowObjectTypeDataElements(HollowObjectSchema schema, ArraySegmentRecycler memoryRecycler) {
        this(schema, MemoryMode.ON_HEAP, memoryRecycler);
    }

    public HollowObjectTypeDataElements(HollowObjectSchema schema, MemoryMode memoryMode, ArraySegmentRecycler memoryRecycler) {
        this.varLengthData = new VariableLengthData[schema.numFields()];
        this.bitsPerField = new int[schema.numFields()];
        this.bitOffsetPerField = new int[schema.numFields()];
        this.nullValueForField = new long[schema.numFields()];
        this.schema = schema;
        this.memoryMode = memoryMode;
        this.memoryRecycler = memoryRecycler;
    }

    void readSnapshot(HollowBlobInput in, HollowObjectSchema unfilteredSchema) throws IOException {
        this.readFromInput(in, false, unfilteredSchema);
    }

    void readDelta(HollowBlobInput in) throws IOException {
        this.readFromInput(in, true, this.schema);
    }

    void readFromInput(HollowBlobInput in, boolean isDelta, HollowObjectSchema unfilteredSchema) throws IOException {
        this.maxOrdinal = VarInt.readVInt(in);
        if (isDelta) {
            this.encodedRemovals = GapEncodedVariableLengthIntegerReader.readEncodedDeltaOrdinals(in, this.memoryRecycler);
            this.encodedAdditions = GapEncodedVariableLengthIntegerReader.readEncodedDeltaOrdinals(in, this.memoryRecycler);
        }
        this.readFieldStatistics(in, unfilteredSchema);
        this.fixedLengthData = FixedLengthDataFactory.get(in, this.memoryMode, this.memoryRecycler);
        this.removeExcludedFieldsFromFixedLengthData();
        this.readVarLengthData(in, unfilteredSchema);
    }

    private void removeExcludedFieldsFromFixedLengthData() {
        if (this.bitsPerField.length < this.bitsPerUnfilteredField.length) {
            long numBitsRequired = (long)this.bitsPerRecord * (long)(this.maxOrdinal + 1);
            FixedLengthElementArray filteredData = new FixedLengthElementArray(this.memoryRecycler, numBitsRequired);
            long currentReadBit = 0L;
            long currentWriteBit = 0L;
            for (int i = 0; i <= this.maxOrdinal; ++i) {
                for (int j = 0; j < this.bitsPerUnfilteredField.length; ++j) {
                    if (this.unfilteredFieldIsIncluded[j]) {
                        long value = this.bitsPerUnfilteredField[j] < 56 ? this.fixedLengthData.getElementValue(currentReadBit, this.bitsPerUnfilteredField[j]) : this.fixedLengthData.getLargeElementValue(currentReadBit, this.bitsPerUnfilteredField[j]);
                        filteredData.setElementValue(currentWriteBit, this.bitsPerUnfilteredField[j], value);
                        currentWriteBit += (long)this.bitsPerUnfilteredField[j];
                    }
                    currentReadBit += (long)this.bitsPerUnfilteredField[j];
                }
            }
            FixedLengthDataFactory.destroy(this.fixedLengthData, this.memoryRecycler);
            this.memoryRecycler.swap();
            this.fixedLengthData = filteredData;
        }
    }

    private void readFieldStatistics(HollowBlobInput in, HollowObjectSchema unfilteredSchema) throws IOException {
        this.bitsPerRecord = 0;
        this.bitsPerUnfilteredField = new int[unfilteredSchema.numFields()];
        this.unfilteredFieldIsIncluded = new boolean[unfilteredSchema.numFields()];
        int filteredFieldIdx = 0;
        for (int i = 0; i < unfilteredSchema.numFields(); ++i) {
            int readBitsPerField;
            this.bitsPerUnfilteredField[i] = readBitsPerField = VarInt.readVInt(in);
            boolean bl = this.unfilteredFieldIsIncluded[i] = this.schema.getPosition(unfilteredSchema.getFieldName(i)) != -1;
            if (!this.unfilteredFieldIsIncluded[i]) continue;
            this.bitsPerField[filteredFieldIdx] = readBitsPerField;
            this.nullValueForField[filteredFieldIdx] = this.bitsPerField[filteredFieldIdx] == 64 ? -1L : (1L << this.bitsPerField[filteredFieldIdx]) - 1L;
            this.bitOffsetPerField[filteredFieldIdx] = this.bitsPerRecord;
            this.bitsPerRecord += this.bitsPerField[filteredFieldIdx];
            ++filteredFieldIdx;
        }
    }

    private void readVarLengthData(HollowBlobInput in, HollowObjectSchema unfilteredSchema) throws IOException {
        int filteredFieldIdx = 0;
        for (int i = 0; i < unfilteredSchema.numFields(); ++i) {
            long numBytesInVarLengthData;
            if (this.schema.getPosition(unfilteredSchema.getFieldName(i)) != -1) {
                if (numBytesInVarLengthData != 0L) {
                    this.varLengthData[filteredFieldIdx] = VariableLengthDataFactory.get(this.memoryMode, this.memoryRecycler);
                    this.varLengthData[filteredFieldIdx].loadFrom(in, numBytesInVarLengthData);
                }
                ++filteredFieldIdx;
                continue;
            }
            for (numBytesInVarLengthData = VarInt.readVLong(in); numBytesInVarLengthData > 0L; numBytesInVarLengthData -= in.skipBytes(numBytesInVarLengthData)) {
            }
        }
    }

    static void discardFromInput(HollowBlobInput in, HollowObjectSchema schema, int numShards, boolean isDelta) throws IOException {
        if (numShards > 1) {
            VarInt.readVInt(in);
        }
        for (int i = 0; i < numShards; ++i) {
            int j;
            VarInt.readVInt(in);
            if (isDelta) {
                GapEncodedVariableLengthIntegerReader.discardEncodedDeltaOrdinals(in);
                GapEncodedVariableLengthIntegerReader.discardEncodedDeltaOrdinals(in);
            }
            for (j = 0; j < schema.numFields(); ++j) {
                VarInt.readVInt(in);
            }
            FixedLengthData.discardFrom(in);
            for (j = 0; j < schema.numFields(); ++j) {
                for (long numBytesInVarLengthData = VarInt.readVLong(in); numBytesInVarLengthData > 0L; numBytesInVarLengthData -= in.skipBytes(numBytesInVarLengthData)) {
                }
            }
        }
    }

    void applyDelta(HollowObjectTypeDataElements fromData, HollowObjectTypeDataElements deltaData) {
        new HollowObjectDeltaApplicator(fromData, deltaData, this).applyDelta();
    }

    public void destroy() {
        FixedLengthDataFactory.destroy(this.fixedLengthData, this.memoryRecycler);
        for (int i = 0; i < this.varLengthData.length; ++i) {
            if (this.varLengthData[i] == null) continue;
            VariableLengthDataFactory.destroy(this.varLengthData[i]);
        }
    }
}

