/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.object;

import com.netflix.hollow.core.memory.SegmentedByteArray;
import com.netflix.hollow.core.memory.encoding.FixedLengthElementArray;
import com.netflix.hollow.core.memory.pool.WastefulRecycler;
import com.netflix.hollow.core.read.engine.PopulatedOrdinalListener;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeDataElements;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.util.IntMap;
import com.netflix.hollow.core.util.RemovedOrdinalIterator;

public class HollowObjectDeltaHistoricalStateCreator {
    private final HollowObjectTypeReadState typeState;
    private final HollowObjectTypeDataElements[] stateEngineDataElements;
    private final HollowObjectTypeDataElements historicalDataElements;
    private final RemovedOrdinalIterator iter;
    private final int shardNumberMask;
    private final int shardOrdinalShift;
    private IntMap ordinalMapping;
    private int nextOrdinal;
    private final long[] currentWriteVarLengthDataPointers;

    public HollowObjectDeltaHistoricalStateCreator(HollowObjectTypeReadState typeState) {
        this.typeState = typeState;
        this.stateEngineDataElements = typeState.currentDataElements();
        this.historicalDataElements = new HollowObjectTypeDataElements(typeState.getSchema(), WastefulRecycler.DEFAULT_INSTANCE);
        this.iter = new RemovedOrdinalIterator(typeState.getListener(PopulatedOrdinalListener.class));
        this.currentWriteVarLengthDataPointers = new long[typeState.getSchema().numFields()];
        this.shardNumberMask = this.stateEngineDataElements.length - 1;
        this.shardOrdinalShift = 31 - Integer.numberOfLeadingZeros(this.stateEngineDataElements.length);
    }

    public void populateHistory() {
        this.populateStats();
        this.historicalDataElements.fixedLengthData = new FixedLengthElementArray(this.historicalDataElements.memoryRecycler, (long)this.historicalDataElements.bitsPerRecord * (long)(this.historicalDataElements.maxOrdinal + 1));
        for (int i = 0; i < this.historicalDataElements.schema.numFields(); ++i) {
            if (this.stateEngineDataElements[0].varLengthData[i] == null) continue;
            this.historicalDataElements.varLengthData[i] = new SegmentedByteArray(this.historicalDataElements.memoryRecycler);
        }
        this.iter.reset();
        int ordinal = this.iter.next();
        while (ordinal != -1) {
            this.ordinalMapping.put(ordinal, this.nextOrdinal);
            this.copyRecord(ordinal);
            ordinal = this.iter.next();
        }
    }

    public IntMap getOrdinalMapping() {
        return this.ordinalMapping;
    }

    public HollowObjectTypeReadState createHistoricalTypeReadState() {
        HollowObjectTypeReadState historicalTypeState = new HollowObjectTypeReadState(null, this.typeState.getSchema());
        historicalTypeState.setCurrentData(this.historicalDataElements);
        return historicalTypeState;
    }

    private void populateStats() {
        int i;
        this.iter.reset();
        int removedEntryCount = 0;
        long[] totalVarLengthSizes = new long[this.stateEngineDataElements[0].varLengthData.length];
        int ordinal = this.iter.next();
        while (ordinal != -1) {
            ++removedEntryCount;
            for (i = 0; i < totalVarLengthSizes.length; ++i) {
                if (this.stateEngineDataElements[0].varLengthData[i] == null) continue;
                int n = i;
                totalVarLengthSizes[n] = totalVarLengthSizes[n] + this.varLengthSize(ordinal, i);
            }
            ordinal = this.iter.next();
        }
        this.historicalDataElements.maxOrdinal = removedEntryCount - 1;
        for (i = 0; i < this.stateEngineDataElements[0].bitsPerField.length; ++i) {
            this.historicalDataElements.bitsPerField[i] = this.stateEngineDataElements[0].varLengthData[i] == null ? this.stateEngineDataElements[0].bitsPerField[i] : 64 - Long.numberOfLeadingZeros(totalVarLengthSizes[i] + 1L) + 1;
            this.historicalDataElements.nullValueForField[i] = (1L << this.historicalDataElements.bitsPerField[i]) - 1L;
            this.historicalDataElements.bitOffsetPerField[i] = this.historicalDataElements.bitsPerRecord;
            this.historicalDataElements.bitsPerRecord += this.historicalDataElements.bitsPerField[i];
        }
        this.ordinalMapping = new IntMap(removedEntryCount);
    }

    private long varLengthSize(int ordinal, int fieldIdx) {
        int shard = ordinal & this.shardNumberMask;
        int shardOrdinal = ordinal >> this.shardOrdinalShift;
        int numBitsForField = this.stateEngineDataElements[shard].bitsPerField[fieldIdx];
        long currentBitOffset = (long)this.stateEngineDataElements[shard].bitsPerRecord * (long)shardOrdinal + (long)this.stateEngineDataElements[shard].bitOffsetPerField[fieldIdx];
        long endByte = this.stateEngineDataElements[shard].fixedLengthData.getElementValue(currentBitOffset, numBitsForField) & (1L << numBitsForField - 1) - 1L;
        long startByte = shardOrdinal != 0 ? this.stateEngineDataElements[shard].fixedLengthData.getElementValue(currentBitOffset - (long)this.stateEngineDataElements[shard].bitsPerRecord, numBitsForField) & (1L << numBitsForField - 1) - 1L : 0L;
        return endByte - startByte;
    }

    private void copyRecord(int ordinal) {
        int shard = ordinal & this.shardNumberMask;
        int shardOrdinal = ordinal >> this.shardOrdinalShift;
        for (int i = 0; i < this.historicalDataElements.schema.numFields(); ++i) {
            if (this.historicalDataElements.varLengthData[i] == null) {
                long value = this.stateEngineDataElements[shard].fixedLengthData.getLargeElementValue((long)shardOrdinal * (long)this.stateEngineDataElements[shard].bitsPerRecord + (long)this.stateEngineDataElements[shard].bitOffsetPerField[i], this.stateEngineDataElements[shard].bitsPerField[i]);
                this.historicalDataElements.fixedLengthData.setElementValue((long)this.nextOrdinal * (long)this.historicalDataElements.bitsPerRecord + (long)this.historicalDataElements.bitOffsetPerField[i], this.historicalDataElements.bitsPerField[i], value);
                continue;
            }
            long fromStartByte = this.varLengthStartByte(shard, shardOrdinal, i);
            long fromEndByte = this.varLengthEndByte(shard, shardOrdinal, i);
            long size = fromEndByte - fromStartByte;
            this.historicalDataElements.fixedLengthData.setElementValue((long)this.nextOrdinal * (long)this.historicalDataElements.bitsPerRecord + (long)this.historicalDataElements.bitOffsetPerField[i], this.historicalDataElements.bitsPerField[i], this.currentWriteVarLengthDataPointers[i] + size);
            this.historicalDataElements.varLengthData[i].copy(this.stateEngineDataElements[shard].varLengthData[i], fromStartByte, this.currentWriteVarLengthDataPointers[i], size);
            int n = i;
            this.currentWriteVarLengthDataPointers[n] = this.currentWriteVarLengthDataPointers[n] + size;
        }
        ++this.nextOrdinal;
    }

    private long varLengthStartByte(int shard, int translatedOrdinal, int fieldIdx) {
        if (translatedOrdinal == 0) {
            return 0L;
        }
        int numBitsForField = this.stateEngineDataElements[shard].bitsPerField[fieldIdx];
        long currentBitOffset = (long)this.stateEngineDataElements[shard].bitsPerRecord * (long)translatedOrdinal + (long)this.stateEngineDataElements[shard].bitOffsetPerField[fieldIdx];
        long startByte = this.stateEngineDataElements[shard].fixedLengthData.getElementValue(currentBitOffset - (long)this.stateEngineDataElements[shard].bitsPerRecord, numBitsForField) & (1L << numBitsForField - 1) - 1L;
        return startByte;
    }

    private long varLengthEndByte(int shard, int translatedOrdinal, int fieldIdx) {
        int numBitsForField = this.stateEngineDataElements[shard].bitsPerField[fieldIdx];
        long currentBitOffset = (long)this.stateEngineDataElements[shard].bitsPerRecord * (long)translatedOrdinal + (long)this.stateEngineDataElements[shard].bitOffsetPerField[fieldIdx];
        long endByte = this.stateEngineDataElements[shard].fixedLengthData.getElementValue(currentBitOffset, numBitsForField) & (1L << numBitsForField - 1) - 1L;
        return endByte;
    }
}

