/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.map;

import com.netflix.hollow.core.index.key.HollowPrimaryKeyValueDeriver;
import com.netflix.hollow.core.memory.HollowUnsafeHandle;
import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.read.engine.SetMapKeyHasher;
import com.netflix.hollow.core.read.engine.map.HollowMapTypeDataElements;
import com.netflix.hollow.tools.checksum.HollowChecksum;
import java.util.BitSet;

class HollowMapTypeReadStateShard {
    private volatile HollowMapTypeDataElements currentDataVolatile;
    private HollowPrimaryKeyValueDeriver keyDeriver;

    HollowMapTypeReadStateShard() {
    }

    public int size(int ordinal) {
        int size;
        HollowMapTypeDataElements currentData;
        do {
            currentData = this.currentDataVolatile;
            size = (int)currentData.mapPointerAndSizeData.getElementValue((long)ordinal * (long)currentData.bitsPerFixedLengthMapPortion + (long)currentData.bitsPerMapPointer, currentData.bitsPerMapSizeValue);
        } while (this.readWasUnsafe(currentData));
        return size;
    }

    /*
     * Unable to fully structure code
     */
    public int get(int ordinal, int keyOrdinal, int hashCode) {
        block0: do lbl-1000:
        // 3 sources

        {
            currentData = this.currentDataVolatile;
            startBucket = ordinal == 0 ? 0L : currentData.mapPointerAndSizeData.getElementValue((long)(ordinal - 1) * (long)currentData.bitsPerFixedLengthMapPortion, currentData.bitsPerMapPointer);
            endBucket = currentData.mapPointerAndSizeData.getElementValue((long)ordinal * (long)currentData.bitsPerFixedLengthMapPortion, currentData.bitsPerMapPointer);
            if (this.readWasUnsafe(currentData)) ** GOTO lbl-1000
            hashCode = HashCodes.hashInt(hashCode);
            bucket = startBucket + ((long)hashCode & endBucket - startBucket - 1L);
            bucketKeyOrdinal = this.getBucketKeyByAbsoluteIndex(currentData, bucket);
            while (bucketKeyOrdinal != currentData.emptyBucketKeyValue) {
                if (bucketKeyOrdinal == keyOrdinal) {
                    valueOrdinal = this.getBucketValueByAbsoluteIndex(currentData, bucket);
                    continue block0;
                }
                if (++bucket == endBucket) {
                    bucket = startBucket;
                }
                bucketKeyOrdinal = this.getBucketKeyByAbsoluteIndex(currentData, bucket);
            }
            valueOrdinal = -1;
        } while (this.readWasUnsafe(currentData));
        return valueOrdinal;
    }

    /*
     * Unable to fully structure code
     */
    public int findKey(int ordinal, Object ... hashKey) {
        hashCode = SetMapKeyHasher.hash(hashKey, this.keyDeriver.getFieldTypes());
        do lbl-1000:
        // 3 sources

        {
            currentData = this.currentDataVolatile;
            startBucket = ordinal == 0 ? 0L : currentData.mapPointerAndSizeData.getElementValue((long)(ordinal - 1) * (long)currentData.bitsPerFixedLengthMapPortion, currentData.bitsPerMapPointer);
            endBucket = currentData.mapPointerAndSizeData.getElementValue((long)ordinal * (long)currentData.bitsPerFixedLengthMapPortion, currentData.bitsPerMapPointer);
            if (this.readWasUnsafe(currentData)) ** GOTO lbl-1000
            bucket = startBucket + ((long)hashCode & endBucket - startBucket - 1L);
            bucketKeyOrdinal = this.getBucketKeyByAbsoluteIndex(currentData, bucket);
            while (bucketKeyOrdinal != currentData.emptyBucketKeyValue && !this.readWasUnsafe(currentData)) {
                if (this.keyDeriver.keyMatches(bucketKeyOrdinal, hashKey)) {
                    return bucketKeyOrdinal;
                }
                if (++bucket == endBucket) {
                    bucket = startBucket;
                }
                bucketKeyOrdinal = this.getBucketKeyByAbsoluteIndex(currentData, bucket);
            }
        } while (this.readWasUnsafe(currentData));
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    public long findEntry(int ordinal, Object ... hashKey) {
        hashCode = SetMapKeyHasher.hash(hashKey, this.keyDeriver.getFieldTypes());
        block0: do lbl-1000:
        // 3 sources

        {
            currentData = this.currentDataVolatile;
            startBucket = ordinal == 0 ? 0L : currentData.mapPointerAndSizeData.getElementValue((long)(ordinal - 1) * (long)currentData.bitsPerFixedLengthMapPortion, currentData.bitsPerMapPointer);
            endBucket = currentData.mapPointerAndSizeData.getElementValue((long)ordinal * (long)currentData.bitsPerFixedLengthMapPortion, currentData.bitsPerMapPointer);
            if (this.readWasUnsafe(currentData)) ** GOTO lbl-1000
            bucket = startBucket + ((long)hashCode & endBucket - startBucket - 1L);
            bucketKeyOrdinal = this.getBucketKeyByAbsoluteIndex(currentData, bucket);
            while (bucketKeyOrdinal != currentData.emptyBucketKeyValue && !this.readWasUnsafe(currentData)) {
                if (this.keyDeriver.keyMatches(bucketKeyOrdinal, hashKey)) {
                    valueOrdinal = this.getBucketValueByAbsoluteIndex(currentData, bucket);
                    if (this.readWasUnsafe(currentData)) continue block0;
                    return (long)bucketKeyOrdinal << 32 | valueOrdinal;
                }
                if (++bucket == endBucket) {
                    bucket = startBucket;
                }
                bucketKeyOrdinal = this.getBucketKeyByAbsoluteIndex(currentData, bucket);
            }
        } while (this.readWasUnsafe(currentData));
        return -1L;
    }

    /*
     * Unable to fully structure code
     */
    public long relativeBucket(int ordinal, int bucketIndex) {
        do lbl-1000:
        // 3 sources

        {
            currentData = this.currentDataVolatile;
            absoluteBucketIndex = this.getAbsoluteBucketStart(currentData, ordinal) + (long)bucketIndex;
            if (this.readWasUnsafe(currentData)) ** GOTO lbl-1000
            key = this.getBucketKeyByAbsoluteIndex(currentData, absoluteBucketIndex);
            if (key == (long)currentData.emptyBucketKeyValue) {
                return -1L;
            }
            bucketValue = key << 32 | (long)this.getBucketValueByAbsoluteIndex(currentData, absoluteBucketIndex);
        } while (this.readWasUnsafe(currentData));
        return bucketValue;
    }

    private long getAbsoluteBucketStart(HollowMapTypeDataElements currentData, int ordinal) {
        long startBucket = ordinal == 0 ? 0L : currentData.mapPointerAndSizeData.getElementValue((long)(ordinal - 1) * (long)currentData.bitsPerFixedLengthMapPortion, currentData.bitsPerMapPointer);
        return startBucket;
    }

    private int getBucketKeyByAbsoluteIndex(HollowMapTypeDataElements currentData, long absoluteBucketIndex) {
        return (int)currentData.entryData.getElementValue(absoluteBucketIndex * (long)currentData.bitsPerMapEntry, currentData.bitsPerKeyElement);
    }

    private int getBucketValueByAbsoluteIndex(HollowMapTypeDataElements currentData, long absoluteBucketIndex) {
        return (int)currentData.entryData.getElementValue(absoluteBucketIndex * (long)currentData.bitsPerMapEntry + (long)currentData.bitsPerKeyElement, currentData.bitsPerValueElement);
    }

    void invalidate() {
        this.setCurrentData(null);
    }

    HollowMapTypeDataElements currentDataElements() {
        return this.currentDataVolatile;
    }

    private boolean readWasUnsafe(HollowMapTypeDataElements data) {
        HollowUnsafeHandle.getUnsafe().loadFence();
        return data != this.currentDataVolatile;
    }

    void setCurrentData(HollowMapTypeDataElements data) {
        this.currentDataVolatile = data;
    }

    protected void applyToChecksum(HollowChecksum checksum, BitSet populatedOrdinals, int shardNumber, int numShards) {
        HollowMapTypeDataElements currentData = this.currentDataVolatile;
        int ordinal = populatedOrdinals.nextSetBit(shardNumber);
        while (ordinal != -1) {
            if ((ordinal & numShards - 1) == shardNumber) {
                int shardOrdinal = ordinal / numShards;
                int numBuckets = HashCodes.hashTableSize(this.size(shardOrdinal));
                long offset = this.getAbsoluteBucketStart(currentData, shardOrdinal);
                checksum.applyInt(ordinal);
                for (int i = 0; i < numBuckets; ++i) {
                    int bucketKey = this.getBucketKeyByAbsoluteIndex(currentData, offset + (long)i);
                    if (bucketKey == currentData.emptyBucketKeyValue) continue;
                    checksum.applyInt(i);
                    checksum.applyInt(bucketKey);
                    checksum.applyInt(this.getBucketValueByAbsoluteIndex(currentData, offset + (long)i));
                }
                ordinal += numShards;
            } else {
                int r = (ordinal & -numShards) + shardNumber;
                ordinal = r <= ordinal ? r + numShards : r;
            }
            ordinal = populatedOrdinals.nextSetBit(ordinal);
        }
    }

    public long getApproximateHeapFootprintInBytes() {
        HollowMapTypeDataElements currentData = this.currentDataVolatile;
        long requiredBitsForMapPointers = ((long)currentData.maxOrdinal + 1L) * (long)currentData.bitsPerFixedLengthMapPortion;
        long requiredBitsForMapBuckets = currentData.totalNumberOfBuckets * (long)currentData.bitsPerMapEntry;
        long requiredBits = requiredBitsForMapPointers + requiredBitsForMapBuckets;
        return requiredBits / 8L;
    }

    public long getApproximateHoleCostInBytes(BitSet populatedOrdinals, int shardNumber, int numShards) {
        HollowMapTypeDataElements currentData = this.currentDataVolatile;
        long holeBits = 0L;
        int holeOrdinal = populatedOrdinals.nextClearBit(0);
        while (holeOrdinal <= currentData.maxOrdinal) {
            if ((holeOrdinal & numShards - 1) == shardNumber) {
                holeBits += (long)currentData.bitsPerFixedLengthMapPortion;
            }
            holeOrdinal = populatedOrdinals.nextClearBit(holeOrdinal + 1);
        }
        return holeBits / 8L;
    }

    public void setKeyDeriver(HollowPrimaryKeyValueDeriver keyDeriver) {
        this.keyDeriver = keyDeriver;
    }
}

