/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.map;

import com.netflix.hollow.api.sampling.DisabledSamplingDirector;
import com.netflix.hollow.api.sampling.HollowMapSampler;
import com.netflix.hollow.api.sampling.HollowSampler;
import com.netflix.hollow.api.sampling.HollowSamplingDirector;
import com.netflix.hollow.core.index.key.HollowPrimaryKeyValueDeriver;
import com.netflix.hollow.core.memory.MemoryMode;
import com.netflix.hollow.core.memory.encoding.GapEncodedVariableLengthIntegerReader;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import com.netflix.hollow.core.read.HollowBlobInput;
import com.netflix.hollow.core.read.dataaccess.HollowMapTypeDataAccess;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.engine.PopulatedOrdinalListener;
import com.netflix.hollow.core.read.engine.SnapshotPopulatedOrdinalsReader;
import com.netflix.hollow.core.read.engine.map.HollowMapTypeDataElements;
import com.netflix.hollow.core.read.engine.map.HollowMapTypeReadStateShard;
import com.netflix.hollow.core.read.engine.map.PotentialMatchHollowMapEntryOrdinalIteratorImpl;
import com.netflix.hollow.core.read.filter.HollowFilterConfig;
import com.netflix.hollow.core.read.iterator.EmptyMapOrdinalIterator;
import com.netflix.hollow.core.read.iterator.HollowMapEntryOrdinalIterator;
import com.netflix.hollow.core.read.iterator.HollowMapEntryOrdinalIteratorImpl;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.tools.checksum.HollowChecksum;
import java.io.IOException;
import java.util.BitSet;

public class HollowMapTypeReadState
extends HollowTypeReadState
implements HollowMapTypeDataAccess {
    private final HollowMapSampler sampler;
    private final int shardNumberMask;
    private final int shardOrdinalShift;
    private final HollowMapTypeReadStateShard[] shards;
    private HollowPrimaryKeyValueDeriver keyDeriver;
    private int maxOrdinal;

    public HollowMapTypeReadState(HollowReadStateEngine stateEngine, HollowMapSchema schema, int numShards) {
        this(stateEngine, MemoryMode.ON_HEAP, schema, numShards);
    }

    public HollowMapTypeReadState(HollowReadStateEngine stateEngine, MemoryMode memoryMode, HollowMapSchema schema, int numShards) {
        super(stateEngine, memoryMode, schema);
        this.sampler = new HollowMapSampler(schema.getName(), DisabledSamplingDirector.INSTANCE);
        this.shardNumberMask = numShards - 1;
        this.shardOrdinalShift = 31 - Integer.numberOfLeadingZeros(numShards);
        if (numShards < 1 || 1 << this.shardOrdinalShift != numShards) {
            throw new IllegalArgumentException("Number of shards must be a power of 2!");
        }
        HollowMapTypeReadStateShard[] shards = new HollowMapTypeReadStateShard[numShards];
        for (int i = 0; i < shards.length; ++i) {
            shards[i] = new HollowMapTypeReadStateShard();
        }
        this.shards = shards;
    }

    @Override
    public void readSnapshot(HollowBlobInput in, ArraySegmentRecycler memoryRecycler) throws IOException {
        if (this.shards.length > 1) {
            this.maxOrdinal = VarInt.readVInt(in);
        }
        for (int i = 0; i < this.shards.length; ++i) {
            HollowMapTypeDataElements snapshotData = new HollowMapTypeDataElements(this.memoryMode, memoryRecycler);
            snapshotData.readSnapshot(in);
            this.shards[i].setCurrentData(snapshotData);
        }
        if (this.shards.length == 1) {
            this.maxOrdinal = this.shards[0].currentDataElements().maxOrdinal;
        }
        SnapshotPopulatedOrdinalsReader.readOrdinals(in, this.stateListeners);
    }

    @Override
    public void applyDelta(HollowBlobInput in, HollowSchema schema, ArraySegmentRecycler memoryRecycler) throws IOException {
        if (this.shards.length > 1) {
            this.maxOrdinal = VarInt.readVInt(in);
        }
        for (int i = 0; i < this.shards.length; ++i) {
            HollowMapTypeDataElements deltaData = new HollowMapTypeDataElements(this.memoryMode, memoryRecycler);
            deltaData.readDelta(in);
            if (this.stateEngine.isSkipTypeShardUpdateWithNoAdditions() && deltaData.encodedAdditions.isEmpty()) {
                GapEncodedVariableLengthIntegerReader oldRemovals;
                if (!deltaData.encodedRemovals.isEmpty()) {
                    this.notifyListenerAboutDeltaChanges(deltaData.encodedRemovals, deltaData.encodedAdditions, i, this.shards.length);
                }
                HollowMapTypeDataElements currentData = this.shards[i].currentDataElements();
                GapEncodedVariableLengthIntegerReader gapEncodedVariableLengthIntegerReader = oldRemovals = currentData.encodedRemovals == null ? GapEncodedVariableLengthIntegerReader.EMPTY_READER : currentData.encodedRemovals;
                if (oldRemovals.isEmpty()) {
                    currentData.encodedRemovals = deltaData.encodedRemovals;
                    oldRemovals.destroy();
                } else {
                    if (!deltaData.encodedRemovals.isEmpty()) {
                        currentData.encodedRemovals = GapEncodedVariableLengthIntegerReader.combine(oldRemovals, deltaData.encodedRemovals, memoryRecycler);
                        oldRemovals.destroy();
                    }
                    deltaData.encodedRemovals.destroy();
                }
                deltaData.encodedAdditions.destroy();
            } else {
                HollowMapTypeDataElements nextData = new HollowMapTypeDataElements(this.memoryMode, memoryRecycler);
                HollowMapTypeDataElements oldData = this.shards[i].currentDataElements();
                nextData.applyDelta(oldData, deltaData);
                this.shards[i].setCurrentData(nextData);
                this.notifyListenerAboutDeltaChanges(deltaData.encodedRemovals, deltaData.encodedAdditions, i, this.shards.length);
                oldData.destroy();
            }
            deltaData.destroy();
            this.stateEngine.getMemoryRecycler().swap();
        }
        if (this.shards.length == 1) {
            this.maxOrdinal = this.shards[0].currentDataElements().maxOrdinal;
        }
    }

    public static void discardSnapshot(HollowBlobInput in, int numShards) throws IOException {
        HollowMapTypeReadState.discardType(in, numShards, false);
    }

    public static void discardDelta(HollowBlobInput in, int numShards) throws IOException {
        HollowMapTypeReadState.discardType(in, numShards, true);
    }

    public static void discardType(HollowBlobInput in, int numShards, boolean delta) throws IOException {
        HollowMapTypeDataElements.discardFromInput(in, numShards, delta);
        if (!delta) {
            SnapshotPopulatedOrdinalsReader.discardOrdinals(in);
        }
    }

    @Override
    public int maxOrdinal() {
        return this.maxOrdinal;
    }

    @Override
    public int size(int ordinal) {
        this.sampler.recordSize();
        return this.shards[ordinal & this.shardNumberMask].size(ordinal >> this.shardOrdinalShift);
    }

    @Override
    public int get(int ordinal, int keyOrdinal) {
        return this.get(ordinal, keyOrdinal, keyOrdinal);
    }

    @Override
    public int get(int ordinal, int keyOrdinal, int hashCode) {
        this.sampler.recordGet();
        return this.shards[ordinal & this.shardNumberMask].get(ordinal >> this.shardOrdinalShift, keyOrdinal, hashCode);
    }

    @Override
    public int findKey(int ordinal, Object ... hashKey) {
        this.sampler.recordGet();
        if (this.keyDeriver == null) {
            return -1;
        }
        HollowObjectSchema.FieldType[] fieldTypes = this.keyDeriver.getFieldTypes();
        if (hashKey.length != fieldTypes.length) {
            return -1;
        }
        return this.shards[ordinal & this.shardNumberMask].findKey(ordinal >> this.shardOrdinalShift, hashKey);
    }

    @Override
    public int findValue(int ordinal, Object ... hashKey) {
        return (int)this.findEntry(ordinal, hashKey);
    }

    @Override
    public long findEntry(int ordinal, Object ... hashKey) {
        this.sampler.recordGet();
        if (this.keyDeriver == null) {
            return -1L;
        }
        HollowObjectSchema.FieldType[] fieldTypes = this.keyDeriver.getFieldTypes();
        if (hashKey.length != fieldTypes.length) {
            return -1L;
        }
        return this.shards[ordinal & this.shardNumberMask].findEntry(ordinal >> this.shardOrdinalShift, hashKey);
    }

    @Override
    public HollowMapEntryOrdinalIterator potentialMatchOrdinalIterator(int ordinal, int hashCode) {
        this.sampler.recordGet();
        if (this.size(ordinal) == 0) {
            return EmptyMapOrdinalIterator.INSTANCE;
        }
        return new PotentialMatchHollowMapEntryOrdinalIteratorImpl(ordinal, this, hashCode);
    }

    @Override
    public HollowMapEntryOrdinalIterator ordinalIterator(int ordinal) {
        this.sampler.recordIterator();
        if (this.size(ordinal) == 0) {
            return EmptyMapOrdinalIterator.INSTANCE;
        }
        return new HollowMapEntryOrdinalIteratorImpl(ordinal, this);
    }

    @Override
    public long relativeBucket(int ordinal, int bucketIndex) {
        return this.shards[ordinal & this.shardNumberMask].relativeBucket(ordinal >> this.shardOrdinalShift, bucketIndex);
    }

    @Override
    public HollowMapSchema getSchema() {
        return (HollowMapSchema)this.schema;
    }

    @Override
    public HollowSampler getSampler() {
        return this.sampler;
    }

    @Override
    public void setSamplingDirector(HollowSamplingDirector director) {
        this.sampler.setSamplingDirector(director);
    }

    @Override
    public void setFieldSpecificSamplingDirector(HollowFilterConfig fieldSpec, HollowSamplingDirector director) {
        this.sampler.setFieldSpecificSamplingDirector(fieldSpec, director);
    }

    @Override
    public void ignoreUpdateThreadForSampling(Thread t) {
        this.sampler.setUpdateThread(t);
    }

    @Override
    protected void invalidate() {
        this.stateListeners = EMPTY_LISTENERS;
        for (int i = 0; i < this.shards.length; ++i) {
            this.shards[i].invalidate();
        }
    }

    HollowMapTypeDataElements[] currentDataElements() {
        HollowMapTypeDataElements[] currentDataElements = new HollowMapTypeDataElements[this.shards.length];
        for (int i = 0; i < this.shards.length; ++i) {
            currentDataElements[i] = this.shards[i].currentDataElements();
        }
        return currentDataElements;
    }

    void setCurrentData(HollowMapTypeDataElements data) {
        if (this.shards.length > 1) {
            throw new UnsupportedOperationException("Cannot directly set data on sharded type state");
        }
        this.shards[0].setCurrentData(data);
        this.maxOrdinal = data.maxOrdinal;
    }

    @Override
    protected void applyToChecksum(HollowChecksum checksum, HollowSchema withSchema) {
        if (!this.getSchema().equals(withSchema)) {
            throw new IllegalArgumentException("HollowMapTypeReadState cannot calculate checksum with unequal schemas: " + this.getSchema().getName());
        }
        BitSet populatedOrdinals = this.getListener(PopulatedOrdinalListener.class).getPopulatedOrdinals();
        for (int i = 0; i < this.shards.length; ++i) {
            this.shards[i].applyToChecksum(checksum, populatedOrdinals, i, this.shards.length);
        }
    }

    @Override
    public long getApproximateHeapFootprintInBytes() {
        long totalApproximateHeapFootprintInBytes = 0L;
        for (int i = 0; i < this.shards.length; ++i) {
            totalApproximateHeapFootprintInBytes += this.shards[i].getApproximateHeapFootprintInBytes();
        }
        return totalApproximateHeapFootprintInBytes;
    }

    @Override
    public long getApproximateHoleCostInBytes() {
        long totalApproximateHoleCostInBytes = 0L;
        BitSet populatedOrdinals = this.getPopulatedOrdinals();
        for (int i = 0; i < this.shards.length; ++i) {
            totalApproximateHoleCostInBytes += this.shards[i].getApproximateHoleCostInBytes(populatedOrdinals, i, this.shards.length);
        }
        return totalApproximateHoleCostInBytes;
    }

    public HollowPrimaryKeyValueDeriver getKeyDeriver() {
        return this.keyDeriver;
    }

    public void buildKeyDeriver() {
        if (this.getSchema().getHashKey() != null) {
            this.keyDeriver = new HollowPrimaryKeyValueDeriver(this.getSchema().getHashKey(), this.getStateEngine());
        }
        for (int i = 0; i < this.shards.length; ++i) {
            this.shards[i].setKeyDeriver(this.keyDeriver);
        }
    }

    @Override
    public int numShards() {
        return this.shards.length;
    }
}

