/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.map;

import com.netflix.hollow.core.memory.FixedLengthData;
import com.netflix.hollow.core.memory.FixedLengthDataFactory;
import com.netflix.hollow.core.memory.MemoryMode;
import com.netflix.hollow.core.memory.encoding.GapEncodedVariableLengthIntegerReader;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import com.netflix.hollow.core.read.HollowBlobInput;
import com.netflix.hollow.core.read.engine.map.HollowMapDeltaApplicator;
import java.io.IOException;

public class HollowMapTypeDataElements {
    int maxOrdinal;
    FixedLengthData mapPointerAndSizeData;
    FixedLengthData entryData;
    GapEncodedVariableLengthIntegerReader encodedRemovals;
    GapEncodedVariableLengthIntegerReader encodedAdditions;
    int bitsPerMapPointer;
    int bitsPerMapSizeValue;
    int bitsPerFixedLengthMapPortion;
    int bitsPerKeyElement;
    int bitsPerValueElement;
    int bitsPerMapEntry;
    int emptyBucketKeyValue;
    long totalNumberOfBuckets;
    final ArraySegmentRecycler memoryRecycler;
    final MemoryMode memoryMode;

    public HollowMapTypeDataElements(ArraySegmentRecycler memoryRecycler) {
        this(MemoryMode.ON_HEAP, memoryRecycler);
    }

    public HollowMapTypeDataElements(MemoryMode memoryMode, ArraySegmentRecycler memoryRecycler) {
        this.memoryMode = memoryMode;
        this.memoryRecycler = memoryRecycler;
    }

    void readSnapshot(HollowBlobInput in) throws IOException {
        this.readFromInput(in, false);
    }

    void readDelta(HollowBlobInput in) throws IOException {
        this.readFromInput(in, true);
    }

    private void readFromInput(HollowBlobInput in, boolean isDelta) throws IOException {
        this.maxOrdinal = VarInt.readVInt(in);
        if (isDelta) {
            this.encodedRemovals = GapEncodedVariableLengthIntegerReader.readEncodedDeltaOrdinals(in, this.memoryRecycler);
            this.encodedAdditions = GapEncodedVariableLengthIntegerReader.readEncodedDeltaOrdinals(in, this.memoryRecycler);
        }
        this.bitsPerMapPointer = VarInt.readVInt(in);
        this.bitsPerMapSizeValue = VarInt.readVInt(in);
        this.bitsPerKeyElement = VarInt.readVInt(in);
        this.bitsPerValueElement = VarInt.readVInt(in);
        this.bitsPerFixedLengthMapPortion = this.bitsPerMapPointer + this.bitsPerMapSizeValue;
        this.bitsPerMapEntry = this.bitsPerKeyElement + this.bitsPerValueElement;
        this.emptyBucketKeyValue = (1 << this.bitsPerKeyElement) - 1;
        this.totalNumberOfBuckets = VarInt.readVLong(in);
        this.mapPointerAndSizeData = FixedLengthDataFactory.get(in, this.memoryMode, this.memoryRecycler);
        this.entryData = FixedLengthDataFactory.get(in, this.memoryMode, this.memoryRecycler);
    }

    static void discardFromInput(HollowBlobInput in, int numShards, boolean isDelta) throws IOException {
        if (numShards > 1) {
            VarInt.readVInt(in);
        }
        for (int i = 0; i < numShards; ++i) {
            VarInt.readVInt(in);
            if (isDelta) {
                GapEncodedVariableLengthIntegerReader.discardEncodedDeltaOrdinals(in);
                GapEncodedVariableLengthIntegerReader.discardEncodedDeltaOrdinals(in);
            }
            VarInt.readVInt(in);
            VarInt.readVInt(in);
            VarInt.readVInt(in);
            VarInt.readVInt(in);
            VarInt.readVLong(in);
            FixedLengthData.discardFrom(in);
            FixedLengthData.discardFrom(in);
        }
    }

    public void applyDelta(HollowMapTypeDataElements fromData, HollowMapTypeDataElements deltaData) {
        new HollowMapDeltaApplicator(fromData, deltaData, this).applyDelta();
    }

    public void destroy() {
        FixedLengthDataFactory.destroy(this.mapPointerAndSizeData, this.memoryRecycler);
        FixedLengthDataFactory.destroy(this.entryData, this.memoryRecycler);
    }
}

