/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.map;

import com.netflix.hollow.core.memory.encoding.FixedLengthElementArray;
import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.memory.pool.WastefulRecycler;
import com.netflix.hollow.core.read.engine.PopulatedOrdinalListener;
import com.netflix.hollow.core.read.engine.map.HollowMapTypeDataElements;
import com.netflix.hollow.core.read.engine.map.HollowMapTypeReadState;
import com.netflix.hollow.core.util.IntMap;
import com.netflix.hollow.core.util.RemovedOrdinalIterator;

public class HollowMapDeltaHistoricalStateCreator {
    private final HollowMapTypeReadState typeState;
    private final HollowMapTypeDataElements[] stateEngineDataElements;
    private final HollowMapTypeDataElements historicalDataElements;
    private final RemovedOrdinalIterator iter;
    private final int shardNumberMask;
    private final int shardOrdinalShift;
    private IntMap ordinalMapping;
    private int nextOrdinal;
    private long nextStartBucket;

    public HollowMapDeltaHistoricalStateCreator(HollowMapTypeReadState typeState) {
        this.typeState = typeState;
        this.stateEngineDataElements = typeState.currentDataElements();
        this.historicalDataElements = new HollowMapTypeDataElements(WastefulRecycler.DEFAULT_INSTANCE);
        this.iter = new RemovedOrdinalIterator(typeState.getListener(PopulatedOrdinalListener.class));
        this.shardNumberMask = this.stateEngineDataElements.length - 1;
        this.shardOrdinalShift = 31 - Integer.numberOfLeadingZeros(this.stateEngineDataElements.length);
    }

    public void populateHistory() {
        this.populateStats();
        this.historicalDataElements.mapPointerAndSizeData = new FixedLengthElementArray(this.historicalDataElements.memoryRecycler, ((long)this.historicalDataElements.maxOrdinal + 1L) * (long)this.historicalDataElements.bitsPerFixedLengthMapPortion);
        this.historicalDataElements.entryData = new FixedLengthElementArray(this.historicalDataElements.memoryRecycler, this.historicalDataElements.totalNumberOfBuckets * (long)this.historicalDataElements.bitsPerMapEntry);
        this.iter.reset();
        int ordinal = this.iter.next();
        while (ordinal != -1) {
            this.ordinalMapping.put(ordinal, this.nextOrdinal);
            this.copyRecord(ordinal);
            ordinal = this.iter.next();
        }
    }

    public IntMap getOrdinalMapping() {
        return this.ordinalMapping;
    }

    public HollowMapTypeReadState createHistoricalTypeReadState() {
        HollowMapTypeReadState historicalTypeState = new HollowMapTypeReadState(null, this.typeState.getSchema(), 1);
        historicalTypeState.setCurrentData(this.historicalDataElements);
        return historicalTypeState;
    }

    private void populateStats() {
        this.iter.reset();
        int removedEntryCount = 0;
        int maxSize = 0;
        long totalBucketCount = 0L;
        int ordinal = this.iter.next();
        while (ordinal != -1) {
            ++removedEntryCount;
            int size = this.typeState.size(ordinal);
            if (size > maxSize) {
                maxSize = size;
            }
            totalBucketCount += (long)HashCodes.hashTableSize(size);
            ordinal = this.iter.next();
        }
        this.historicalDataElements.maxOrdinal = removedEntryCount - 1;
        this.historicalDataElements.bitsPerMapPointer = 64 - Long.numberOfLeadingZeros(totalBucketCount);
        this.historicalDataElements.bitsPerMapSizeValue = 64 - Long.numberOfLeadingZeros(maxSize);
        this.historicalDataElements.bitsPerFixedLengthMapPortion = this.historicalDataElements.bitsPerMapPointer + this.historicalDataElements.bitsPerMapSizeValue;
        this.historicalDataElements.bitsPerKeyElement = this.stateEngineDataElements[0].bitsPerKeyElement;
        this.historicalDataElements.bitsPerValueElement = this.stateEngineDataElements[0].bitsPerValueElement;
        this.historicalDataElements.bitsPerMapEntry = this.stateEngineDataElements[0].bitsPerMapEntry;
        this.historicalDataElements.emptyBucketKeyValue = this.stateEngineDataElements[0].emptyBucketKeyValue;
        this.historicalDataElements.totalNumberOfBuckets = totalBucketCount;
        this.ordinalMapping = new IntMap(removedEntryCount);
    }

    private void copyRecord(int ordinal) {
        int shard = ordinal & this.shardNumberMask;
        int shardOrdinal = ordinal >> this.shardOrdinalShift;
        long bitsPerBucket = this.historicalDataElements.bitsPerMapEntry;
        long size = this.typeState.size(ordinal);
        long fromStartBucket = shardOrdinal == 0 ? 0L : this.stateEngineDataElements[shard].mapPointerAndSizeData.getElementValue((long)(shardOrdinal - 1) * (long)this.stateEngineDataElements[shard].bitsPerFixedLengthMapPortion, this.stateEngineDataElements[shard].bitsPerMapPointer);
        long fromEndBucket = this.stateEngineDataElements[shard].mapPointerAndSizeData.getElementValue((long)shardOrdinal * (long)this.stateEngineDataElements[shard].bitsPerFixedLengthMapPortion, this.stateEngineDataElements[shard].bitsPerMapPointer);
        long numBuckets = fromEndBucket - fromStartBucket;
        this.historicalDataElements.mapPointerAndSizeData.setElementValue((long)this.nextOrdinal * (long)this.historicalDataElements.bitsPerFixedLengthMapPortion, this.historicalDataElements.bitsPerMapPointer, this.nextStartBucket + numBuckets);
        this.historicalDataElements.mapPointerAndSizeData.setElementValue((long)this.nextOrdinal * (long)this.historicalDataElements.bitsPerFixedLengthMapPortion + (long)this.historicalDataElements.bitsPerMapPointer, this.historicalDataElements.bitsPerMapSizeValue, size);
        this.historicalDataElements.entryData.copyBits(this.stateEngineDataElements[shard].entryData, fromStartBucket * bitsPerBucket, this.nextStartBucket * bitsPerBucket, numBuckets * bitsPerBucket);
        ++this.nextOrdinal;
        this.nextStartBucket += numBuckets;
    }
}

