/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.map;

import com.netflix.hollow.core.memory.encoding.FixedLengthElementArray;
import com.netflix.hollow.core.memory.encoding.GapEncodedVariableLengthIntegerReader;
import com.netflix.hollow.core.read.engine.map.HollowMapTypeDataElements;

class HollowMapDeltaApplicator {
    private final HollowMapTypeDataElements from;
    private final HollowMapTypeDataElements delta;
    private final HollowMapTypeDataElements target;
    private long currentFromStateCopyStartBit = 0L;
    private long currentDeltaCopyStartBit = 0L;
    private long currentWriteStartBit = 0L;
    private long currentFromStateStartBucket = 0L;
    private long currentDeltaStartBucket = 0L;
    private long currentWriteStartBucket = 0L;
    private GapEncodedVariableLengthIntegerReader removalsReader;
    private GapEncodedVariableLengthIntegerReader additionsReader;

    HollowMapDeltaApplicator(HollowMapTypeDataElements from, HollowMapTypeDataElements delta, HollowMapTypeDataElements target) {
        this.from = from;
        this.delta = delta;
        this.target = target;
    }

    public void applyDelta() {
        this.removalsReader = this.from.encodedRemovals == null ? GapEncodedVariableLengthIntegerReader.EMPTY_READER : this.from.encodedRemovals;
        this.additionsReader = this.delta.encodedAdditions;
        this.removalsReader.reset();
        this.additionsReader.reset();
        this.target.encodedRemovals = this.delta.encodedRemovals;
        this.target.maxOrdinal = this.delta.maxOrdinal;
        this.target.bitsPerMapPointer = this.delta.bitsPerMapPointer;
        this.target.bitsPerMapSizeValue = this.delta.bitsPerMapSizeValue;
        this.target.bitsPerKeyElement = this.delta.bitsPerKeyElement;
        this.target.bitsPerValueElement = this.delta.bitsPerValueElement;
        this.target.bitsPerFixedLengthMapPortion = this.delta.bitsPerFixedLengthMapPortion;
        this.target.bitsPerMapEntry = this.delta.bitsPerMapEntry;
        this.target.emptyBucketKeyValue = this.delta.emptyBucketKeyValue;
        this.target.totalNumberOfBuckets = this.delta.totalNumberOfBuckets;
        this.target.mapPointerAndSizeData = new FixedLengthElementArray(this.target.memoryRecycler, ((long)this.target.maxOrdinal + 1L) * (long)this.target.bitsPerFixedLengthMapPortion);
        this.target.entryData = new FixedLengthElementArray(this.target.memoryRecycler, this.target.totalNumberOfBuckets * (long)this.target.bitsPerMapEntry);
        if (this.target.bitsPerMapPointer == this.from.bitsPerMapPointer && this.target.bitsPerMapSizeValue == this.from.bitsPerMapSizeValue && this.target.bitsPerKeyElement == this.from.bitsPerKeyElement && this.target.bitsPerValueElement == this.from.bitsPerValueElement) {
            this.fastDelta();
        } else {
            this.slowDelta();
        }
        this.from.encodedRemovals = null;
        this.removalsReader.destroy();
        this.additionsReader.destroy();
    }

    private void slowDelta() {
        for (int i = 0; i <= this.target.maxOrdinal; ++i) {
            this.mergeOrdinal(i);
        }
    }

    private void fastDelta() {
        int i = 0;
        int bulkCopyEndOrdinal = Math.min(this.from.maxOrdinal, this.target.maxOrdinal);
        while (i <= this.target.maxOrdinal) {
            int nextElementDiff = Math.min(this.additionsReader.nextElement(), this.removalsReader.nextElement());
            if (nextElementDiff == i || i > bulkCopyEndOrdinal) {
                this.mergeOrdinal(i++);
                continue;
            }
            int recordsToCopy = nextElementDiff - i;
            if (nextElementDiff > bulkCopyEndOrdinal) {
                recordsToCopy = bulkCopyEndOrdinal - i + 1;
            }
            this.fastCopyRecords(recordsToCopy);
            i += recordsToCopy;
        }
    }

    private void fastCopyRecords(int recordsToCopy) {
        long mapPointerAndSizeBitsToCopy = (long)recordsToCopy * (long)this.target.bitsPerFixedLengthMapPortion;
        long eachMapPointerDifference = this.currentWriteStartBucket - this.currentFromStateStartBucket;
        this.target.mapPointerAndSizeData.copyBits(this.from.mapPointerAndSizeData, this.currentFromStateCopyStartBit, this.currentWriteStartBit, mapPointerAndSizeBitsToCopy);
        this.target.mapPointerAndSizeData.incrementMany(this.currentWriteStartBit, eachMapPointerDifference, this.target.bitsPerFixedLengthMapPortion, recordsToCopy);
        this.currentFromStateCopyStartBit += mapPointerAndSizeBitsToCopy;
        this.currentWriteStartBit += mapPointerAndSizeBitsToCopy;
        long fromDataEndElement = this.from.mapPointerAndSizeData.getElementValue(this.currentFromStateCopyStartBit - (long)this.from.bitsPerFixedLengthMapPortion, this.from.bitsPerMapPointer);
        long bucketsToCopy = fromDataEndElement - this.currentFromStateStartBucket;
        long bitsToCopy = bucketsToCopy * (long)this.from.bitsPerMapEntry;
        this.target.entryData.copyBits(this.from.entryData, this.currentFromStateStartBucket * (long)this.from.bitsPerMapEntry, this.currentWriteStartBucket * (long)this.from.bitsPerMapEntry, bitsToCopy);
        this.currentFromStateStartBucket += bucketsToCopy;
        this.currentWriteStartBucket += bucketsToCopy;
    }

    private void mergeOrdinal(int ordinal) {
        boolean removeData;
        boolean addFromDelta = this.additionsReader.nextElement() == ordinal;
        boolean bl = removeData = this.removalsReader.nextElement() == ordinal;
        if (addFromDelta) {
            this.addFromDelta(this.additionsReader);
        }
        if (ordinal <= this.from.maxOrdinal) {
            long fromDataEndBucket = this.from.mapPointerAndSizeData.getElementValue(this.currentFromStateCopyStartBit, this.from.bitsPerMapPointer);
            if (!removeData) {
                for (long bucketIdx = this.currentFromStateStartBucket; bucketIdx < fromDataEndBucket; ++bucketIdx) {
                    long bucketKey = this.from.entryData.getElementValue(bucketIdx * (long)this.from.bitsPerMapEntry, this.from.bitsPerKeyElement);
                    long bucketValue = this.from.entryData.getElementValue(bucketIdx * (long)this.from.bitsPerMapEntry + (long)this.from.bitsPerKeyElement, this.from.bitsPerValueElement);
                    if (bucketKey == (long)this.from.emptyBucketKeyValue) {
                        bucketKey = this.target.emptyBucketKeyValue;
                    }
                    long currentWriteStartBucketBit = this.currentWriteStartBucket * (long)this.target.bitsPerMapEntry;
                    this.target.entryData.setElementValue(currentWriteStartBucketBit, this.target.bitsPerKeyElement, bucketKey);
                    this.target.entryData.setElementValue(currentWriteStartBucketBit + (long)this.target.bitsPerKeyElement, this.target.bitsPerValueElement, bucketValue);
                    ++this.currentWriteStartBucket;
                }
                long fromDataSize = this.from.mapPointerAndSizeData.getElementValue(this.currentFromStateCopyStartBit + (long)this.from.bitsPerMapPointer, this.from.bitsPerMapSizeValue);
                this.target.mapPointerAndSizeData.setElementValue(this.currentWriteStartBit + (long)this.target.bitsPerMapPointer, this.target.bitsPerMapSizeValue, fromDataSize);
            } else {
                this.removalsReader.advance();
            }
            this.currentFromStateStartBucket = fromDataEndBucket;
            this.currentFromStateCopyStartBit += (long)this.from.bitsPerFixedLengthMapPortion;
        }
        this.target.mapPointerAndSizeData.setElementValue(this.currentWriteStartBit, this.target.bitsPerMapPointer, this.currentWriteStartBucket);
        this.currentWriteStartBit += (long)this.target.bitsPerFixedLengthMapPortion;
    }

    private void addFromDelta(GapEncodedVariableLengthIntegerReader additionsReader) {
        long deltaDataEndBucket = this.delta.mapPointerAndSizeData.getElementValue(this.currentDeltaCopyStartBit, this.delta.bitsPerMapPointer);
        for (long bucketIdx = this.currentDeltaStartBucket; bucketIdx < deltaDataEndBucket; ++bucketIdx) {
            long bucketEntry = this.delta.entryData.getElementValue(bucketIdx * (long)this.delta.bitsPerMapEntry, this.delta.bitsPerMapEntry);
            this.target.entryData.setElementValue(this.currentWriteStartBucket * (long)this.target.bitsPerMapEntry, this.target.bitsPerMapEntry, bucketEntry);
            ++this.currentWriteStartBucket;
        }
        long deltaDataSize = this.delta.mapPointerAndSizeData.getElementValue(this.currentDeltaCopyStartBit + (long)this.delta.bitsPerMapPointer, this.delta.bitsPerMapSizeValue);
        this.target.mapPointerAndSizeData.setElementValue(this.currentWriteStartBit + (long)this.target.bitsPerMapPointer, this.target.bitsPerMapSizeValue, deltaDataSize);
        this.currentDeltaStartBucket = deltaDataEndBucket;
        this.currentDeltaCopyStartBit += (long)this.delta.bitsPerFixedLengthMapPortion;
        additionsReader.advance();
    }
}

