/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.list;

import com.netflix.hollow.core.memory.HollowUnsafeHandle;
import com.netflix.hollow.core.read.engine.list.HollowListTypeDataElements;
import com.netflix.hollow.tools.checksum.HollowChecksum;
import java.util.BitSet;

class HollowListTypeReadStateShard {
    private volatile HollowListTypeDataElements currentDataVolatile;

    HollowListTypeReadStateShard() {
    }

    /*
     * Unable to fully structure code
     */
    public int getElementOrdinal(int ordinal, int listIndex) {
        do lbl-1000:
        // 3 sources

        {
            currentData = this.currentDataVolatile;
            if (ordinal == 0) {
                startElement = 0L;
                endElement = currentData.listPointerData.getElementValue(0L, currentData.bitsPerListPointer);
            } else {
                endFixedLengthOffset = (long)ordinal * (long)currentData.bitsPerListPointer;
                startFixedLengthOffset = endFixedLengthOffset - (long)currentData.bitsPerListPointer;
                startElement = currentData.listPointerData.getElementValue(startFixedLengthOffset, currentData.bitsPerListPointer);
                endElement = currentData.listPointerData.getElementValue(endFixedLengthOffset, currentData.bitsPerListPointer);
            }
            if (this.readWasUnsafe(currentData)) ** GOTO lbl-1000
            elementIndex = startElement + (long)listIndex;
            if (elementIndex >= endElement) {
                throw new ArrayIndexOutOfBoundsException("Array index out of bounds: " + listIndex + ", list size: " + (endElement - startElement));
            }
            elementOrdinal = (int)currentData.elementData.getElementValue(elementIndex * (long)currentData.bitsPerElement, currentData.bitsPerElement);
        } while (this.readWasUnsafe(currentData));
        return elementOrdinal;
    }

    public int size(int ordinal) {
        int size;
        HollowListTypeDataElements currentData;
        do {
            long endElement;
            long startElement;
            currentData = this.currentDataVolatile;
            if (ordinal == 0) {
                startElement = 0L;
                endElement = currentData.listPointerData.getElementValue(0L, currentData.bitsPerListPointer);
            } else {
                long endFixedLengthOffset = (long)ordinal * (long)currentData.bitsPerListPointer;
                long startFixedLengthOffset = endFixedLengthOffset - (long)currentData.bitsPerListPointer;
                startElement = currentData.listPointerData.getElementValue(startFixedLengthOffset, currentData.bitsPerListPointer);
                endElement = currentData.listPointerData.getElementValue(endFixedLengthOffset, currentData.bitsPerListPointer);
            }
            size = (int)(endElement - startElement);
        } while (this.readWasUnsafe(currentData));
        return size;
    }

    void invalidate() {
        this.setCurrentData(null);
    }

    HollowListTypeDataElements currentDataElements() {
        return this.currentDataVolatile;
    }

    private boolean readWasUnsafe(HollowListTypeDataElements data) {
        HollowUnsafeHandle.getUnsafe().loadFence();
        return data != this.currentDataVolatile;
    }

    void setCurrentData(HollowListTypeDataElements data) {
        this.currentDataVolatile = data;
    }

    protected void applyToChecksum(HollowChecksum checksum, BitSet populatedOrdinals, int shardNumber, int numShards) {
        int ordinal = populatedOrdinals.nextSetBit(shardNumber);
        while (ordinal != -1) {
            if ((ordinal & numShards - 1) == shardNumber) {
                int shardOrdinal = ordinal / numShards;
                int size = this.size(shardOrdinal);
                checksum.applyInt(ordinal);
                for (int i = 0; i < size; ++i) {
                    checksum.applyInt(this.getElementOrdinal(shardOrdinal, i));
                }
                ordinal += numShards;
            } else {
                int r = (ordinal & -numShards) + shardNumber;
                ordinal = r <= ordinal ? r + numShards : r;
            }
            ordinal = populatedOrdinals.nextSetBit(ordinal);
        }
    }

    public long getApproximateHeapFootprintInBytes() {
        HollowListTypeDataElements currentData = this.currentDataVolatile;
        long requiredListPointerBits = ((long)currentData.maxOrdinal + 1L) * (long)currentData.bitsPerListPointer;
        long requiredElementBits = currentData.totalNumberOfElements * (long)currentData.bitsPerElement;
        long requiredBits = requiredListPointerBits + requiredElementBits;
        return requiredBits / 8L;
    }

    public long getApproximateHoleCostInBytes(BitSet populatedOrdinals, int shardNumber, int numShards) {
        HollowListTypeDataElements currentData = this.currentDataVolatile;
        long holeBits = 0L;
        int holeOrdinal = populatedOrdinals.nextClearBit(0);
        while (holeOrdinal <= currentData.maxOrdinal) {
            if ((holeOrdinal & numShards - 1) == shardNumber) {
                holeBits += (long)currentData.bitsPerListPointer;
            }
            holeOrdinal = populatedOrdinals.nextClearBit(holeOrdinal + 1);
        }
        return holeBits / 8L;
    }
}

