/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.list;

import com.netflix.hollow.api.sampling.DisabledSamplingDirector;
import com.netflix.hollow.api.sampling.HollowListSampler;
import com.netflix.hollow.api.sampling.HollowSampler;
import com.netflix.hollow.api.sampling.HollowSamplingDirector;
import com.netflix.hollow.core.memory.MemoryMode;
import com.netflix.hollow.core.memory.encoding.GapEncodedVariableLengthIntegerReader;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import com.netflix.hollow.core.read.HollowBlobInput;
import com.netflix.hollow.core.read.dataaccess.HollowListTypeDataAccess;
import com.netflix.hollow.core.read.engine.HollowCollectionTypeReadState;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.PopulatedOrdinalListener;
import com.netflix.hollow.core.read.engine.SnapshotPopulatedOrdinalsReader;
import com.netflix.hollow.core.read.engine.list.HollowListTypeDataElements;
import com.netflix.hollow.core.read.engine.list.HollowListTypeReadStateShard;
import com.netflix.hollow.core.read.filter.HollowFilterConfig;
import com.netflix.hollow.core.read.iterator.HollowListOrdinalIterator;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;
import com.netflix.hollow.core.schema.HollowListSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.tools.checksum.HollowChecksum;
import java.io.IOException;
import java.util.BitSet;

public class HollowListTypeReadState
extends HollowCollectionTypeReadState
implements HollowListTypeDataAccess {
    private final HollowListSampler sampler;
    private final int shardNumberMask;
    private final int shardOrdinalShift;
    private final HollowListTypeReadStateShard[] shards;
    private int maxOrdinal;

    public HollowListTypeReadState(HollowReadStateEngine stateEngine, HollowListSchema schema, int numShards) {
        this(stateEngine, MemoryMode.ON_HEAP, schema, numShards);
    }

    public HollowListTypeReadState(HollowReadStateEngine stateEngine, MemoryMode memoryMode, HollowListSchema schema, int numShards) {
        super(stateEngine, memoryMode, schema);
        this.sampler = new HollowListSampler(schema.getName(), DisabledSamplingDirector.INSTANCE);
        this.shardNumberMask = numShards - 1;
        this.shardOrdinalShift = 31 - Integer.numberOfLeadingZeros(numShards);
        if (numShards < 1 || 1 << this.shardOrdinalShift != numShards) {
            throw new IllegalArgumentException("Number of shards must be a power of 2!");
        }
        HollowListTypeReadStateShard[] shards = new HollowListTypeReadStateShard[numShards];
        for (int i = 0; i < shards.length; ++i) {
            shards[i] = new HollowListTypeReadStateShard();
        }
        this.shards = shards;
    }

    @Override
    public void readSnapshot(HollowBlobInput in, ArraySegmentRecycler memoryRecycler) throws IOException {
        if (this.shards.length > 1) {
            this.maxOrdinal = VarInt.readVInt(in);
        }
        for (int i = 0; i < this.shards.length; ++i) {
            HollowListTypeDataElements snapshotData = new HollowListTypeDataElements(this.memoryMode, memoryRecycler);
            snapshotData.readSnapshot(in);
            this.shards[i].setCurrentData(snapshotData);
        }
        if (this.shards.length == 1) {
            this.maxOrdinal = this.shards[0].currentDataElements().maxOrdinal;
        }
        SnapshotPopulatedOrdinalsReader.readOrdinals(in, this.stateListeners);
    }

    @Override
    public void applyDelta(HollowBlobInput in, HollowSchema schema, ArraySegmentRecycler memoryRecycler) throws IOException {
        if (this.shards.length > 1) {
            this.maxOrdinal = VarInt.readVInt(in);
        }
        for (int i = 0; i < this.shards.length; ++i) {
            HollowListTypeDataElements deltaData = new HollowListTypeDataElements(this.memoryMode, memoryRecycler);
            deltaData.readDelta(in);
            if (this.stateEngine.isSkipTypeShardUpdateWithNoAdditions() && deltaData.encodedAdditions.isEmpty()) {
                GapEncodedVariableLengthIntegerReader oldRemovals;
                if (!deltaData.encodedRemovals.isEmpty()) {
                    this.notifyListenerAboutDeltaChanges(deltaData.encodedRemovals, deltaData.encodedAdditions, i, this.shards.length);
                }
                HollowListTypeDataElements currentData = this.shards[i].currentDataElements();
                GapEncodedVariableLengthIntegerReader gapEncodedVariableLengthIntegerReader = oldRemovals = currentData.encodedRemovals == null ? GapEncodedVariableLengthIntegerReader.EMPTY_READER : currentData.encodedRemovals;
                if (oldRemovals.isEmpty()) {
                    currentData.encodedRemovals = deltaData.encodedRemovals;
                    oldRemovals.destroy();
                } else {
                    if (!deltaData.encodedRemovals.isEmpty()) {
                        currentData.encodedRemovals = GapEncodedVariableLengthIntegerReader.combine(oldRemovals, deltaData.encodedRemovals, memoryRecycler);
                        oldRemovals.destroy();
                    }
                    deltaData.encodedRemovals.destroy();
                }
                deltaData.encodedAdditions.destroy();
            } else {
                HollowListTypeDataElements nextData = new HollowListTypeDataElements(this.memoryMode, memoryRecycler);
                HollowListTypeDataElements oldData = this.shards[i].currentDataElements();
                nextData.applyDelta(oldData, deltaData);
                this.shards[i].setCurrentData(nextData);
                this.notifyListenerAboutDeltaChanges(deltaData.encodedRemovals, deltaData.encodedAdditions, i, this.shards.length);
                oldData.destroy();
            }
            deltaData.destroy();
            this.stateEngine.getMemoryRecycler().swap();
        }
        if (this.shards.length == 1) {
            this.maxOrdinal = this.shards[0].currentDataElements().maxOrdinal;
        }
    }

    public static void discardSnapshot(HollowBlobInput in, int numShards) throws IOException {
        HollowListTypeReadState.discardType(in, numShards, false);
    }

    public static void discardDelta(HollowBlobInput in, int numShards) throws IOException {
        HollowListTypeReadState.discardType(in, numShards, true);
    }

    public static void discardType(HollowBlobInput in, int numShards, boolean delta) throws IOException {
        HollowListTypeDataElements.discardFromStream(in, numShards, delta);
        if (!delta) {
            SnapshotPopulatedOrdinalsReader.discardOrdinals(in);
        }
    }

    @Override
    public HollowListSchema getSchema() {
        return (HollowListSchema)this.schema;
    }

    @Override
    public int maxOrdinal() {
        return this.maxOrdinal;
    }

    @Override
    public int getElementOrdinal(int ordinal, int listIndex) {
        this.sampler.recordGet();
        return this.shards[ordinal & this.shardNumberMask].getElementOrdinal(ordinal >> this.shardOrdinalShift, listIndex);
    }

    @Override
    public int size(int ordinal) {
        this.sampler.recordSize();
        return this.shards[ordinal & this.shardNumberMask].size(ordinal >> this.shardOrdinalShift);
    }

    @Override
    public HollowOrdinalIterator ordinalIterator(int ordinal) {
        this.sampler.recordIterator();
        return new HollowListOrdinalIterator(ordinal, this);
    }

    @Override
    public HollowSampler getSampler() {
        return this.sampler;
    }

    @Override
    public void setSamplingDirector(HollowSamplingDirector director) {
        this.sampler.setSamplingDirector(director);
    }

    @Override
    public void setFieldSpecificSamplingDirector(HollowFilterConfig fieldSpec, HollowSamplingDirector director) {
        this.sampler.setFieldSpecificSamplingDirector(fieldSpec, director);
    }

    @Override
    public void ignoreUpdateThreadForSampling(Thread t) {
        this.sampler.setUpdateThread(t);
    }

    @Override
    protected void invalidate() {
        this.stateListeners = EMPTY_LISTENERS;
        for (int i = 0; i < this.shards.length; ++i) {
            this.shards[i].invalidate();
        }
    }

    HollowListTypeDataElements[] currentDataElements() {
        HollowListTypeDataElements[] currentDataElements = new HollowListTypeDataElements[this.shards.length];
        for (int i = 0; i < this.shards.length; ++i) {
            currentDataElements[i] = this.shards[i].currentDataElements();
        }
        return currentDataElements;
    }

    void setCurrentData(HollowListTypeDataElements data) {
        if (this.shards.length > 1) {
            throw new UnsupportedOperationException("Cannot directly set data on sharded type state");
        }
        this.shards[0].setCurrentData(data);
        this.maxOrdinal = data.maxOrdinal;
    }

    @Override
    protected void applyToChecksum(HollowChecksum checksum, HollowSchema withSchema) {
        if (!this.getSchema().equals(withSchema)) {
            throw new IllegalArgumentException("HollowListTypeReadState cannot calculate checksum with unequal schemas: " + this.getSchema().getName());
        }
        BitSet populatedOrdinals = this.getListener(PopulatedOrdinalListener.class).getPopulatedOrdinals();
        for (int i = 0; i < this.shards.length; ++i) {
            this.shards[i].applyToChecksum(checksum, populatedOrdinals, i, this.shards.length);
        }
    }

    @Override
    public long getApproximateHeapFootprintInBytes() {
        long totalApproximateHeapFootprintInBytes = 0L;
        for (int i = 0; i < this.shards.length; ++i) {
            totalApproximateHeapFootprintInBytes += this.shards[i].getApproximateHeapFootprintInBytes();
        }
        return totalApproximateHeapFootprintInBytes;
    }

    @Override
    public long getApproximateHoleCostInBytes() {
        long totalApproximateHoleCostInBytes = 0L;
        BitSet populatedOrdinals = this.getPopulatedOrdinals();
        for (int i = 0; i < this.shards.length; ++i) {
            totalApproximateHoleCostInBytes += this.shards[i].getApproximateHoleCostInBytes(populatedOrdinals, i, this.shards.length);
        }
        return totalApproximateHoleCostInBytes;
    }

    @Override
    public int numShards() {
        return this.shards.length;
    }
}

