/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.list;

import com.netflix.hollow.core.memory.FixedLengthData;
import com.netflix.hollow.core.memory.FixedLengthDataFactory;
import com.netflix.hollow.core.memory.MemoryMode;
import com.netflix.hollow.core.memory.encoding.GapEncodedVariableLengthIntegerReader;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import com.netflix.hollow.core.read.HollowBlobInput;
import com.netflix.hollow.core.read.engine.list.HollowListDeltaApplicator;
import java.io.IOException;

public class HollowListTypeDataElements {
    int maxOrdinal;
    FixedLengthData listPointerData;
    FixedLengthData elementData;
    GapEncodedVariableLengthIntegerReader encodedAdditions;
    GapEncodedVariableLengthIntegerReader encodedRemovals;
    int bitsPerListPointer;
    int bitsPerElement;
    long totalNumberOfElements = 0L;
    final ArraySegmentRecycler memoryRecycler;
    final MemoryMode memoryMode;

    public HollowListTypeDataElements(ArraySegmentRecycler memoryRecycler) {
        this(MemoryMode.ON_HEAP, memoryRecycler);
    }

    public HollowListTypeDataElements(MemoryMode memoryMode, ArraySegmentRecycler memoryRecycler) {
        this.memoryMode = memoryMode;
        this.memoryRecycler = memoryRecycler;
    }

    void readSnapshot(HollowBlobInput in) throws IOException {
        this.readFromInput(in, false);
    }

    void readDelta(HollowBlobInput in) throws IOException {
        this.readFromInput(in, true);
    }

    private void readFromInput(HollowBlobInput in, boolean isDelta) throws IOException {
        this.maxOrdinal = VarInt.readVInt(in);
        if (isDelta) {
            this.encodedRemovals = GapEncodedVariableLengthIntegerReader.readEncodedDeltaOrdinals(in, this.memoryRecycler);
            this.encodedAdditions = GapEncodedVariableLengthIntegerReader.readEncodedDeltaOrdinals(in, this.memoryRecycler);
        }
        this.bitsPerListPointer = VarInt.readVInt(in);
        this.bitsPerElement = VarInt.readVInt(in);
        this.totalNumberOfElements = VarInt.readVLong(in);
        this.listPointerData = FixedLengthDataFactory.get(in, this.memoryMode, this.memoryRecycler);
        this.elementData = FixedLengthDataFactory.get(in, this.memoryMode, this.memoryRecycler);
    }

    static void discardFromStream(HollowBlobInput in, int numShards, boolean isDelta) throws IOException {
        if (numShards > 1) {
            VarInt.readVInt(in);
        }
        for (int i = 0; i < numShards; ++i) {
            VarInt.readVInt(in);
            if (isDelta) {
                GapEncodedVariableLengthIntegerReader.discardEncodedDeltaOrdinals(in);
                GapEncodedVariableLengthIntegerReader.discardEncodedDeltaOrdinals(in);
            }
            VarInt.readVInt(in);
            VarInt.readVInt(in);
            VarInt.readVLong(in);
            FixedLengthData.discardFrom(in);
            FixedLengthData.discardFrom(in);
        }
    }

    public void applyDelta(HollowListTypeDataElements fromData, HollowListTypeDataElements deltaData) {
        new HollowListDeltaApplicator(fromData, deltaData, this).applyDelta();
    }

    public void destroy() {
        FixedLengthDataFactory.destroy(this.listPointerData, this.memoryRecycler);
        FixedLengthDataFactory.destroy(this.elementData, this.memoryRecycler);
    }
}

