/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.list;

import com.netflix.hollow.core.memory.encoding.FixedLengthElementArray;
import com.netflix.hollow.core.memory.encoding.GapEncodedVariableLengthIntegerReader;
import com.netflix.hollow.core.read.engine.list.HollowListTypeDataElements;

class HollowListDeltaApplicator {
    private final HollowListTypeDataElements from;
    private final HollowListTypeDataElements delta;
    private final HollowListTypeDataElements target;
    private long currentFromStateCopyStartBit = 0L;
    private long currentDeltaCopyStartBit = 0L;
    private long currentWriteStartBit = 0L;
    private long currentFromStateStartElement = 0L;
    private long currentDeltaStartElement = 0L;
    private long currentWriteStartElement = 0L;
    private GapEncodedVariableLengthIntegerReader removalsReader;
    private GapEncodedVariableLengthIntegerReader additionsReader;

    HollowListDeltaApplicator(HollowListTypeDataElements from, HollowListTypeDataElements delta, HollowListTypeDataElements target) {
        this.from = from;
        this.delta = delta;
        this.target = target;
    }

    public void applyDelta() {
        this.removalsReader = this.from.encodedRemovals == null ? GapEncodedVariableLengthIntegerReader.EMPTY_READER : this.from.encodedRemovals;
        this.additionsReader = this.delta.encodedAdditions;
        this.removalsReader.reset();
        this.additionsReader.reset();
        this.target.encodedRemovals = this.delta.encodedRemovals;
        this.target.maxOrdinal = this.delta.maxOrdinal;
        this.target.totalNumberOfElements = this.delta.totalNumberOfElements;
        this.target.bitsPerListPointer = this.delta.bitsPerListPointer;
        this.target.bitsPerElement = this.delta.bitsPerElement;
        this.target.listPointerData = new FixedLengthElementArray(this.target.memoryRecycler, ((long)this.target.maxOrdinal + 1L) * (long)this.target.bitsPerListPointer);
        this.target.elementData = new FixedLengthElementArray(this.target.memoryRecycler, this.target.totalNumberOfElements * (long)this.target.bitsPerElement);
        if (this.target.bitsPerListPointer == this.from.bitsPerListPointer && this.target.bitsPerElement == this.from.bitsPerElement) {
            this.fastDelta();
        } else {
            this.slowDelta();
        }
        this.from.encodedRemovals = null;
        this.removalsReader.destroy();
        this.additionsReader.destroy();
    }

    private void slowDelta() {
        for (int i = 0; i <= this.target.maxOrdinal; ++i) {
            this.mergeOrdinal(i);
        }
    }

    private void fastDelta() {
        int i = 0;
        int bulkCopyEndOrdinal = Math.min(this.from.maxOrdinal, this.target.maxOrdinal);
        while (i <= this.target.maxOrdinal) {
            int nextElementDiff = Math.min(this.additionsReader.nextElement(), this.removalsReader.nextElement());
            if (nextElementDiff == i || i > bulkCopyEndOrdinal) {
                this.mergeOrdinal(i++);
                continue;
            }
            int recordsToCopy = nextElementDiff - i;
            if (nextElementDiff > bulkCopyEndOrdinal) {
                recordsToCopy = bulkCopyEndOrdinal - i + 1;
            }
            this.fastCopyRecords(recordsToCopy);
            i += recordsToCopy;
        }
    }

    private void fastCopyRecords(int recordsToCopy) {
        long listPointerBitsToCopy = (long)recordsToCopy * (long)this.target.bitsPerListPointer;
        long eachListPointerDifference = this.currentWriteStartElement - this.currentFromStateStartElement;
        this.target.listPointerData.copyBits(this.from.listPointerData, this.currentFromStateCopyStartBit, this.currentWriteStartBit, listPointerBitsToCopy);
        this.target.listPointerData.incrementMany(this.currentWriteStartBit, eachListPointerDifference, this.target.bitsPerListPointer, recordsToCopy);
        this.currentFromStateCopyStartBit += listPointerBitsToCopy;
        this.currentWriteStartBit += listPointerBitsToCopy;
        long fromDataEndElement = this.from.listPointerData.getElementValue(this.currentFromStateCopyStartBit - (long)this.from.bitsPerListPointer, this.from.bitsPerListPointer);
        long elementsToCopy = fromDataEndElement - this.currentFromStateStartElement;
        long bitsToCopy = elementsToCopy * (long)this.from.bitsPerElement;
        this.target.elementData.copyBits(this.from.elementData, this.currentFromStateStartElement * (long)this.from.bitsPerElement, this.currentWriteStartElement * (long)this.from.bitsPerElement, bitsToCopy);
        this.currentFromStateStartElement += elementsToCopy;
        this.currentWriteStartElement += elementsToCopy;
    }

    private void mergeOrdinal(int i) {
        boolean removeData;
        boolean addFromDelta = this.additionsReader.nextElement() == i;
        boolean bl = removeData = this.removalsReader.nextElement() == i;
        if (addFromDelta) {
            this.addFromDelta(this.additionsReader);
        }
        if (i <= this.from.maxOrdinal) {
            long fromDataEndElement = this.from.listPointerData.getElementValue(this.currentFromStateCopyStartBit, this.from.bitsPerListPointer);
            if (!removeData) {
                for (long elementIdx = this.currentFromStateStartElement; elementIdx < fromDataEndElement; ++elementIdx) {
                    long elementOrdinal = this.from.elementData.getElementValue(elementIdx * (long)this.from.bitsPerElement, this.from.bitsPerElement);
                    this.target.elementData.setElementValue(this.currentWriteStartElement * (long)this.target.bitsPerElement, this.target.bitsPerElement, elementOrdinal);
                    ++this.currentWriteStartElement;
                }
            } else {
                this.removalsReader.advance();
            }
            this.currentFromStateStartElement = fromDataEndElement;
            this.currentFromStateCopyStartBit += (long)this.from.bitsPerListPointer;
        }
        this.target.listPointerData.setElementValue(this.currentWriteStartBit, this.target.bitsPerListPointer, this.currentWriteStartElement);
        this.currentWriteStartBit += (long)this.target.bitsPerListPointer;
    }

    private void addFromDelta(GapEncodedVariableLengthIntegerReader additionsReader) {
        long deltaDataEndElement = this.delta.listPointerData.getElementValue(this.currentDeltaCopyStartBit, this.delta.bitsPerListPointer);
        for (long elementIdx = this.currentDeltaStartElement; elementIdx < deltaDataEndElement; ++elementIdx) {
            long elementOrdinal = this.delta.elementData.getElementValue(elementIdx * (long)this.delta.bitsPerElement, this.delta.bitsPerElement);
            this.target.elementData.setElementValue(this.currentWriteStartElement * (long)this.target.bitsPerElement, this.target.bitsPerElement, elementOrdinal);
            ++this.currentWriteStartElement;
        }
        this.currentDeltaStartElement = deltaDataEndElement;
        this.currentDeltaCopyStartBit += (long)this.delta.bitsPerListPointer;
        additionsReader.advance();
    }
}

