/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine;

import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.schema.HollowObjectSchema;

public class SetMapKeyHasher {
    public static int hash(Object[] key, HollowObjectSchema.FieldType[] fieldType) {
        int hash = 0;
        for (int i = 0; i < key.length; ++i) {
            hash *= 31;
            hash ^= SetMapKeyHasher.hash(key[i], fieldType[i]);
        }
        return hash;
    }

    public static int hash(Object key, HollowObjectSchema.FieldType fieldType) {
        switch (fieldType) {
            case INT: {
                return HashCodes.hashInt((Integer)key);
            }
            case LONG: {
                long longVal = (Long)key;
                return HashCodes.hashInt((int)(longVal ^ longVal >>> 32));
            }
            case REFERENCE: {
                return HashCodes.hashInt((Integer)key);
            }
            case BYTES: {
                return HashCodes.hashInt(HashCodes.hashCode((byte[])key));
            }
            case STRING: {
                return HashCodes.hashInt(key.hashCode());
            }
            case BOOLEAN: {
                return HashCodes.hashInt((Boolean)key != false ? 1231 : 1237);
            }
            case DOUBLE: {
                long longBits = Double.doubleToRawLongBits((Double)key);
                return HashCodes.hashInt((int)(longBits ^ longBits >>> 32));
            }
            case FLOAT: {
                return HashCodes.hashInt(Float.floatToRawIntBits(((Float)key).floatValue()));
            }
        }
        throw new IllegalArgumentException("Unknown field type: " + (Object)((Object)fieldType));
    }
}

