/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine;

import com.netflix.hollow.api.sampling.HollowSampler;
import com.netflix.hollow.core.memory.MemoryMode;
import com.netflix.hollow.core.memory.encoding.GapEncodedVariableLengthIntegerReader;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import com.netflix.hollow.core.read.HollowBlobInput;
import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowTypeDataAccess;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeStateListener;
import com.netflix.hollow.core.read.engine.PopulatedOrdinalListener;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.tools.checksum.HollowChecksum;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.stream.Stream;

public abstract class HollowTypeReadState
implements HollowTypeDataAccess {
    protected static final HollowTypeStateListener[] EMPTY_LISTENERS = new HollowTypeStateListener[0];
    protected final HollowReadStateEngine stateEngine;
    protected final MemoryMode memoryMode;
    protected final HollowSchema schema;
    protected HollowTypeStateListener[] stateListeners;

    public HollowTypeReadState(HollowReadStateEngine stateEngine, MemoryMode memoryMode, HollowSchema schema) {
        this.stateEngine = stateEngine;
        this.memoryMode = memoryMode;
        this.schema = schema;
        this.stateListeners = EMPTY_LISTENERS;
    }

    public void addListener(HollowTypeStateListener listener) {
        HollowTypeStateListener[] newListeners = Arrays.copyOf(this.stateListeners, this.stateListeners.length + 1);
        newListeners[newListeners.length - 1] = listener;
        this.stateListeners = newListeners;
    }

    public void removeListener(HollowTypeStateListener listener) {
        if (this.stateListeners.length == 0) {
            return;
        }
        this.stateListeners = (HollowTypeStateListener[])Stream.of(this.stateListeners).filter(l -> l != listener).toArray(HollowTypeStateListener[]::new);
    }

    public HollowTypeStateListener[] getListeners() {
        return this.stateListeners;
    }

    public <T extends HollowTypeStateListener> T getListener(Class<T> listenerClazz) {
        for (HollowTypeStateListener listener : this.stateListeners) {
            if (!listenerClazz.isAssignableFrom(listener.getClass())) continue;
            return (T)listener;
        }
        return null;
    }

    public BitSet getPopulatedOrdinals() {
        return this.getListener(PopulatedOrdinalListener.class).getPopulatedOrdinals();
    }

    public BitSet getPreviousOrdinals() {
        return this.getListener(PopulatedOrdinalListener.class).getPreviousOrdinals();
    }

    public abstract int maxOrdinal();

    public abstract void readSnapshot(HollowBlobInput var1, ArraySegmentRecycler var2) throws IOException;

    public abstract void applyDelta(HollowBlobInput var1, HollowSchema var2, ArraySegmentRecycler var3) throws IOException;

    @Override
    public HollowSchema getSchema() {
        return this.schema;
    }

    @Override
    public HollowDataAccess getDataAccess() {
        return this.stateEngine;
    }

    public HollowReadStateEngine getStateEngine() {
        return this.stateEngine;
    }

    protected void notifyListenerAboutDeltaChanges(GapEncodedVariableLengthIntegerReader removals, GapEncodedVariableLengthIntegerReader additions, int shardNumber, int numShards) {
        for (HollowTypeStateListener stateListener : this.stateListeners) {
            removals.reset();
            int removedOrdinal = removals.nextElement();
            while (removedOrdinal < Integer.MAX_VALUE) {
                stateListener.removedOrdinal(removedOrdinal * numShards + shardNumber);
                removals.advance();
                removedOrdinal = removals.nextElement();
            }
            additions.reset();
            int addedOrdinal = additions.nextElement();
            while (addedOrdinal < Integer.MAX_VALUE) {
                stateListener.addedOrdinal(addedOrdinal * numShards + shardNumber);
                additions.advance();
                addedOrdinal = additions.nextElement();
            }
        }
    }

    @Override
    public abstract HollowSampler getSampler();

    protected abstract void invalidate();

    public HollowChecksum getChecksum(HollowSchema withSchema) {
        HollowChecksum cksum = new HollowChecksum();
        this.applyToChecksum(cksum, withSchema);
        return cksum;
    }

    protected abstract void applyToChecksum(HollowChecksum var1, HollowSchema var2);

    @Override
    public HollowTypeReadState getTypeState() {
        return this;
    }

    public abstract long getApproximateHeapFootprintInBytes();

    public abstract long getApproximateHoleCostInBytes();

    public abstract int numShards();
}

