/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine;

import com.netflix.hollow.api.error.SchemaNotFoundException;
import com.netflix.hollow.core.HollowStateEngine;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import com.netflix.hollow.core.memory.pool.RecyclingRecycler;
import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowTypeDataAccess;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.engine.HollowTypeStateListener;
import com.netflix.hollow.core.read.engine.PopulatedOrdinalListener;
import com.netflix.hollow.core.read.engine.map.HollowMapTypeReadState;
import com.netflix.hollow.core.read.engine.set.HollowSetTypeReadState;
import com.netflix.hollow.core.read.missing.DefaultMissingDataHandler;
import com.netflix.hollow.core.read.missing.MissingDataHandler;
import com.netflix.hollow.core.schema.HollowListSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.schema.HollowSetSchema;
import com.netflix.hollow.core.util.DefaultHashCodeFinder;
import com.netflix.hollow.core.util.HollowObjectHashCodeFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HollowReadStateEngine
implements HollowStateEngine,
HollowDataAccess {
    private final Map<String, HollowTypeReadState> typeStates;
    private final Map<String, List<HollowTypeStateListener>> listeners;
    private final HollowObjectHashCodeFinder hashCodeFinder;
    private final boolean listenToAllPopulatedOrdinals;
    private boolean skipTypeShardUpdateWithNoAdditions;
    private ArraySegmentRecycler memoryRecycler;
    private Map<String, String> headerTags;
    private Set<String> typesWithDefinedHashCodes = new HashSet<String>();
    private long currentRandomizedTag;
    private MissingDataHandler missingDataHandler = new DefaultMissingDataHandler();

    public HollowReadStateEngine() {
        this(DefaultHashCodeFinder.INSTANCE, true, new RecyclingRecycler());
    }

    public HollowReadStateEngine(boolean listenToAllPopulatedOrdinals) {
        this(DefaultHashCodeFinder.INSTANCE, listenToAllPopulatedOrdinals, new RecyclingRecycler());
    }

    public HollowReadStateEngine(ArraySegmentRecycler recycler) {
        this(DefaultHashCodeFinder.INSTANCE, true, recycler);
    }

    public HollowReadStateEngine(boolean listenToAllPopulatedOrdinals, ArraySegmentRecycler recycler) {
        this(DefaultHashCodeFinder.INSTANCE, listenToAllPopulatedOrdinals, recycler);
    }

    @Deprecated
    public HollowReadStateEngine(HollowObjectHashCodeFinder hashCodeFinder) {
        this(hashCodeFinder, true, new RecyclingRecycler());
    }

    @Deprecated
    public HollowReadStateEngine(HollowObjectHashCodeFinder hashCodeFinder, boolean listenToAllPopulatedOrdinals, ArraySegmentRecycler recycler) {
        this.typeStates = new HashMap<String, HollowTypeReadState>();
        this.listeners = new HashMap<String, List<HollowTypeStateListener>>();
        this.hashCodeFinder = hashCodeFinder;
        this.memoryRecycler = recycler;
        this.listenToAllPopulatedOrdinals = listenToAllPopulatedOrdinals;
    }

    @Override
    public HollowObjectHashCodeFinder getHashCodeFinder() {
        return this.hashCodeFinder;
    }

    protected void addTypeState(HollowTypeReadState typeState) {
        List<HollowTypeStateListener> list;
        this.typeStates.put(typeState.getSchema().getName(), typeState);
        if (this.listenToAllPopulatedOrdinals) {
            typeState.addListener(new PopulatedOrdinalListener());
        }
        if ((list = this.listeners.get(typeState.getSchema().getName())) != null) {
            for (HollowTypeStateListener listener : list) {
                typeState.addListener(listener);
            }
        }
    }

    public void addTypeListener(String typeName, HollowTypeStateListener listener) {
        List<HollowTypeStateListener> list = this.listeners.get(typeName);
        if (list == null) {
            list = new ArrayList<HollowTypeStateListener>();
            this.listeners.put(typeName, list);
        }
        list.add(listener);
        HollowTypeReadState typeState = this.typeStates.get(typeName);
        if (typeState != null) {
            typeState.addListener(listener);
        }
    }

    void wireTypeStatesToSchemas() {
        block6: for (HollowTypeReadState state : this.typeStates.values()) {
            switch (state.getSchema().getSchemaType()) {
                case OBJECT: {
                    HollowObjectSchema objSchema = (HollowObjectSchema)state.getSchema();
                    for (int i = 0; i < objSchema.numFields(); ++i) {
                        if (objSchema.getReferencedType(i) == null) continue;
                        objSchema.setReferencedTypeState(i, this.typeStates.get(objSchema.getReferencedType(i)));
                    }
                    continue block6;
                }
                case LIST: {
                    HollowListSchema listSchema = (HollowListSchema)state.getSchema();
                    listSchema.setElementTypeState(this.typeStates.get(listSchema.getElementType()));
                    break;
                }
                case SET: {
                    HollowSetSchema setSchema = (HollowSetSchema)state.getSchema();
                    setSchema.setElementTypeState(this.typeStates.get(setSchema.getElementType()));
                    ((HollowSetTypeReadState)state).buildKeyDeriver();
                    break;
                }
                case MAP: {
                    HollowMapSchema mapSchema = (HollowMapSchema)state.getSchema();
                    mapSchema.setKeyTypeState(this.typeStates.get(mapSchema.getKeyType()));
                    mapSchema.setValueTypeState(this.typeStates.get(mapSchema.getValueType()));
                    ((HollowMapTypeReadState)state).buildKeyDeriver();
                }
            }
        }
    }

    public long calcApproxDataSize() {
        return this.getAllTypes().stream().map(this::getTypeState).mapToLong(HollowTypeReadState::getApproximateHeapFootprintInBytes).sum();
    }

    @Override
    public HollowTypeDataAccess getTypeDataAccess(String type) {
        return this.typeStates.get(type);
    }

    @Override
    public HollowTypeDataAccess getTypeDataAccess(String type, int ordinal) {
        return this.typeStates.get(type);
    }

    @Override
    public Collection<String> getAllTypes() {
        return this.typeStates.keySet();
    }

    public HollowTypeReadState getTypeState(String type) {
        return this.typeStates.get(type);
    }

    public Collection<HollowTypeReadState> getTypeStates() {
        return this.typeStates.values();
    }

    public ArraySegmentRecycler getMemoryRecycler() {
        return this.memoryRecycler;
    }

    public boolean isListenToAllPopulatedOrdinals() {
        return this.listenToAllPopulatedOrdinals;
    }

    public void setSkipTypeShardUpdateWithNoAdditions(boolean skipTypeShardUpdateWithNoAdditions) {
        this.skipTypeShardUpdateWithNoAdditions = skipTypeShardUpdateWithNoAdditions;
    }

    public boolean isSkipTypeShardUpdateWithNoAdditions() {
        return this.skipTypeShardUpdateWithNoAdditions;
    }

    @Override
    public List<HollowSchema> getSchemas() {
        ArrayList<HollowSchema> schemas = new ArrayList<HollowSchema>();
        for (Map.Entry<String, HollowTypeReadState> entry : this.typeStates.entrySet()) {
            schemas.add(entry.getValue().getSchema());
        }
        return schemas;
    }

    @Override
    public HollowSchema getSchema(String type) {
        HollowTypeReadState typeState = this.getTypeState(type);
        return typeState == null ? null : typeState.getSchema();
    }

    @Override
    public HollowSchema getNonNullSchema(String type) {
        HollowSchema schema = this.getSchema(type);
        if (schema == null) {
            throw new SchemaNotFoundException(type, this.getAllTypes());
        }
        return schema;
    }

    protected void afterInitialization() {
    }

    public void setMissingDataHandler(MissingDataHandler handler) {
        this.missingDataHandler = handler;
    }

    @Override
    public MissingDataHandler getMissingDataHandler() {
        return this.missingDataHandler;
    }

    public void setHeaderTags(Map<String, String> headerTags) {
        this.headerTags = headerTags;
        this.populatedDefinedHashCodesTypesIfHeaderTagIsPresent();
    }

    @Override
    public Map<String, String> getHeaderTags() {
        return this.headerTags;
    }

    @Override
    public String getHeaderTag(String name) {
        return this.headerTags.get(name);
    }

    public void invalidate() {
        this.listeners.clear();
        for (Map.Entry<String, HollowTypeReadState> entry : this.typeStates.entrySet()) {
            entry.getValue().invalidate();
        }
        this.memoryRecycler = null;
    }

    @Override
    public void resetSampling() {
        for (Map.Entry<String, HollowTypeReadState> entry : this.typeStates.entrySet()) {
            entry.getValue().getSampler().reset();
        }
    }

    @Override
    public boolean hasSampleResults() {
        for (Map.Entry<String, HollowTypeReadState> entry : this.typeStates.entrySet()) {
            if (!entry.getValue().getSampler().hasSampleResults()) continue;
            return true;
        }
        return false;
    }

    public boolean updatedLastCycle() {
        for (Map.Entry<String, HollowTypeReadState> entry : this.typeStates.entrySet()) {
            if (!entry.getValue().getListener(PopulatedOrdinalListener.class).updatedLastCycle()) continue;
            return true;
        }
        return false;
    }

    public Set<String> getTypesWithDefinedHashCodes() {
        return this.typesWithDefinedHashCodes;
    }

    public long getCurrentRandomizedTag() {
        return this.currentRandomizedTag;
    }

    public void setCurrentRandomizedTag(long currentRandomizedTag) {
        this.currentRandomizedTag = currentRandomizedTag;
    }

    private void populatedDefinedHashCodesTypesIfHeaderTagIsPresent() {
        String definedHashCodesTag = this.headerTags.get("DEFINED_HASH_CODES");
        if (definedHashCodesTag == null || "".equals(definedHashCodesTag)) {
            this.typesWithDefinedHashCodes = Collections.emptySet();
        } else {
            HashSet<String> definedHashCodeTypes = new HashSet<String>();
            for (String type : definedHashCodesTag.split(",")) {
                definedHashCodeTypes.add(type);
            }
            this.typesWithDefinedHashCodes = definedHashCodeTypes;
        }
    }
}

