/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine;

import com.netflix.hollow.core.HollowBlobHeader;
import com.netflix.hollow.core.HollowBlobOptionalPartHeader;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.read.HollowBlobInput;
import com.netflix.hollow.core.schema.HollowSchema;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HollowBlobHeaderReader {
    public HollowBlobHeader readHeader(InputStream is) throws IOException {
        return this.readHeader(HollowBlobInput.serial(is));
    }

    public HollowBlobHeader readHeader(HollowBlobInput in) throws IOException {
        HollowBlobHeader header = new HollowBlobHeader();
        int headerVersion = in.readInt();
        if (headerVersion != 1030) {
            throw new IOException("The HollowBlob you are trying to read is incompatible. The expected Hollow blob version was 1030 but the actual version was " + headerVersion);
        }
        header.setBlobFormatVersion(headerVersion);
        header.setOriginRandomizedTag(in.readLong());
        header.setDestinationRandomizedTag(in.readLong());
        int oldBytesToSkip = VarInt.readVInt(in);
        if (oldBytesToSkip != 0) {
            header.setSchemas(this.readSchemas(in));
            this.skipForwardCompatibilityBytes(in);
        }
        Map<String, String> headerTags = this.readHeaderTags(in);
        header.setHeaderTags(headerTags);
        return header;
    }

    public HollowBlobOptionalPartHeader readPartHeader(InputStream is) throws IOException {
        return this.readPartHeader(HollowBlobInput.serial(is));
    }

    public HollowBlobOptionalPartHeader readPartHeader(HollowBlobInput in) throws IOException {
        int headerVersion = in.readInt();
        if (headerVersion != 1031) {
            throw new IOException("The HollowBlob optional part you are trying to read is incompatible. The expected Hollow blob version was 1030 but the actual version was " + headerVersion);
        }
        HollowBlobOptionalPartHeader header = new HollowBlobOptionalPartHeader(in.readUTF());
        header.setOriginRandomizedTag(in.readLong());
        header.setDestinationRandomizedTag(in.readLong());
        header.setSchemas(this.readSchemas(in));
        this.skipForwardCompatibilityBytes(in);
        return header;
    }

    private List<HollowSchema> readSchemas(HollowBlobInput in) throws IOException {
        int numSchemas = VarInt.readVInt(in);
        ArrayList<HollowSchema> schemas = new ArrayList<HollowSchema>(numSchemas);
        for (int i = 0; i < numSchemas; ++i) {
            schemas.add(HollowSchema.readFrom(in));
        }
        return schemas;
    }

    private void skipForwardCompatibilityBytes(HollowBlobInput in) throws IOException, EOFException {
        int skippedBytes;
        for (int bytesToSkip = VarInt.readVInt(in); bytesToSkip > 0; bytesToSkip -= skippedBytes) {
            skippedBytes = (int)in.skipBytes(bytesToSkip);
            if (skippedBytes >= 0) continue;
            throw new EOFException();
        }
    }

    private Map<String, String> readHeaderTags(HollowBlobInput in) throws IOException {
        int numHeaderTags = in.readShort();
        HashMap<String, String> headerTags = new HashMap<String, String>();
        for (int i = 0; i < numHeaderTags; ++i) {
            headerTags.put(in.readUTF(), in.readUTF());
        }
        return headerTags;
    }
}

