/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.dataaccess.proxy;

import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowListTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowMapTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowSetTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.disabled.HollowDisabledDataAccess;
import com.netflix.hollow.core.read.dataaccess.disabled.HollowListDisabledDataAccess;
import com.netflix.hollow.core.read.dataaccess.disabled.HollowMapDisabledDataAccess;
import com.netflix.hollow.core.read.dataaccess.disabled.HollowObjectDisabledDataAccess;
import com.netflix.hollow.core.read.dataaccess.disabled.HollowSetDisabledDataAccess;
import com.netflix.hollow.core.read.dataaccess.proxy.HollowListProxyDataAccess;
import com.netflix.hollow.core.read.dataaccess.proxy.HollowMapProxyDataAccess;
import com.netflix.hollow.core.read.dataaccess.proxy.HollowObjectProxyDataAccess;
import com.netflix.hollow.core.read.dataaccess.proxy.HollowSetProxyDataAccess;
import com.netflix.hollow.core.read.dataaccess.proxy.HollowTypeProxyDataAccess;
import com.netflix.hollow.core.read.missing.MissingDataHandler;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.util.HollowObjectHashCodeFinder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HollowProxyDataAccess
implements HollowDataAccess {
    private HollowDataAccess currentDataAccess;
    private final ConcurrentHashMap<String, HollowTypeProxyDataAccess> typeDataAccessMap = new ConcurrentHashMap();

    public void setDataAccess(HollowDataAccess currentDataAccess) {
        this.currentDataAccess = currentDataAccess;
        for (String type : currentDataAccess.getAllTypes()) {
            HollowTypeDataAccess typeDataAccess = currentDataAccess.getTypeDataAccess(type);
            HollowTypeProxyDataAccess proxyDataAccess = this.typeDataAccessMap.get(type);
            if (proxyDataAccess == null) {
                if (typeDataAccess instanceof HollowObjectTypeDataAccess) {
                    proxyDataAccess = new HollowObjectProxyDataAccess(this);
                } else if (typeDataAccess instanceof HollowListTypeDataAccess) {
                    proxyDataAccess = new HollowListProxyDataAccess(this);
                } else if (typeDataAccess instanceof HollowSetTypeDataAccess) {
                    proxyDataAccess = new HollowSetProxyDataAccess(this);
                } else if (typeDataAccess instanceof HollowMapTypeDataAccess) {
                    proxyDataAccess = new HollowMapProxyDataAccess(this);
                }
                this.typeDataAccessMap.put(type, proxyDataAccess);
            }
            proxyDataAccess.setCurrentDataAccess(typeDataAccess);
        }
    }

    public void disableDataAccess() {
        this.currentDataAccess = HollowDisabledDataAccess.INSTANCE;
        for (Map.Entry<String, HollowTypeProxyDataAccess> entry : this.typeDataAccessMap.entrySet()) {
            HollowTypeProxyDataAccess proxy = entry.getValue();
            if (proxy instanceof HollowObjectProxyDataAccess) {
                proxy.setCurrentDataAccess(HollowObjectDisabledDataAccess.INSTANCE);
                continue;
            }
            if (proxy instanceof HollowListProxyDataAccess) {
                proxy.setCurrentDataAccess(HollowListDisabledDataAccess.INSTANCE);
                continue;
            }
            if (proxy instanceof HollowSetProxyDataAccess) {
                proxy.setCurrentDataAccess(HollowSetDisabledDataAccess.INSTANCE);
                continue;
            }
            if (!(proxy instanceof HollowMapProxyDataAccess)) continue;
            proxy.setCurrentDataAccess(HollowMapDisabledDataAccess.INSTANCE);
        }
    }

    @Override
    public HollowTypeDataAccess getTypeDataAccess(String typeName) {
        return this.typeDataAccessMap.get(typeName);
    }

    @Override
    public HollowTypeDataAccess getTypeDataAccess(String typeName, int ordinal) {
        return this.typeDataAccessMap.get(typeName);
    }

    @Override
    public HollowObjectHashCodeFinder getHashCodeFinder() {
        return this.currentDataAccess.getHashCodeFinder();
    }

    @Override
    public MissingDataHandler getMissingDataHandler() {
        return this.currentDataAccess.getMissingDataHandler();
    }

    @Override
    public Collection<String> getAllTypes() {
        return this.typeDataAccessMap.keySet();
    }

    @Override
    public List<HollowSchema> getSchemas() {
        return this.currentDataAccess.getSchemas();
    }

    @Override
    public HollowSchema getSchema(String name) {
        return this.currentDataAccess.getSchema(name);
    }

    @Override
    public HollowSchema getNonNullSchema(String name) {
        return this.currentDataAccess.getNonNullSchema(name);
    }

    @Override
    public void resetSampling() {
        this.currentDataAccess.resetSampling();
    }

    @Override
    public boolean hasSampleResults() {
        return this.currentDataAccess.hasSampleResults();
    }

    public HollowDataAccess getProxiedDataAccess() {
        return this.currentDataAccess;
    }
}

