/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.memory.encoding;

import com.netflix.hollow.core.memory.ByteData;
import com.netflix.hollow.core.memory.ByteDataArray;
import com.netflix.hollow.core.read.HollowBlobInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class VarInt {
    public static void writeVNull(ByteDataArray buf) {
        buf.write((byte)-128);
    }

    public static void writeVLong(ByteDataArray buf, long value) {
        if (value < 0L) {
            buf.write((byte)-127);
        }
        if (value > 0xFFFFFFFFFFFFFFL || value < 0L) {
            buf.write((byte)(0x80L | value >>> 56 & 0x7FL));
        }
        if (value > 0x1FFFFFFFFFFFFL || value < 0L) {
            buf.write((byte)(0x80L | value >>> 49 & 0x7FL));
        }
        if (value > 0x3FFFFFFFFFFL || value < 0L) {
            buf.write((byte)(0x80L | value >>> 42 & 0x7FL));
        }
        if (value > 0x7FFFFFFFFL || value < 0L) {
            buf.write((byte)(0x80L | value >>> 35 & 0x7FL));
        }
        if (value > 0xFFFFFFFL || value < 0L) {
            buf.write((byte)(0x80L | value >>> 28 & 0x7FL));
        }
        if (value > 0x1FFFFFL || value < 0L) {
            buf.write((byte)(0x80L | value >>> 21 & 0x7FL));
        }
        if (value > 16383L || value < 0L) {
            buf.write((byte)(0x80L | value >>> 14 & 0x7FL));
        }
        if (value > 127L || value < 0L) {
            buf.write((byte)(0x80L | value >>> 7 & 0x7FL));
        }
        buf.write((byte)(value & 0x7FL));
    }

    public static void writeVLong(OutputStream out, long value) throws IOException {
        if (value < 0L) {
            out.write(-127);
        }
        if (value > 0xFFFFFFFFFFFFFFL || value < 0L) {
            out.write((byte)(0x80L | value >>> 56 & 0x7FL));
        }
        if (value > 0x1FFFFFFFFFFFFL || value < 0L) {
            out.write((byte)(0x80L | value >>> 49 & 0x7FL));
        }
        if (value > 0x3FFFFFFFFFFL || value < 0L) {
            out.write((byte)(0x80L | value >>> 42 & 0x7FL));
        }
        if (value > 0x7FFFFFFFFL || value < 0L) {
            out.write((byte)(0x80L | value >>> 35 & 0x7FL));
        }
        if (value > 0xFFFFFFFL || value < 0L) {
            out.write((byte)(0x80L | value >>> 28 & 0x7FL));
        }
        if (value > 0x1FFFFFL || value < 0L) {
            out.write((byte)(0x80L | value >>> 21 & 0x7FL));
        }
        if (value > 16383L || value < 0L) {
            out.write((byte)(0x80L | value >>> 14 & 0x7FL));
        }
        if (value > 127L || value < 0L) {
            out.write((byte)(0x80L | value >>> 7 & 0x7FL));
        }
        out.write((byte)(value & 0x7FL));
    }

    public static void writeVInt(ByteDataArray buf, int value) {
        if (value > 0xFFFFFFF || value < 0) {
            buf.write((byte)(0x80 | value >>> 28));
        }
        if (value > 0x1FFFFF || value < 0) {
            buf.write((byte)(0x80 | value >>> 21 & 0x7F));
        }
        if (value > 16383 || value < 0) {
            buf.write((byte)(0x80 | value >>> 14 & 0x7F));
        }
        if (value > 127 || value < 0) {
            buf.write((byte)(0x80 | value >>> 7 & 0x7F));
        }
        buf.write((byte)(value & 0x7F));
    }

    public static void writeVInt(OutputStream out, int value) throws IOException {
        if (value > 0xFFFFFFF || value < 0) {
            out.write((byte)(0x80 | value >>> 28));
        }
        if (value > 0x1FFFFF || value < 0) {
            out.write((byte)(0x80 | value >>> 21 & 0x7F));
        }
        if (value > 16383 || value < 0) {
            out.write((byte)(0x80 | value >>> 14 & 0x7F));
        }
        if (value > 127 || value < 0) {
            out.write((byte)(0x80 | value >>> 7 & 0x7F));
        }
        out.write((byte)(value & 0x7F));
    }

    public static int writeVInt(byte[] data, int pos, int value) {
        if (value > 0xFFFFFFF || value < 0) {
            data[pos++] = (byte)(0x80 | value >>> 28);
        }
        if (value > 0x1FFFFF || value < 0) {
            data[pos++] = (byte)(0x80 | value >>> 21 & 0x7F);
        }
        if (value > 16383 || value < 0) {
            data[pos++] = (byte)(0x80 | value >>> 14 & 0x7F);
        }
        if (value > 127 || value < 0) {
            data[pos++] = (byte)(0x80 | value >>> 7 & 0x7F);
        }
        data[pos++] = (byte)(value & 0x7F);
        return pos;
    }

    public static boolean readVNull(ByteData arr, long position) {
        return arr.get(position) == -128;
    }

    public static int readVInt(ByteData arr, long position) {
        byte b;
        if ((b = arr.get(position++)) == -128) {
            throw new RuntimeException("Attempting to read null value as int");
        }
        int value = b & 0x7F;
        while ((b & 0x80) != 0) {
            b = arr.get(position++);
            value <<= 7;
            value |= b & 0x7F;
        }
        return value;
    }

    public static int readVInt(InputStream in) throws IOException {
        byte b = VarInt.readByteSafely(in);
        if (b == -128) {
            throw new RuntimeException("Attempting to read null value as int");
        }
        int value = b & 0x7F;
        while ((b & 0x80) != 0) {
            b = VarInt.readByteSafely(in);
            value <<= 7;
            value |= b & 0x7F;
        }
        return value;
    }

    public static int readVInt(HollowBlobInput in) throws IOException {
        byte b = VarInt.readByteSafely(in);
        if (b == -128) {
            throw new RuntimeException("Attempting to read null value as int");
        }
        int value = b & 0x7F;
        while ((b & 0x80) != 0) {
            b = VarInt.readByteSafely(in);
            value <<= 7;
            value |= b & 0x7F;
        }
        return value;
    }

    public static long readVLong(ByteData arr, long position) {
        byte b;
        if ((b = arr.get(position++)) == -128) {
            throw new RuntimeException("Attempting to read null value as long");
        }
        long value = b & 0x7F;
        while ((b & 0x80) != 0) {
            b = arr.get(position++);
            value <<= 7;
            value |= (long)(b & 0x7F);
        }
        return value;
    }

    public static int nextVLongSize(ByteData arr, long position) {
        byte b;
        if ((b = arr.get(position++)) == -128) {
            return 1;
        }
        int length = 1;
        while ((b & 0x80) != 0) {
            b = arr.get(position++);
            ++length;
        }
        return length;
    }

    public static long readVLong(InputStream in) throws IOException {
        byte b = VarInt.readByteSafely(in);
        if (b == -128) {
            throw new RuntimeException("Attempting to read null value as long");
        }
        long value = b & 0x7F;
        while ((b & 0x80) != 0) {
            b = VarInt.readByteSafely(in);
            value <<= 7;
            value |= (long)(b & 0x7F);
        }
        return value;
    }

    public static long readVLong(HollowBlobInput in) throws IOException {
        byte b = VarInt.readByteSafely(in);
        if (b == -128) {
            throw new RuntimeException("Attempting to read null value as long");
        }
        long value = b & 0x7F;
        while ((b & 0x80) != 0) {
            b = VarInt.readByteSafely(in);
            value <<= 7;
            value |= (long)(b & 0x7F);
        }
        return value;
    }

    public static int sizeOfVInt(int value) {
        if (value < 0) {
            return 5;
        }
        if (value < 128) {
            return 1;
        }
        if (value < 16384) {
            return 2;
        }
        if (value < 0x200000) {
            return 3;
        }
        if (value < 0x10000000) {
            return 4;
        }
        return 5;
    }

    public static int sizeOfVLong(long value) {
        if (value < 0L) {
            return 10;
        }
        if (value < 128L) {
            return 1;
        }
        if (value < 16384L) {
            return 2;
        }
        if (value < 0x200000L) {
            return 3;
        }
        if (value < 0x10000000L) {
            return 4;
        }
        if (value < 0x800000000L) {
            return 5;
        }
        if (value < 0x40000000000L) {
            return 6;
        }
        if (value < 0x2000000000000L) {
            return 7;
        }
        if (value < 0x100000000000000L) {
            return 8;
        }
        return 9;
    }

    public static int countVarIntsInRange(ByteData byteData, long fieldPosition, int length) {
        int numInts = 0;
        boolean insideInt = false;
        for (int i = 0; i < length; ++i) {
            byte b = byteData.get(fieldPosition + (long)i);
            if ((b & 0x80) == 0) {
                ++numInts;
                insideInt = false;
                continue;
            }
            if (!insideInt && b == -128) {
                ++numInts;
                continue;
            }
            insideInt = true;
        }
        return numInts;
    }

    public static byte readByteSafely(InputStream is) throws IOException {
        int i = is.read();
        if (i == -1) {
            throw new EOFException("Unexpected end of VarInt record");
        }
        return (byte)i;
    }

    public static byte readByteSafely(HollowBlobInput in) throws IOException {
        int i = in.read();
        if (i == -1) {
            throw new EOFException("Unexpected end of VarInt record");
        }
        return (byte)i;
    }
}

