/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.memory.encoding;

import com.netflix.hollow.core.memory.encoding.FixedLengthElementArray;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.LongStream;

public class FixedLengthMultipleOccurrenceElementArray {
    private static final double RESIZE_MULTIPLE = 1.5;
    private static final long NO_ELEMENT = 0L;
    private final ArraySegmentRecycler memoryRecycler;
    private final FixedLengthElementArray nodesWithOrdinalZero;
    private final int bitsPerElement;
    private final long elementMask;
    private final long numNodes;
    private volatile FixedLengthElementArray storage;
    private volatile int maxElementsPerNode;

    public FixedLengthMultipleOccurrenceElementArray(ArraySegmentRecycler memoryRecycler, long numNodes, int bitsPerElement, int maxElementsPerNodeEstimate) {
        this.nodesWithOrdinalZero = new FixedLengthElementArray(memoryRecycler, numNodes);
        this.storage = new FixedLengthElementArray(memoryRecycler, numNodes * (long)bitsPerElement * (long)maxElementsPerNodeEstimate);
        this.memoryRecycler = memoryRecycler;
        this.bitsPerElement = bitsPerElement;
        this.elementMask = (1L << bitsPerElement) - 1L;
        this.numNodes = numNodes;
        this.maxElementsPerNode = maxElementsPerNodeEstimate;
    }

    public void addElement(long nodeIndex, long element) {
        long currentIndex;
        if (element > this.elementMask) {
            throw new IllegalArgumentException("Element " + element + " does not fit in " + this.bitsPerElement + " bits");
        }
        if (nodeIndex >= this.numNodes) {
            throw new IllegalArgumentException("Provided nodeIndex  " + nodeIndex + " greater then numNodes " + this.numNodes);
        }
        if (element == 0L) {
            this.nodesWithOrdinalZero.setElementValue(nodeIndex, 1, 1L);
            return;
        }
        long bucketStart = nodeIndex * (long)this.maxElementsPerNode * (long)this.bitsPerElement;
        int offset = 0;
        while (this.storage.getElementValue(currentIndex = bucketStart + (long)(offset * this.bitsPerElement), this.bitsPerElement, this.elementMask) != 0L && ++offset < this.maxElementsPerNode) {
        }
        if (this.storage.getElementValue(currentIndex, this.bitsPerElement, this.elementMask) != 0L) {
            this.resizeStorage();
            currentIndex = nodeIndex * (long)this.maxElementsPerNode * (long)this.bitsPerElement + (long)(offset * this.bitsPerElement);
        }
        this.storage.setElementValue(currentIndex, this.bitsPerElement, element);
    }

    public List<Long> getElements(long nodeIndex) {
        long element;
        long bucketStart = nodeIndex * (long)this.maxElementsPerNode * (long)this.bitsPerElement;
        ArrayList<Long> ret = new ArrayList<Long>();
        if (this.nodesWithOrdinalZero.getElementValue(nodeIndex, 1, 1L) != 0L) {
            ret.add(0L);
        }
        for (int offset = 0; offset < this.maxElementsPerNode && (element = this.storage.getElementValue(bucketStart + (long)(offset * this.bitsPerElement), this.bitsPerElement, this.elementMask)) != 0L; ++offset) {
            ret.add(element);
        }
        return ret;
    }

    public void destroy() {
        this.storage.destroy(this.memoryRecycler);
    }

    private void resizeStorage() {
        int currentElementsPerNode = this.maxElementsPerNode;
        int newElementsPerNode = (int)((double)currentElementsPerNode * 1.5);
        if (newElementsPerNode <= currentElementsPerNode) {
            throw new IllegalStateException("cannot resize fixed length array from " + currentElementsPerNode + " to " + newElementsPerNode);
        }
        FixedLengthElementArray newStorage = new FixedLengthElementArray(this.memoryRecycler, this.numNodes * (long)this.bitsPerElement * (long)newElementsPerNode);
        LongStream.range(0L, this.numNodes).forEach(nodeIndex -> {
            long element;
            long currentBucketStart = nodeIndex * (long)currentElementsPerNode * (long)this.bitsPerElement;
            long newBucketStart = nodeIndex * (long)newElementsPerNode * (long)this.bitsPerElement;
            for (int offset = 0; offset < currentElementsPerNode && (element = this.storage.getElementValue(currentBucketStart + (long)(offset * this.bitsPerElement), this.bitsPerElement, this.elementMask)) != 0L; ++offset) {
                newStorage.setElementValue(newBucketStart + (long)(offset * this.bitsPerElement), this.bitsPerElement, element);
            }
        });
        this.storage.destroy(this.memoryRecycler);
        this.storage = newStorage;
        this.maxElementsPerNode = newElementsPerNode;
    }
}

