/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.memory.encoding;

import com.netflix.hollow.core.memory.FixedLengthData;
import com.netflix.hollow.core.memory.HollowUnsafeHandle;
import com.netflix.hollow.core.memory.SegmentedLongArray;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import com.netflix.hollow.core.read.HollowBlobInput;
import java.io.IOException;
import sun.misc.Unsafe;

public class FixedLengthElementArray
extends SegmentedLongArray
implements FixedLengthData {
    private static final Unsafe unsafe = HollowUnsafeHandle.getUnsafe();
    private final int log2OfSegmentSizeInBytes;
    private final int byteBitmask;

    public FixedLengthElementArray(ArraySegmentRecycler memoryRecycler, long numBits) {
        super(memoryRecycler, (numBits - 1L >>> 6) + 1L);
        this.log2OfSegmentSizeInBytes = this.log2OfSegmentSize + 3;
        this.byteBitmask = (1 << this.log2OfSegmentSizeInBytes) - 1;
    }

    @Override
    public void clearElementValue(long index, int bitsPerElement) {
        long whichLong = index >>> 6;
        int whichBit = (int)(index & 0x3FL);
        long mask = (1L << bitsPerElement) - 1L;
        this.set(whichLong, this.get(whichLong) & (mask << whichBit ^ 0xFFFFFFFFFFFFFFFFL));
        int bitsRemaining = 64 - whichBit;
        if (bitsRemaining < bitsPerElement) {
            this.set(whichLong + 1L, this.get(whichLong + 1L) & (mask >>> bitsRemaining ^ 0xFFFFFFFFFFFFFFFFL));
        }
    }

    @Override
    public void setElementValue(long index, int bitsPerElement, long value) {
        long whichLong = index >>> 6;
        int whichBit = (int)(index & 0x3FL);
        this.set(whichLong, this.get(whichLong) | value << whichBit);
        int bitsRemaining = 64 - whichBit;
        if (bitsRemaining < bitsPerElement) {
            this.set(whichLong + 1L, this.get(whichLong + 1L) | value >>> bitsRemaining);
        }
    }

    @Override
    public long getElementValue(long index, int bitsPerElement) {
        return this.getElementValue(index, bitsPerElement, (1L << bitsPerElement) - 1L);
    }

    @Override
    public long getElementValue(long index, int bitsPerElement, long mask) {
        long whichByte = index >>> 3;
        int whichBit = (int)(index & 7L);
        int whichSegment = (int)(whichByte >>> this.log2OfSegmentSizeInBytes);
        long[] segment = this.segments[whichSegment];
        long elementByteOffset = (long)Unsafe.ARRAY_LONG_BASE_OFFSET + (whichByte & (long)this.byteBitmask);
        long longVal = unsafe.getLong(segment, elementByteOffset);
        long l = longVal >>> whichBit;
        return l & mask;
    }

    @Override
    public long getLargeElementValue(long index, int bitsPerElement) {
        long mask = bitsPerElement == 64 ? -1L : (1L << bitsPerElement) - 1L;
        return this.getLargeElementValue(index, bitsPerElement, mask);
    }

    @Override
    public long getLargeElementValue(long index, int bitsPerElement, long mask) {
        long whichLong = index >>> 6;
        int whichBit = (int)(index & 0x3FL);
        long l = this.get(whichLong) >>> whichBit;
        int bitsRemaining = 64 - whichBit;
        if (bitsRemaining < bitsPerElement) {
            l |= this.get(++whichLong) << bitsRemaining;
        }
        return l & mask;
    }

    @Override
    public void copyBits(FixedLengthData copyFrom, long sourceStartBit, long destStartBit, long numBits) {
        if (numBits == 0L) {
            return;
        }
        if ((destStartBit & 0x3FL) != 0L) {
            int fillBits = (int)Math.min(64L - (destStartBit & 0x3FL), numBits);
            long fillValue = copyFrom.getLargeElementValue(sourceStartBit, fillBits);
            this.setElementValue(destStartBit, fillBits, fillValue);
            destStartBit += (long)fillBits;
            sourceStartBit += (long)fillBits;
            numBits -= (long)fillBits;
        }
        long currentWriteLong = destStartBit >>> 6;
        while (numBits >= 64L) {
            long l = copyFrom.getLargeElementValue(sourceStartBit, 64, -1L);
            this.set(currentWriteLong, l);
            numBits -= 64L;
            sourceStartBit += 64L;
            ++currentWriteLong;
        }
        if (numBits != 0L) {
            destStartBit = currentWriteLong << 6;
            long fillValue = copyFrom.getLargeElementValue(sourceStartBit, (int)numBits);
            this.setElementValue(destStartBit, (int)numBits, fillValue);
        }
    }

    @Override
    public void incrementMany(long startBit, long increment, long bitsBetweenIncrements, int numIncrements) {
        long endBit = startBit + bitsBetweenIncrements * (long)numIncrements;
        while (startBit < endBit) {
            this.increment(startBit, increment);
            startBit += bitsBetweenIncrements;
        }
    }

    public void increment(long index, long increment) {
        long whichByte = index >>> 3;
        int whichBit = (int)(index & 7L);
        int whichSegment = (int)(whichByte >>> this.log2OfSegmentSizeInBytes);
        long[] segment = this.segments[whichSegment];
        long elementByteOffset = (long)Unsafe.ARRAY_LONG_BASE_OFFSET + (whichByte & (long)this.byteBitmask);
        long l = unsafe.getLong(segment, elementByteOffset);
        unsafe.putLong(segment, elementByteOffset, l + (increment << whichBit));
        if ((whichByte & (long)this.byteBitmask) > (long)(this.bitmask * 8) && whichSegment + 1 < this.segments.length) {
            unsafe.putLong(this.segments[whichSegment + 1], Unsafe.ARRAY_LONG_BASE_OFFSET, this.segments[whichSegment][this.bitmask + 1]);
        }
        if ((whichByte & (long)this.byteBitmask) < 8L && whichSegment > 0) {
            unsafe.putLong(this.segments[whichSegment - 1], (long)Unsafe.ARRAY_LONG_BASE_OFFSET + (long)(8 * (this.bitmask + 1)), this.segments[whichSegment][0]);
        }
    }

    public static FixedLengthElementArray newFrom(HollowBlobInput in, ArraySegmentRecycler memoryRecycler) throws IOException {
        long numLongs = VarInt.readVLong(in);
        return FixedLengthElementArray.newFrom(in, memoryRecycler, numLongs);
    }

    public static FixedLengthElementArray newFrom(HollowBlobInput in, ArraySegmentRecycler memoryRecycler, long numLongs) throws IOException {
        FixedLengthElementArray arr = new FixedLengthElementArray(memoryRecycler, numLongs * 64L);
        arr.readFrom(in, memoryRecycler, numLongs);
        return arr;
    }
}

