/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.memory;

import com.netflix.hollow.core.memory.EncodedByteBuffer;
import com.netflix.hollow.core.memory.MemoryMode;
import com.netflix.hollow.core.memory.SegmentedByteArray;
import com.netflix.hollow.core.memory.VariableLengthData;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import java.util.logging.Logger;

public class VariableLengthDataFactory {
    private static final Logger LOG = Logger.getLogger(VariableLengthDataFactory.class.getName());

    public static VariableLengthData get(MemoryMode memoryMode, ArraySegmentRecycler memoryRecycler) {
        if (memoryMode.equals((Object)MemoryMode.ON_HEAP)) {
            return new SegmentedByteArray(memoryRecycler);
        }
        if (memoryMode.equals((Object)MemoryMode.SHARED_MEMORY_LAZY)) {
            return new EncodedByteBuffer();
        }
        throw new UnsupportedOperationException("Memory mode " + memoryMode.name() + " not supported");
    }

    public static void destroy(VariableLengthData vld) {
        if (vld instanceof SegmentedByteArray) {
            ((SegmentedByteArray)vld).destroy();
        } else if (vld instanceof EncodedByteBuffer) {
            LOG.warning("Destroy operation is a no-op in shared memory mode");
        } else {
            throw new UnsupportedOperationException("Unknown type");
        }
    }
}

