/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.memory;

import com.netflix.hollow.core.memory.ByteData;
import com.netflix.hollow.core.memory.SegmentedByteArray;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import com.netflix.hollow.core.memory.pool.WastefulRecycler;

public class ByteDataArray {
    private final SegmentedByteArray buf;
    private long position;

    public ByteDataArray() {
        this(WastefulRecycler.DEFAULT_INSTANCE);
    }

    public ByteDataArray(ArraySegmentRecycler memoryRecycler) {
        this.buf = new SegmentedByteArray(memoryRecycler);
    }

    public void write(byte b) {
        this.buf.set(this.position++, b);
    }

    public void reset() {
        this.position = 0L;
    }

    public void setPosition(long position) {
        this.position = position;
    }

    public long length() {
        return this.position;
    }

    public void copyTo(ByteDataArray other) {
        other.buf.copy(this.buf, 0L, other.position, this.position);
        other.position += this.position;
    }

    public void copyFrom(ByteData data, long startPosition, int length) {
        this.buf.copy(data, startPosition, this.position, (long)length);
        this.position += (long)length;
    }

    public void copyFrom(SegmentedByteArray data, long startPosition, int length) {
        this.buf.copy(data, startPosition, this.position, (long)length);
        this.position += (long)length;
    }

    public byte get(long index) {
        return this.buf.get(index);
    }

    public SegmentedByteArray getUnderlyingArray() {
        return this.buf;
    }
}

