/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.index.key;

import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import java.util.Arrays;

public class PrimaryKeyValueHasher {
    private final HollowObjectSchema.FieldType[] fieldTypes;

    public PrimaryKeyValueHasher(PrimaryKey key, HollowDataset dataset) {
        this.fieldTypes = new HollowObjectSchema.FieldType[key.numFields()];
        for (int i = 0; i < this.fieldTypes.length; ++i) {
            this.fieldTypes[i] = key.getFieldType(dataset, i);
        }
    }

    public int hash(Object key) {
        return this.hashElement(key, 0);
    }

    public int hash(Object ... keys) {
        int hash = 0;
        for (int i = 0; i < keys.length; ++i) {
            hash *= 31;
            hash ^= this.hashElement(keys[i], i);
        }
        return hash;
    }

    public int hashElement(Object key, int fieldTypeIdx) {
        switch (this.fieldTypes[fieldTypeIdx]) {
            case BOOLEAN: {
                return key == null ? 0 : ((Boolean)key != false ? 1231 : 1237);
            }
            case BYTES: {
                return key == null ? 0 : Arrays.hashCode((byte[])key);
            }
            case DOUBLE: {
                long dVal = Double.doubleToRawLongBits((Double)key);
                return (int)(dVal ^ dVal >>> 32);
            }
            case FLOAT: {
                return Float.floatToRawIntBits(((Float)key).floatValue());
            }
            case LONG: {
                long lVal = (Long)key;
                return (int)(lVal ^ lVal >>> 32);
            }
            case INT: {
                return (Integer)key;
            }
            case REFERENCE: {
                return (Integer)key;
            }
            case STRING: {
                return key.hashCode();
            }
        }
        throw new IllegalArgumentException("Unknown field type: " + (Object)((Object)this.fieldTypes[fieldTypeIdx]));
    }
}

