/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.index.key;

import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.index.FieldPaths;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import java.util.Arrays;

public class PrimaryKey {
    private final String type;
    private final String[] fieldPaths;

    public PrimaryKey(String type, String ... fieldPaths) {
        if (fieldPaths == null || fieldPaths.length == 0) {
            throw new IllegalArgumentException("fieldPaths can't not be null or empty");
        }
        this.type = type;
        this.fieldPaths = (String[])fieldPaths.clone();
    }

    public String getType() {
        return this.type;
    }

    public int numFields() {
        return this.fieldPaths.length;
    }

    public String getFieldPath(int idx) {
        return this.fieldPaths[idx];
    }

    public String[] getFieldPaths() {
        return this.fieldPaths;
    }

    public HollowObjectSchema.FieldType getFieldType(HollowDataset dataset, int fieldPathIdx) {
        return PrimaryKey.getFieldType(dataset, this.type, this.fieldPaths[fieldPathIdx]);
    }

    public HollowObjectSchema getFieldSchema(HollowDataset dataset, int fieldPathIdx) {
        return PrimaryKey.getFieldSchema(dataset, this.type, this.fieldPaths[fieldPathIdx]);
    }

    public int[] getFieldPathIndex(HollowDataset dataset, int fieldPathIdx) {
        return PrimaryKey.getFieldPathIndex(dataset, this.type, this.fieldPaths[fieldPathIdx]);
    }

    public static HollowObjectSchema.FieldType getFieldType(HollowDataset dataAccess, String type, String fieldPath) {
        HollowObjectSchema schema = (HollowObjectSchema)dataAccess.getSchema(type);
        int[] pathIndexes = PrimaryKey.getFieldPathIndex(dataAccess, type, fieldPath);
        for (int i = 0; i < pathIndexes.length - 1; ++i) {
            schema = (HollowObjectSchema)dataAccess.getSchema(schema.getReferencedType(pathIndexes[i]));
        }
        return schema.getFieldType(pathIndexes[pathIndexes.length - 1]);
    }

    public static HollowObjectSchema getFieldSchema(HollowDataset dataAccess, String type, String fieldPath) {
        HollowObjectSchema schema = (HollowObjectSchema)dataAccess.getSchema(type);
        int[] pathIndexes = PrimaryKey.getFieldPathIndex(dataAccess, type, fieldPath);
        for (int i = 0; i < pathIndexes.length; ++i) {
            schema = (HollowObjectSchema)dataAccess.getSchema(schema.getReferencedType(pathIndexes[i]));
        }
        return schema;
    }

    public static String[] getCompleteFieldPathParts(HollowDataset dataset, String type, String fieldPath) {
        int[] fieldPathIdx = PrimaryKey.getFieldPathIndex(dataset, type, fieldPath);
        String[] fieldPathParts = new String[fieldPathIdx.length];
        HollowObjectSchema schema = (HollowObjectSchema)dataset.getSchema(type);
        for (int i = 0; i < fieldPathParts.length; ++i) {
            fieldPathParts[i] = schema.getFieldName(fieldPathIdx[i]);
            schema = (HollowObjectSchema)dataset.getSchema(schema.getReferencedType(fieldPathIdx[i]));
        }
        return fieldPathParts;
    }

    public static int[] getFieldPathIndex(HollowDataset dataset, String type, String fieldPath) {
        return FieldPaths.createFieldPathForPrimaryKey(dataset, type, fieldPath).getSegments().stream().mapToInt(FieldPaths.ObjectFieldSegment::getIndex).toArray();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.fieldPaths);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrimaryKey other = (PrimaryKey)obj;
        if (!Arrays.equals(this.fieldPaths, other.fieldPaths)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        return "PrimaryKey [type=" + this.type + ", fieldPaths=" + Arrays.toString(this.fieldPaths) + "]";
    }
}

