/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.index;

import com.netflix.hollow.core.index.FieldPath;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeStateListener;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class HollowSparseIntegerSet
implements HollowTypeStateListener {
    private final HollowReadStateEngine readStateEngine;
    private final String type;
    private final FieldPath fieldPath;
    private final IndexPredicate predicate;
    protected volatile SparseBitSet sparseBitSetVolatile;
    private Set<Integer> valuesToSet;
    private Set<Integer> valuesToClear;
    private int maxValueToSet;
    private static final IndexPredicate DEFAULT_PREDICATE = new IndexPredicate(){

        @Override
        public boolean shouldIndex(int ordinal) {
            return true;
        }
    };

    public HollowSparseIntegerSet(HollowReadStateEngine readStateEngine, String type, String fieldPath) {
        this(readStateEngine, type, fieldPath, DEFAULT_PREDICATE);
    }

    public HollowSparseIntegerSet(HollowReadStateEngine readStateEngine, String type, String fieldPath, IndexPredicate predicate) {
        if (readStateEngine == null) {
            throw new IllegalArgumentException("Read state engine cannot be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (fieldPath == null || fieldPath.isEmpty()) {
            throw new IllegalArgumentException("fieldPath cannot be null or empty");
        }
        this.readStateEngine = readStateEngine;
        this.type = type;
        this.fieldPath = new FieldPath(readStateEngine, type, fieldPath);
        this.predicate = predicate;
        this.valuesToSet = new HashSet<Integer>();
        this.valuesToClear = new HashSet<Integer>();
        this.build();
    }

    protected void build() {
        this.initSet(Integer.MAX_VALUE);
        BitSet typeBitSet = this.readStateEngine.getTypeState(this.type).getPopulatedOrdinals();
        int ordinal = typeBitSet.nextSetBit(0);
        while (ordinal != -1) {
            this.set(ordinal);
            ordinal = typeBitSet.nextSetBit(ordinal + 1);
        }
        this.compact();
    }

    protected void initSet(int maxValue) {
        this.sparseBitSetVolatile = new SparseBitSet(maxValue);
    }

    protected void set(int ordinal) {
        Object[] values;
        if (this.predicate.shouldIndex(ordinal) && (values = this.fieldPath.findValues(ordinal)) != null && values.length > 0) {
            SparseBitSet bitSet = this.sparseBitSetVolatile;
            for (Object value : values) {
                bitSet.set((Integer)value);
            }
        }
    }

    protected void compact() {
        SparseBitSet compactedSet;
        SparseBitSet current = this.sparseBitSetVolatile;
        this.sparseBitSetVolatile = compactedSet = SparseBitSet.compact(current);
    }

    public boolean get(int i) {
        boolean result;
        SparseBitSet current;
        do {
            current = this.sparseBitSetVolatile;
            result = current.get(i);
        } while (current != this.sparseBitSetVolatile);
        return result;
    }

    public long size() {
        long size;
        SparseBitSet current;
        do {
            current = this.sparseBitSetVolatile;
            size = current.estimateBitsUsed();
        } while (current != this.sparseBitSetVolatile);
        return size;
    }

    public int cardinality() {
        int cardinality;
        SparseBitSet current;
        do {
            current = this.sparseBitSetVolatile;
            cardinality = current.cardinality();
        } while (current != this.sparseBitSetVolatile);
        return cardinality;
    }

    public void listenForDeltaUpdates() {
        this.readStateEngine.getTypeState(this.type).addListener(this);
    }

    public void detachFromDeltaUpdates() {
        this.readStateEngine.getTypeState(this.type).removeListener(this);
    }

    @Override
    public void beginUpdate() {
        this.valuesToSet.clear();
        this.valuesToClear.clear();
        this.maxValueToSet = -1;
    }

    @Override
    public void addedOrdinal(int ordinal) {
        if (this.predicate.shouldIndex(ordinal)) {
            Object[] values;
            for (Object value : values = this.fieldPath.findValues(ordinal)) {
                this.valuesToSet.add((int)((Integer)value));
                if (this.maxValueToSet >= (Integer)value) continue;
                this.maxValueToSet = (Integer)value;
            }
        }
    }

    @Override
    public void removedOrdinal(int ordinal) {
        Object[] values;
        for (Object value : values = this.fieldPath.findValues(ordinal)) {
            this.valuesToClear.add((int)((Integer)value));
        }
    }

    @Override
    public void endUpdate() {
        boolean didSomeWork = false;
        SparseBitSet updated = this.sparseBitSetVolatile;
        if (this.valuesToSet.size() > 0 && this.maxValueToSet > updated.findMaxValue()) {
            updated = SparseBitSet.resize(updated, this.maxValueToSet);
            didSomeWork = true;
        }
        for (int value : this.valuesToSet) {
            updated.set(value);
        }
        for (int value : this.valuesToClear) {
            updated.clear(value);
        }
        if (didSomeWork) {
            this.sparseBitSetVolatile = updated;
        }
    }

    static class SparseBitSet {
        private static final int BUCKET_SHIFT = 12;
        private static final int LONG_SHIFT = 6;
        private final int maxValue;
        private final AtomicReferenceArray<Bucket> buckets;

        SparseBitSet(int maxValue) {
            int totalBuckets = maxValue >>> 12;
            this.maxValue = maxValue;
            this.buckets = new AtomicReferenceArray(totalBuckets + 1);
        }

        private SparseBitSet(int maxValue, AtomicReferenceArray<Bucket> buckets) {
            this.maxValue = maxValue;
            this.buckets = buckets;
        }

        private static int getIndex(int i) {
            return i >>> 12;
        }

        private static int getOffset(long longAtIndex, long bitInIndex) {
            long setAllOnesBeforeBitInIndex = bitInIndex - 1L;
            long offset = longAtIndex & setAllOnesBeforeBitInIndex;
            return Long.bitCount(offset);
        }

        boolean get(int i) {
            long whichBitInLong;
            if (i > this.maxValue || i < 0) {
                return false;
            }
            int index = SparseBitSet.getIndex(i);
            Bucket currentBucket = this.buckets.get(index);
            if (currentBucket == null) {
                return false;
            }
            long currentLongAtIndex = currentBucket.idx;
            long[] longs = currentBucket.longs;
            long whichLong = i >>> 6;
            long bitInIndex = 1L << (int)whichLong;
            long isLongInitialized = currentLongAtIndex & bitInIndex;
            if (isLongInitialized == 0L) {
                return false;
            }
            int offset = SparseBitSet.getOffset(currentLongAtIndex, bitInIndex);
            long value = longs[offset];
            return (value & (whichBitInLong = 1L << i)) != 0L;
        }

        void set(int i) {
            long[] longs;
            long longAtIndex;
            Bucket newBucket;
            Bucket currentBucket;
            if (i > this.maxValue) {
                throw new IllegalArgumentException("Max value initialized is " + this.maxValue + " given value is " + i);
            }
            if (i < 0) {
                throw new IllegalArgumentException("Cannot index negative numbers");
            }
            int index = SparseBitSet.getIndex(i);
            long whichLong = i >>> 6;
            long bitInIndex = 1L << (int)whichLong;
            long whichBitInLong = 1L << i;
            do {
                int it;
                boolean isLongInitialized;
                longAtIndex = 0L;
                longs = null;
                currentBucket = this.buckets.get(index);
                if (currentBucket != null) {
                    longAtIndex = currentBucket.idx;
                    longs = (long[])currentBucket.longs.clone();
                }
                boolean bl = isLongInitialized = (longAtIndex & bitInIndex) != 0L;
                if (isLongInitialized) {
                    int offset;
                    int n = offset = SparseBitSet.getOffset(longAtIndex, bitInIndex);
                    longs[n] = longs[n] | whichBitInLong;
                    continue;
                }
                if (longAtIndex == 0L) {
                    longAtIndex = bitInIndex;
                    longs = new long[]{whichBitInLong};
                    continue;
                }
                int offset = SparseBitSet.getOffset(longAtIndex |= bitInIndex, bitInIndex);
                int oldLongsLen = longs.length;
                long[] newLongs = new long[oldLongsLen + 1];
                if (offset >= oldLongsLen) {
                    for (it = 0; it < oldLongsLen; ++it) {
                        newLongs[it] = longs[it];
                    }
                    newLongs[it] = whichBitInLong;
                } else {
                    for (it = 0; it < offset; ++it) {
                        newLongs[it] = longs[it];
                    }
                    newLongs[offset] = whichBitInLong;
                    for (it = offset; it < oldLongsLen; ++it) {
                        newLongs[it + 1] = longs[it];
                    }
                }
                longs = newLongs;
            } while (!this.buckets.compareAndSet(index, currentBucket, newBucket = new Bucket(longAtIndex, longs)));
        }

        void clear(int i) {
            Bucket updatedBucket;
            Bucket currentBucket;
            if (i > this.maxValue || i < 0) {
                return;
            }
            int index = SparseBitSet.getIndex(i);
            do {
                if ((currentBucket = this.buckets.get(index)) == null) {
                    return;
                }
                long longAtIndex = currentBucket.idx;
                long[] longs = (long[])currentBucket.longs.clone();
                long whichLong = i >>> 6;
                long bitInIndex = 1L << (int)whichLong;
                long whichBitInLong = 1L << i;
                long isLongInitialized = longAtIndex & bitInIndex;
                if (isLongInitialized == 0L) {
                    return;
                }
                int offset = SparseBitSet.getOffset(longAtIndex, bitInIndex);
                long value = longs[offset];
                long updatedValue = value & (whichBitInLong ^ 0xFFFFFFFFFFFFFFFFL);
                boolean isBucketEmpty = false;
                if (updatedValue != 0L) {
                    longs[offset] = updatedValue;
                } else {
                    int oldLongsLen = longs.length;
                    if (oldLongsLen == 1) {
                        longs = null;
                        longAtIndex = 0L;
                        isBucketEmpty = true;
                    } else {
                        int it;
                        long[] newLongs = new long[oldLongsLen - 1];
                        for (it = 0; it < offset; ++it) {
                            newLongs[it] = longs[it];
                        }
                        ++it;
                        while (it < oldLongsLen) {
                            newLongs[it - 1] = longs[it];
                            ++it;
                        }
                        longs = newLongs;
                        longAtIndex &= bitInIndex ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                }
                updatedBucket = null;
                if (isBucketEmpty) continue;
                updatedBucket = new Bucket(longAtIndex, longs);
            } while (!this.buckets.compareAndSet(index, currentBucket, updatedBucket));
        }

        int findMaxValue() {
            int index;
            for (index = this.buckets.length() - 1; index >= 0 && this.buckets.get(index) == null; --index) {
            }
            if (index < 0) {
                return -1;
            }
            int highestBitSetInIndexAtLong = 63 - Long.numberOfLeadingZeros(Long.highestOneBit(this.buckets.get(index).idx));
            long[] longs = this.buckets.get(index).longs;
            long value = longs[longs.length - 1];
            long highestBitSetInLong = 63 - Long.numberOfLeadingZeros(Long.highestOneBit(value));
            return (int)((long)((index << 12) + (highestBitSetInIndexAtLong << 6)) + highestBitSetInLong);
        }

        int cardinality() {
            int cardinality = 0;
            for (int index = 0; index < this.buckets.length(); ++index) {
                long[] longs;
                if (this.buckets.get(index) == null) continue;
                for (long value : longs = this.buckets.get(index).longs) {
                    cardinality += Long.bitCount(value);
                }
            }
            return cardinality;
        }

        long estimateBitsUsed() {
            long longsUsed = 0L;
            long idxCounts = 0L;
            for (int index = 0; index < this.buckets.length(); ++index) {
                if (this.buckets.get(index) == null) continue;
                ++idxCounts;
                longsUsed += (long)this.buckets.get(index).longs.length;
            }
            long bitsUsedByArrayPointers = this.buckets.length() * 64;
            long bitsUsedByIdx = idxCounts * 64L;
            long bitsUsedByLongs = longsUsed * 64L;
            return bitsUsedByArrayPointers + bitsUsedByIdx + bitsUsedByLongs;
        }

        static SparseBitSet compact(SparseBitSet sparseBitSet) {
            int maxValueAdded = sparseBitSet.findMaxValue();
            if (maxValueAdded < 0) {
                maxValueAdded = 4095;
            }
            int indexForMaxValueAdded = SparseBitSet.getIndex(maxValueAdded);
            int newLength = indexForMaxValueAdded + 1;
            return SparseBitSet.copyWithNewLength(sparseBitSet, newLength, newLength, maxValueAdded);
        }

        static SparseBitSet resize(SparseBitSet sparseBitSet, int newMaxValue) {
            if (sparseBitSet.findMaxValue() < newMaxValue) {
                int indexForNewMaxValue = SparseBitSet.getIndex(newMaxValue);
                int newLength = indexForNewMaxValue + 1;
                return SparseBitSet.copyWithNewLength(sparseBitSet, newLength, sparseBitSet.buckets.length(), newMaxValue);
            }
            return sparseBitSet;
        }

        private static SparseBitSet copyWithNewLength(SparseBitSet sparseBitSet, int newLength, int lengthToClone, int newMaxValue) {
            AtomicReferenceArray<Bucket> compactBuckets = new AtomicReferenceArray<Bucket>(newLength);
            for (int i = 0; i < lengthToClone; ++i) {
                if (sparseBitSet.buckets.get(i) == null) continue;
                compactBuckets.set(i, sparseBitSet.buckets.get(i));
            }
            return new SparseBitSet(newMaxValue, compactBuckets);
        }

        private static class Bucket {
            private long idx;
            private long[] longs;

            private Bucket(long idx, long[] longs) {
                this.idx = idx;
                this.longs = longs;
            }
        }
    }

    public static interface IndexPredicate {
        public boolean shouldIndex(int var1);
    }
}

