/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.index;

import com.netflix.hollow.core.index.key.HollowPrimaryKeyValueDeriver;
import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.memory.encoding.FixedLengthElementArray;
import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import com.netflix.hollow.core.memory.pool.WastefulRecycler;
import com.netflix.hollow.core.read.HollowReadFieldUtils;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeStateListener;
import com.netflix.hollow.core.read.engine.PopulatedOrdinalListener;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HollowPrimaryKeyIndex
implements HollowTypeStateListener {
    private static final Logger LOG = Logger.getLogger(HollowPrimaryKeyIndex.class.getName());
    private final HollowObjectTypeReadState typeState;
    private final int[][] fieldPathIndexes;
    private final HollowObjectSchema.FieldType[] fieldTypes;
    private final PrimaryKey primaryKey;
    private final HollowPrimaryKeyValueDeriver keyDeriver;
    private final ArraySegmentRecycler memoryRecycler;
    private final BitSet specificOrdinalsToIndex;
    private volatile PrimaryKeyIndexHashTable hashTableVolatile;
    private static final boolean ALLOW_DELTA_UPDATE = Boolean.getBoolean("com.netflix.hollow.core.index.HollowPrimaryKeyIndex.allowDeltaUpdate");

    public HollowPrimaryKeyIndex(HollowReadStateEngine stateEngine, String type, String ... fieldPaths) {
        this(stateEngine, WastefulRecycler.DEFAULT_INSTANCE, type, fieldPaths);
    }

    public HollowPrimaryKeyIndex(HollowReadStateEngine stateEngine, PrimaryKey primaryKey) {
        this(stateEngine, primaryKey, WastefulRecycler.DEFAULT_INSTANCE);
    }

    public HollowPrimaryKeyIndex(HollowReadStateEngine stateEngine, ArraySegmentRecycler memoryRecycler, String type, String ... fieldPaths) {
        this(stateEngine, HollowPrimaryKeyIndex.createPrimaryKey(stateEngine, type, fieldPaths), memoryRecycler);
    }

    public HollowPrimaryKeyIndex(HollowReadStateEngine stateEngine, PrimaryKey primaryKey, ArraySegmentRecycler memoryRecycler) {
        this(stateEngine, primaryKey, memoryRecycler, null);
    }

    public HollowPrimaryKeyIndex(HollowReadStateEngine stateEngine, PrimaryKey primaryKey, ArraySegmentRecycler memoryRecycler, BitSet specificOrdinalsToIndex) {
        Objects.requireNonNull(primaryKey, "Hollow Primary Key Index creation failed because primaryKey was null");
        Objects.requireNonNull(stateEngine, "Hollow Primary Key Index creation for type [" + primaryKey.getType() + "] failed because read state wasn't initialized");
        this.primaryKey = primaryKey;
        this.typeState = (HollowObjectTypeReadState)stateEngine.getTypeState(primaryKey.getType());
        this.fieldPathIndexes = new int[primaryKey.numFields()][];
        this.fieldTypes = new HollowObjectSchema.FieldType[primaryKey.numFields()];
        this.memoryRecycler = memoryRecycler;
        for (int i = 0; i < primaryKey.numFields(); ++i) {
            this.fieldPathIndexes[i] = primaryKey.getFieldPathIndex(stateEngine, i);
            this.fieldTypes[i] = primaryKey.getFieldType(stateEngine, i);
        }
        this.keyDeriver = new HollowPrimaryKeyValueDeriver(this.typeState, this.fieldPathIndexes, this.fieldTypes);
        this.specificOrdinalsToIndex = specificOrdinalsToIndex;
        this.reindex();
    }

    private static PrimaryKey createPrimaryKey(HollowReadStateEngine stateEngine, String type, String ... fieldPaths) {
        if (fieldPaths != null && fieldPaths.length != 0) {
            return new PrimaryKey(type, fieldPaths);
        }
        HollowSchema schema = stateEngine.getSchema(type);
        if (schema instanceof HollowObjectSchema) {
            return ((HollowObjectSchema)schema).getPrimaryKey();
        }
        return null;
    }

    public void listenForDeltaUpdates() {
        if (this.specificOrdinalsToIndex != null) {
            throw new IllegalStateException("Cannot listen for delta updates when indexing only specified ordinals!");
        }
        this.typeState.addListener(this);
    }

    public void detachFromDeltaUpdates() {
        this.typeState.removeListener(this);
    }

    public HollowObjectTypeReadState getTypeState() {
        return this.typeState;
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public List<HollowObjectSchema.FieldType> getFieldTypes() {
        return Arrays.asList(this.fieldTypes);
    }

    public int getMatchingOrdinal(Object key) {
        PrimaryKeyIndexHashTable hashTable = this.hashTableVolatile;
        if (this.fieldPathIndexes.length != 1 || hashTable.bitsPerElement == 0) {
            return -1;
        }
        int hashCode = this.keyHashCode(key, 0);
        int ordinal = -1;
        do {
            hashTable = this.hashTableVolatile;
            int bucket = hashCode & hashTable.hashMask;
            ordinal = this.readOrdinal(hashTable, bucket);
            while (ordinal != -1 && !this.keyDeriver.keyMatches(key, ordinal, 0)) {
                ++bucket;
                ordinal = this.readOrdinal(hashTable, bucket &= hashTable.hashMask);
            }
        } while (this.hashTableVolatile != hashTable);
        return ordinal;
    }

    public int getMatchingOrdinal(Object key1, Object key2) {
        PrimaryKeyIndexHashTable hashTable = this.hashTableVolatile;
        if (this.fieldPathIndexes.length != 2 || hashTable.bitsPerElement == 0) {
            return -1;
        }
        int hashCode = this.keyHashCode(key1, 0);
        hashCode ^= this.keyHashCode(key2, 1);
        int ordinal = -1;
        do {
            hashTable = this.hashTableVolatile;
            int bucket = hashCode & hashTable.hashMask;
            ordinal = this.readOrdinal(hashTable, bucket);
            while (!(ordinal == -1 || this.keyDeriver.keyMatches(key1, ordinal, 0) && this.keyDeriver.keyMatches(key2, ordinal, 1))) {
                ++bucket;
                ordinal = this.readOrdinal(hashTable, bucket &= hashTable.hashMask);
            }
        } while (this.hashTableVolatile != hashTable);
        return ordinal;
    }

    public int getMatchingOrdinal(Object key1, Object key2, Object key3) {
        PrimaryKeyIndexHashTable hashTable = this.hashTableVolatile;
        if (this.fieldPathIndexes.length != 3 || hashTable.bitsPerElement == 0) {
            return -1;
        }
        int hashCode = this.keyHashCode(key1, 0);
        hashCode ^= this.keyHashCode(key2, 1);
        hashCode ^= this.keyHashCode(key3, 2);
        int ordinal = -1;
        do {
            hashTable = this.hashTableVolatile;
            int bucket = hashCode & hashTable.hashMask;
            ordinal = this.readOrdinal(hashTable, bucket);
            while (!(ordinal == -1 || this.keyDeriver.keyMatches(key1, ordinal, 0) && this.keyDeriver.keyMatches(key2, ordinal, 1) && this.keyDeriver.keyMatches(key3, ordinal, 2))) {
                ++bucket;
                ordinal = this.readOrdinal(hashTable, bucket &= hashTable.hashMask);
            }
        } while (this.hashTableVolatile != hashTable);
        return ordinal;
    }

    public int getMatchingOrdinal(Object ... keys) {
        PrimaryKeyIndexHashTable hashTable = this.hashTableVolatile;
        if (this.fieldPathIndexes.length != keys.length || hashTable.bitsPerElement == 0) {
            return -1;
        }
        int hashCode = 0;
        for (int i = 0; i < keys.length; ++i) {
            hashCode ^= this.keyHashCode(keys[i], i);
        }
        int ordinal = -1;
        do {
            hashTable = this.hashTableVolatile;
            int bucket = hashCode & hashTable.hashMask;
            ordinal = this.readOrdinal(hashTable, bucket);
            while (ordinal != -1 && !this.keyDeriver.keyMatches(ordinal, keys)) {
                ++bucket;
                ordinal = this.readOrdinal(hashTable, bucket &= hashTable.hashMask);
            }
        } while (this.hashTableVolatile != hashTable);
        return ordinal;
    }

    private int readOrdinal(PrimaryKeyIndexHashTable hashTable, int bucket) {
        return (int)hashTable.hashTable.getElementValue((long)hashTable.bitsPerElement * (long)bucket, hashTable.bitsPerElement) - 1;
    }

    private int keyHashCode(Object key, int fieldIdx) {
        switch (this.fieldTypes[fieldIdx]) {
            case BOOLEAN: {
                return HashCodes.hashInt(HollowReadFieldUtils.booleanHashCode((Boolean)key));
            }
            case DOUBLE: {
                return HashCodes.hashInt(HollowReadFieldUtils.doubleHashCode((Double)key));
            }
            case FLOAT: {
                return HashCodes.hashInt(HollowReadFieldUtils.floatHashCode(((Float)key).floatValue()));
            }
            case INT: {
                return HashCodes.hashInt(HollowReadFieldUtils.intHashCode((Integer)key));
            }
            case LONG: {
                return HashCodes.hashInt(HollowReadFieldUtils.longHashCode((Long)key));
            }
            case REFERENCE: {
                return HashCodes.hashInt((Integer)key);
            }
            case BYTES: {
                return HashCodes.hashCode((byte[])key);
            }
            case STRING: {
                return HashCodes.hashCode((String)key);
            }
        }
        throw new IllegalArgumentException("I don't know how to hash a " + (Object)((Object)this.fieldTypes[fieldIdx]));
    }

    private void setHashTable(PrimaryKeyIndexHashTable hashTable) {
        this.hashTableVolatile = hashTable;
    }

    public boolean containsDuplicates() {
        return !this.getDuplicateKeys().isEmpty();
    }

    public synchronized Collection<Object[]> getDuplicateKeys() {
        PrimaryKeyIndexHashTable hashTable = this.hashTableVolatile;
        if (hashTable.bitsPerElement == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object[]> duplicateKeys = new ArrayList<Object[]>();
        for (int i = 0; i < hashTable.hashTableSize; ++i) {
            int ordinal = (int)hashTable.hashTable.getElementValue((long)i * (long)hashTable.bitsPerElement, hashTable.bitsPerElement) - 1;
            if (ordinal == -1) continue;
            int compareBucket = i + 1 & hashTable.hashMask;
            int compareOrdinal = (int)hashTable.hashTable.getElementValue((long)compareBucket * (long)hashTable.bitsPerElement, hashTable.bitsPerElement) - 1;
            while (compareOrdinal != -1) {
                if (this.recordsHaveEqualKeys(ordinal, compareOrdinal)) {
                    duplicateKeys.add(this.keyDeriver.getRecordKey(ordinal));
                }
                compareBucket = compareBucket + 1 & hashTable.hashMask;
                compareOrdinal = (int)hashTable.hashTable.getElementValue((long)compareBucket * (long)hashTable.bitsPerElement, hashTable.bitsPerElement) - 1;
            }
        }
        return duplicateKeys;
    }

    @Override
    public void beginUpdate() {
    }

    @Override
    public void addedOrdinal(int ordinal) {
    }

    @Override
    public void removedOrdinal(int ordinal) {
    }

    @Override
    public synchronized void endUpdate() {
        BitSet ordinals = this.typeState.getListener(PopulatedOrdinalListener.class).getPopulatedOrdinals();
        int hashTableSize = HashCodes.hashTableSize(ordinals.cardinality());
        int bitsPerElement = 32 - Integer.numberOfLeadingZeros(this.typeState.maxOrdinal() + 1);
        PrimaryKeyIndexHashTable hashTable = this.hashTableVolatile;
        if (ALLOW_DELTA_UPDATE && hashTableSize == hashTable.hashTableSize && bitsPerElement == hashTable.bitsPerElement && this.shouldPerformDeltaUpdate()) {
            try {
                this.deltaUpdate(hashTableSize, bitsPerElement);
            }
            catch (OrdinalNotFoundException e) {
                LOG.log(Level.SEVERE, "Delta update of index failed.  Performing a full reindex", e);
                this.reindex();
            }
        } else {
            this.reindex();
        }
    }

    public void destroy() {
        PrimaryKeyIndexHashTable hashTable = this.hashTableVolatile;
        if (hashTable != null) {
            hashTable.hashTable.destroy(this.memoryRecycler);
        }
    }

    private synchronized void reindex() {
        BitSet ordinals;
        PrimaryKeyIndexHashTable hashTable = this.hashTableVolatile;
        if (hashTable != null) {
            hashTable.hashTable.destroy(this.memoryRecycler);
        }
        if ((ordinals = this.specificOrdinalsToIndex) == null) {
            PopulatedOrdinalListener listener = this.typeState.getListener(PopulatedOrdinalListener.class);
            ordinals = listener.getPopulatedOrdinals();
        }
        int hashTableSize = HashCodes.hashTableSize(ordinals.cardinality());
        int bitsPerElement = 32 - Integer.numberOfLeadingZeros(this.typeState.maxOrdinal() + 1);
        FixedLengthElementArray hashedArray = new FixedLengthElementArray(this.memoryRecycler, (long)hashTableSize * (long)bitsPerElement);
        int hashMask = hashTableSize - 1;
        int ordinal = ordinals.nextSetBit(0);
        while (ordinal != -1) {
            int hashCode = this.recordHash(ordinal);
            int bucket = hashCode & hashMask;
            while (hashedArray.getElementValue((long)bucket * (long)bitsPerElement, bitsPerElement) != 0L) {
                bucket = bucket + 1 & hashMask;
            }
            hashedArray.setElementValue((long)bucket * (long)bitsPerElement, bitsPerElement, ordinal + 1);
            ordinal = ordinals.nextSetBit(ordinal + 1);
        }
        this.setHashTable(new PrimaryKeyIndexHashTable(hashedArray, hashTableSize, hashMask, bitsPerElement));
        this.memoryRecycler.swap();
    }

    private void deltaUpdate(int hashTableSize, int bitsPerElement) {
        PrimaryKeyIndexHashTable hashTable = this.hashTableVolatile;
        hashTable.hashTable.destroy(this.memoryRecycler);
        PopulatedOrdinalListener listener = this.typeState.getListener(PopulatedOrdinalListener.class);
        BitSet prevOrdinals = listener.getPreviousOrdinals();
        BitSet ordinals = listener.getPopulatedOrdinals();
        long totalBitsInHashTable = (long)hashTableSize * (long)bitsPerElement;
        FixedLengthElementArray hashedArray = new FixedLengthElementArray(this.memoryRecycler, totalBitsInHashTable);
        hashedArray.copyBits(hashTable.hashTable, 0L, 0L, totalBitsInHashTable);
        int hashMask = hashTableSize - 1;
        int prevOrdinal = prevOrdinals.nextSetBit(0);
        while (prevOrdinal != -1) {
            if (!ordinals.get(prevOrdinal)) {
                int hashCode = this.recordHash(prevOrdinal);
                int bucket = this.findOrdinalBucket(bitsPerElement, hashedArray, hashCode, hashMask, prevOrdinal);
                hashedArray.clearElementValue((long)bucket * (long)bitsPerElement, bitsPerElement);
                int emptyBucket = bucket;
                bucket = bucket + 1 & hashMask;
                int moveOrdinal = (int)hashedArray.getElementValue((long)bucket * (long)bitsPerElement, bitsPerElement) - 1;
                while (moveOrdinal != -1) {
                    int naturalHash = this.recordHash(moveOrdinal);
                    int naturalBucket = naturalHash & hashMask;
                    if (!this.bucketInRange(emptyBucket, bucket, naturalBucket)) {
                        hashedArray.setElementValue((long)emptyBucket * (long)bitsPerElement, bitsPerElement, moveOrdinal + 1);
                        hashedArray.clearElementValue((long)bucket * (long)bitsPerElement, bitsPerElement);
                        emptyBucket = bucket;
                    }
                    bucket = bucket + 1 & hashMask;
                    moveOrdinal = (int)hashedArray.getElementValue((long)bucket * (long)bitsPerElement, bitsPerElement) - 1;
                }
            }
            prevOrdinal = prevOrdinals.nextSetBit(prevOrdinal + 1);
        }
        int ordinal = ordinals.nextSetBit(0);
        while (ordinal != -1) {
            if (!prevOrdinals.get(ordinal)) {
                int hashCode = this.recordHash(ordinal);
                int bucket = hashCode & hashMask;
                while (hashedArray.getElementValue((long)bucket * (long)bitsPerElement, bitsPerElement) != 0L) {
                    bucket = bucket + 1 & hashMask;
                }
                hashedArray.setElementValue((long)bucket * (long)bitsPerElement, bitsPerElement, ordinal + 1);
            }
            ordinal = ordinals.nextSetBit(ordinal + 1);
        }
        this.setHashTable(new PrimaryKeyIndexHashTable(hashedArray, hashTableSize, hashMask, bitsPerElement));
        this.memoryRecycler.swap();
    }

    private int findOrdinalBucket(int bitsPerElement, FixedLengthElementArray hashedArray, int hashCode, int hashMask, int prevOrdinal) {
        long value;
        int startBucket;
        int bucket = startBucket = hashCode & hashMask;
        do {
            if ((long)(prevOrdinal + 1) == (value = hashedArray.getElementValue((long)bucket * (long)bitsPerElement, bitsPerElement))) {
                return bucket;
            }
            bucket = bucket + 1 & hashMask;
        } while (value != 0L && bucket != startBucket);
        if (value == 0L) {
            throw new OrdinalNotFoundException(String.format("Ordinal not found (found empty entry): ordinal=%d startBucket=%d", prevOrdinal, startBucket));
        }
        throw new OrdinalNotFoundException(String.format("Ordinal not found (wrapped around table): ordinal=%d startBucket=%d", prevOrdinal, startBucket));
    }

    private boolean bucketInRange(int fromBucket, int toBucket, int testBucket) {
        if (toBucket > fromBucket) {
            return testBucket > fromBucket && testBucket <= toBucket;
        }
        return testBucket > fromBucket || testBucket <= toBucket;
    }

    private int recordHash(int ordinal) {
        int hashCode = 0;
        for (int i = 0; i < this.fieldPathIndexes.length; ++i) {
            hashCode ^= this.fieldHash(ordinal, i);
        }
        return hashCode;
    }

    private int fieldHash(int ordinal, int fieldIdx) {
        HollowObjectTypeReadState typeState = this.typeState;
        HollowObjectSchema schema = typeState.getSchema();
        int lastFieldPath = this.fieldPathIndexes[fieldIdx].length - 1;
        for (int i = 0; i < lastFieldPath; ++i) {
            int fieldPosition = this.fieldPathIndexes[fieldIdx][i];
            ordinal = typeState.readOrdinal(ordinal, fieldPosition);
            typeState = (HollowObjectTypeReadState)schema.getReferencedTypeState(fieldPosition);
            schema = typeState.getSchema();
        }
        int hashCode = HollowReadFieldUtils.fieldHashCode(typeState, ordinal, this.fieldPathIndexes[fieldIdx][lastFieldPath]);
        switch (this.fieldTypes[fieldIdx]) {
            case BYTES: 
            case STRING: {
                return hashCode;
            }
        }
        return HashCodes.hashInt(hashCode);
    }

    public Object[] getRecordKey(int ordinal) {
        return this.keyDeriver.getRecordKey(ordinal);
    }

    private boolean recordsHaveEqualKeys(int ordinal1, int ordinal2) {
        for (int i = 0; i < this.fieldPathIndexes.length; ++i) {
            if (this.fieldsAreEqual(ordinal1, ordinal2, i)) continue;
            return false;
        }
        return true;
    }

    private boolean fieldsAreEqual(int ordinal1, int ordinal2, int fieldIdx) {
        HollowObjectTypeReadState typeState = this.typeState;
        HollowObjectSchema schema = typeState.getSchema();
        int lastFieldPath = this.fieldPathIndexes[fieldIdx].length - 1;
        for (int i = 0; i < lastFieldPath; ++i) {
            int fieldPosition = this.fieldPathIndexes[fieldIdx][i];
            ordinal1 = typeState.readOrdinal(ordinal1, fieldPosition);
            ordinal2 = typeState.readOrdinal(ordinal2, fieldPosition);
            typeState = (HollowObjectTypeReadState)schema.getReferencedTypeState(fieldPosition);
            schema = typeState.getSchema();
        }
        if (this.fieldTypes[fieldIdx] == HollowObjectSchema.FieldType.REFERENCE) {
            return typeState.readOrdinal(ordinal1, this.fieldPathIndexes[fieldIdx][lastFieldPath]) == typeState.readOrdinal(ordinal2, this.fieldPathIndexes[fieldIdx][lastFieldPath]);
        }
        return HollowReadFieldUtils.fieldsAreEqual(typeState, ordinal1, this.fieldPathIndexes[fieldIdx][lastFieldPath], typeState, ordinal2, this.fieldPathIndexes[fieldIdx][lastFieldPath]);
    }

    private boolean shouldPerformDeltaUpdate() {
        BitSet previousOrdinals = this.typeState.getListener(PopulatedOrdinalListener.class).getPreviousOrdinals();
        BitSet ordinals = this.typeState.getListener(PopulatedOrdinalListener.class).getPopulatedOrdinals();
        int prevCardinality = 0;
        int removedRecords = 0;
        int prevOrdinal = previousOrdinals.nextSetBit(0);
        while (prevOrdinal != -1) {
            ++prevCardinality;
            if (!ordinals.get(prevOrdinal)) {
                ++removedRecords;
            }
            prevOrdinal = previousOrdinals.nextSetBit(prevOrdinal + 1);
        }
        return !((double)removedRecords > (double)prevCardinality * 0.1);
    }

    private static class PrimaryKeyIndexHashTable {
        private final FixedLengthElementArray hashTable;
        private final int hashTableSize;
        private final int hashMask;
        private final int bitsPerElement;

        public PrimaryKeyIndexHashTable(FixedLengthElementArray hashTable, int hashTableSize, int hashMask, int bitsPerElement) {
            this.hashTable = hashTable;
            this.hashTableSize = hashTableSize;
            this.hashMask = hashMask;
            this.bitsPerElement = bitsPerElement;
        }
    }

    private static class OrdinalNotFoundException
    extends IllegalStateException {
        OrdinalNotFoundException(String s) {
            super(s);
        }
    }
}

