/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.index;

import com.netflix.hollow.core.index.FieldPaths;
import com.netflix.hollow.core.index.HollowHashIndexField;
import com.netflix.hollow.core.index.traversal.HollowIndexerValueTraverser;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.schema.HollowCollectionSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class HollowPreindexer {
    private final HollowReadStateEngine stateEngine;
    private final String type;
    private final String selectField;
    private final String[] matchFields;
    private HollowTypeReadState typeState;
    private HollowHashIndexField[] matchFieldSpecs;
    private int numMatchTraverserFields;
    private HollowHashIndexField selectFieldSpec;
    private HollowIndexerValueTraverser traverser;

    public HollowPreindexer(HollowReadStateEngine stateEngine, String type, String selectField, String ... matchFields) {
        this.stateEngine = stateEngine;
        this.type = type;
        this.selectField = selectField;
        this.matchFields = matchFields;
    }

    public void buildFieldSpecifications() {
        HashMap<String, Integer> baseFieldToIndexMap = new HashMap<String, Integer>();
        this.typeState = this.stateEngine.getTypeState(this.type);
        this.matchFieldSpecs = new HollowHashIndexField[this.matchFields.length];
        for (int i = 0; i < this.matchFields.length; ++i) {
            this.matchFieldSpecs[i] = this.getHollowHashIndexField(this.typeState, this.matchFields[i], baseFieldToIndexMap, true);
        }
        this.numMatchTraverserFields = baseFieldToIndexMap.size();
        this.selectFieldSpec = this.getHollowHashIndexField(this.typeState, this.selectField, baseFieldToIndexMap, false);
        String[] baseFields = new String[baseFieldToIndexMap.size()];
        for (Map.Entry entry : baseFieldToIndexMap.entrySet()) {
            baseFields[((Integer)entry.getValue()).intValue()] = (String)entry.getKey();
        }
        this.traverser = new HollowIndexerValueTraverser(this.stateEngine, this.type, baseFields);
    }

    private HollowHashIndexField getHollowHashIndexField(HollowTypeReadState originalTypeState, String selectField, Map<String, Integer> baseFieldToIndexMap, boolean truncate) {
        FieldPaths.FieldPath<FieldPaths.FieldSegment> path = FieldPaths.createFieldPathForHashIndex(this.stateEngine, this.type, selectField);
        HollowTypeReadState baseTypeState = originalTypeState;
        int baseFieldPathIdx = 0;
        List<FieldPaths.FieldSegment> segments = path.getSegments();
        int[] fieldPathIndexes = new int[segments.size()];
        HollowObjectSchema.FieldType fieldType = HollowObjectSchema.FieldType.REFERENCE;
        block5: for (int i = 0; i < segments.size(); ++i) {
            FieldPaths.FieldSegment segment = segments.get(i);
            HollowSchema schema = segment.enclosingSchema;
            switch (schema.getSchemaType()) {
                case OBJECT: {
                    FieldPaths.ObjectFieldSegment objectSegment = (FieldPaths.ObjectFieldSegment)segment;
                    fieldType = objectSegment.getType();
                    fieldPathIndexes[i] = objectSegment.getIndex();
                    if (truncate) continue block5;
                    baseFieldPathIdx = i + 1;
                    continue block5;
                }
                case SET: 
                case LIST: {
                    fieldType = HollowObjectSchema.FieldType.REFERENCE;
                    HollowCollectionSchema collectionSchema = (HollowCollectionSchema)schema;
                    baseTypeState = collectionSchema.getElementTypeState();
                    baseFieldPathIdx = i + 1;
                    continue block5;
                }
                case MAP: {
                    fieldType = HollowObjectSchema.FieldType.REFERENCE;
                    HollowMapSchema mapSchema = (HollowMapSchema)schema;
                    boolean isKey = "key".equals(segment.getName());
                    baseTypeState = isKey ? mapSchema.getKeyTypeState() : mapSchema.getValueTypeState();
                    baseFieldPathIdx = i + 1;
                }
            }
        }
        String basePath = segments.stream().limit(baseFieldPathIdx).map(FieldPaths.FieldSegment::getName).collect(Collectors.joining("."));
        int basePathIdx = baseFieldToIndexMap.computeIfAbsent(basePath, k -> baseFieldToIndexMap.size());
        return new HollowHashIndexField(basePathIdx, Arrays.copyOfRange(fieldPathIndexes, baseFieldPathIdx, fieldPathIndexes.length), baseTypeState, fieldType);
    }

    public HollowTypeReadState getTypeState() {
        return this.typeState;
    }

    public HollowHashIndexField[] getMatchFieldSpecs() {
        return this.matchFieldSpecs;
    }

    public int getNumMatchTraverserFields() {
        return this.numMatchTraverserFields;
    }

    public HollowHashIndexField getSelectFieldSpec() {
        return this.selectFieldSpec;
    }

    public HollowIndexerValueTraverser getTraverser() {
        return this.traverser;
    }
}

