/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.index;

import com.netflix.hollow.core.index.FieldPath;
import com.netflix.hollow.core.memory.encoding.FixedLengthElementArray;
import com.netflix.hollow.core.memory.encoding.FixedLengthMultipleOccurrenceElementArray;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import com.netflix.hollow.core.memory.pool.WastefulRecycler;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeStateListener;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class HollowPrefixIndex
implements HollowTypeStateListener {
    private final FieldPath fieldPath;
    private final HollowReadStateEngine readStateEngine;
    private final String type;
    private final int estimatedMaxStringDuplicates;
    private volatile TST prefixIndexVolatile;
    private ArraySegmentRecycler memoryRecycle;
    private int totalWords;
    private int averageWordLen;
    private int maxOrdinalOfType;
    private boolean buildIndexOnUpdate;

    public HollowPrefixIndex(HollowReadStateEngine readStateEngine, String type, String fieldPath) {
        this(readStateEngine, type, fieldPath, 4);
    }

    public HollowPrefixIndex(HollowReadStateEngine readStateEngine, String type, String fieldPath, int estimatedMaxStringDuplicates) {
        Objects.requireNonNull(type, "Hollow Prefix Key Index creation failed because type was null");
        Objects.requireNonNull(readStateEngine, "Hollow Prefix Key Index creation for type [" + type + "] failed because read state wasn't initialized");
        if (fieldPath == null || fieldPath.isEmpty()) {
            throw new IllegalArgumentException("fieldPath cannot be null or empty");
        }
        if (estimatedMaxStringDuplicates < 1) {
            throw new IllegalArgumentException("estimatedMaxStringDuplicates cannot be < 1");
        }
        this.readStateEngine = readStateEngine;
        this.type = type;
        this.estimatedMaxStringDuplicates = estimatedMaxStringDuplicates;
        this.fieldPath = new FieldPath(readStateEngine, type, fieldPath);
        if (!this.fieldPath.getLastFieldType().equals((Object)HollowObjectSchema.FieldType.STRING)) {
            throw new IllegalArgumentException("Field path should lead to a string type");
        }
        this.memoryRecycle = WastefulRecycler.DEFAULT_INSTANCE;
        this.buildIndexOnUpdate = true;
        this.initialize();
    }

    private void initialize() {
        String lastRefType = this.fieldPath.getLastRefTypeInPath();
        this.totalWords = this.readStateEngine.getTypeState(lastRefType).getPopulatedOrdinals().cardinality();
        this.averageWordLen = 0;
        double avg = 0.0;
        HollowObjectTypeReadState objectTypeReadState = (HollowObjectTypeReadState)this.readStateEngine.getTypeState(lastRefType);
        BitSet keyBitSet = objectTypeReadState.getPopulatedOrdinals();
        int ordinal = keyBitSet.nextSetBit(0);
        while (ordinal != -1) {
            avg += (double)objectTypeReadState.readString(ordinal, 0).length() / (double)objectTypeReadState.maxOrdinal();
            ordinal = keyBitSet.nextSetBit(ordinal + 1);
        }
        this.averageWordLen = (int)Math.ceil(avg);
        HollowObjectTypeReadState valueState = (HollowObjectTypeReadState)this.readStateEngine.getTypeDataAccess(this.type);
        this.maxOrdinalOfType = valueState.maxOrdinal();
        this.build();
    }

    private void build() {
        if (!this.buildIndexOnUpdate) {
            return;
        }
        TST current = this.prefixIndexVolatile;
        if (current != null) {
            current.recycleMemory(this.memoryRecycle);
        }
        long estimatedNumberOfNodes = this.estimateNumNodes(this.totalWords, this.averageWordLen);
        TST tst = new TST(estimatedNumberOfNodes, this.estimatedMaxStringDuplicates, this.maxOrdinalOfType, this.memoryRecycle);
        BitSet ordinals = this.readStateEngine.getTypeState(this.type).getPopulatedOrdinals();
        int ordinal = ordinals.nextSetBit(0);
        while (ordinal != -1) {
            for (String key : this.getKeys(ordinal)) {
                tst.insert(key, ordinal);
            }
            ordinal = ordinals.nextSetBit(ordinal + 1);
        }
        this.prefixIndexVolatile = tst;
        this.memoryRecycle.swap();
        this.buildIndexOnUpdate = false;
    }

    protected long estimateNumNodes(long totalWords, long averageWordLen) {
        return totalWords * averageWordLen;
    }

    protected String[] getKeys(int ordinal) {
        Object[] values = this.fieldPath.findValues(ordinal);
        String[] stringValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            stringValues[i] = ((String)values[i]).toLowerCase();
        }
        return stringValues;
    }

    public HollowOrdinalIterator findKeysWithPrefix(String prefix) {
        HollowOrdinalIterator it;
        TST current;
        do {
            current = this.prefixIndexVolatile;
            it = current.findKeysWithPrefix(prefix);
        } while (current != this.prefixIndexVolatile);
        return it;
    }

    public boolean contains(String key) {
        boolean result;
        TST current;
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        do {
            current = this.prefixIndexVolatile;
            result = current.contains(key);
        } while (current != this.prefixIndexVolatile);
        return result;
    }

    public void listenForDeltaUpdates() {
        this.readStateEngine.getTypeState(this.type).addListener(this);
    }

    public void detachFromDeltaUpdates() {
        this.readStateEngine.getTypeState(this.type).removeListener(this);
    }

    @Override
    public void beginUpdate() {
    }

    @Override
    public void addedOrdinal(int ordinal) {
        this.buildIndexOnUpdate = true;
    }

    @Override
    public void removedOrdinal(int ordinal) {
        this.buildIndexOnUpdate = true;
    }

    @Override
    public void endUpdate() {
        this.initialize();
    }

    private static class TST {
        private int bitsPerNode;
        private int bitsPerKey;
        private int bitsForChildPointer;
        private int bitsPerOrdinal;
        private long leftChildOffset;
        private long middleChildOffset;
        private long rightChildOffset;
        private long isLeafNodeFlagOffset;
        private long maxNodes;
        private FixedLengthElementArray nodes;
        private FixedLengthMultipleOccurrenceElementArray ordinalSet;
        private long indexTracker;

        private TST(long estimatedNumNodes, int estimatedMaxStringDuplicates, int maxOrdinalValue, ArraySegmentRecycler memoryRecycler) {
            this.maxNodes = estimatedNumNodes;
            this.bitsPerKey = 16;
            this.bitsForChildPointer = 64 - Long.numberOfLeadingZeros(this.maxNodes);
            this.bitsPerOrdinal = maxOrdinalValue == 0 ? 1 : 32 - Integer.numberOfLeadingZeros(maxOrdinalValue);
            this.bitsPerNode = this.bitsPerKey + 3 * this.bitsForChildPointer + 1;
            this.nodes = new FixedLengthElementArray(memoryRecycler, (long)this.bitsPerNode * this.maxNodes);
            this.ordinalSet = new FixedLengthMultipleOccurrenceElementArray(memoryRecycler, this.maxNodes, this.bitsPerOrdinal, estimatedMaxStringDuplicates);
            this.indexTracker = 0L;
            this.leftChildOffset = this.bitsPerKey;
            this.middleChildOffset = this.leftChildOffset + (long)this.bitsForChildPointer;
            this.rightChildOffset = this.middleChildOffset + (long)this.bitsForChildPointer;
            this.isLeafNodeFlagOffset = this.rightChildOffset + (long)this.bitsForChildPointer;
        }

        private void recycleMemory(ArraySegmentRecycler memoryRecycler) {
            this.nodes.destroy(memoryRecycler);
            this.ordinalSet.destroy();
        }

        private long getChildOffset(NodeType nodeType) {
            long offset = nodeType.equals((Object)NodeType.Left) ? this.leftChildOffset : (nodeType.equals((Object)NodeType.Middle) ? this.middleChildOffset : this.rightChildOffset);
            return offset;
        }

        private long getChildIndex(long currentNode, NodeType nodeType) {
            long offset = this.getChildOffset(nodeType);
            return this.nodes.getElementValue(currentNode * (long)this.bitsPerNode + offset, this.bitsForChildPointer);
        }

        private void setChildIndex(long currentNode, NodeType nodeType, long indexForNode) {
            long offset = this.getChildOffset(nodeType);
            this.nodes.setElementValue(currentNode * (long)this.bitsPerNode + offset, this.bitsForChildPointer, indexForNode);
        }

        private void setKey(long index, char ch) {
            this.nodes.setElementValue(index * (long)this.bitsPerNode, this.bitsPerKey, ch);
        }

        private long getKey(long nodeIndex) {
            return this.nodes.getElementValue(nodeIndex * (long)this.bitsPerNode, this.bitsPerKey);
        }

        private boolean isLeafNode(long nodeIndex) {
            return this.nodes.getElementValue(nodeIndex * (long)this.bitsPerNode + this.isLeafNodeFlagOffset, 1) == 1L;
        }

        private void addOrdinal(long nodeIndex, long ordinal) {
            this.ordinalSet.addElement(nodeIndex, ordinal);
            this.nodes.setElementValue(nodeIndex * (long)this.bitsPerNode + this.isLeafNodeFlagOffset, 1, 1L);
        }

        private Set<Integer> getOrdinals(long nodeIndex) {
            return this.ordinalSet.getElements(nodeIndex).stream().map(Long::intValue).collect(Collectors.toSet());
        }

        private void insert(String key, int ordinal) {
            if (key == null) {
                throw new IllegalArgumentException("Null key cannot be indexed");
            }
            long currentNodeIndex = 0L;
            int keyIndex = 0;
            while (keyIndex < key.length()) {
                long keyAtCurrentNode;
                char ch = key.charAt(keyIndex);
                if (this.getKey(currentNodeIndex) == 0L) {
                    this.setKey(currentNodeIndex, ch);
                    ++this.indexTracker;
                    if (this.indexTracker >= this.maxNodes) {
                        throw new IllegalStateException("Index Tracker reached max capacity. Try with larger estimate of number of nodes");
                    }
                }
                if ((long)ch < (keyAtCurrentNode = this.getKey(currentNodeIndex))) {
                    long leftIndex = this.getChildIndex(currentNodeIndex, NodeType.Left);
                    if (leftIndex == 0L) {
                        leftIndex = this.indexTracker;
                    }
                    this.setChildIndex(currentNodeIndex, NodeType.Left, leftIndex);
                    currentNodeIndex = leftIndex;
                    continue;
                }
                if ((long)ch > keyAtCurrentNode) {
                    long rightIndex = this.getChildIndex(currentNodeIndex, NodeType.Right);
                    if (rightIndex == 0L) {
                        rightIndex = this.indexTracker;
                    }
                    this.setChildIndex(currentNodeIndex, NodeType.Right, rightIndex);
                    currentNodeIndex = rightIndex;
                    continue;
                }
                if (++keyIndex >= key.length()) continue;
                long midIndex = this.getChildIndex(currentNodeIndex, NodeType.Middle);
                if (midIndex == 0L) {
                    midIndex = this.indexTracker;
                }
                this.setChildIndex(currentNodeIndex, NodeType.Middle, midIndex);
                currentNodeIndex = midIndex;
            }
            this.addOrdinal(currentNodeIndex, ordinal);
        }

        private long findNodeWithKey(String key) {
            long index = -1L;
            boolean atRoot = true;
            long currentNodeIndex = 0L;
            int keyIndex = 0;
            while (currentNodeIndex != 0L || atRoot) {
                long currentValue = this.getKey(currentNodeIndex);
                char ch = key.charAt(keyIndex);
                if ((long)ch < currentValue) {
                    currentNodeIndex = this.getChildIndex(currentNodeIndex, NodeType.Left);
                } else if ((long)ch > currentValue) {
                    currentNodeIndex = this.getChildIndex(currentNodeIndex, NodeType.Right);
                } else {
                    if (keyIndex == key.length() - 1) {
                        index = currentNodeIndex;
                        break;
                    }
                    currentNodeIndex = this.getChildIndex(currentNodeIndex, NodeType.Middle);
                    ++keyIndex;
                }
                if (!atRoot) continue;
                atRoot = false;
            }
            return index;
        }

        private boolean contains(String key) {
            long nodeIndex = this.findNodeWithKey(key);
            return nodeIndex >= 0L && this.isLeafNode(nodeIndex);
        }

        private HollowOrdinalIterator findKeysWithPrefix(String prefix) {
            if (prefix == null) {
                throw new IllegalArgumentException("Cannot findKeysWithPrefix null prefix");
            }
            final HashSet<Integer> ordinals = new HashSet<Integer>();
            long currentNodeIndex = this.findNodeWithKey(prefix.toLowerCase());
            if (currentNodeIndex >= 0L) {
                long subTree;
                if (this.isLeafNode(currentNodeIndex)) {
                    ordinals.addAll(this.getOrdinals(currentNodeIndex));
                }
                if ((subTree = this.getChildIndex(currentNodeIndex, NodeType.Middle)) != 0L) {
                    ArrayDeque<Long> queue = new ArrayDeque<Long>();
                    queue.add(subTree);
                    while (!queue.isEmpty()) {
                        long nodeIndex = (Long)queue.remove();
                        long left = this.getChildIndex(nodeIndex, NodeType.Left);
                        long mid = this.getChildIndex(nodeIndex, NodeType.Middle);
                        long right = this.getChildIndex(nodeIndex, NodeType.Right);
                        if (left == 0L && mid == 0L && right == 0L && this.isLeafNode(nodeIndex)) {
                            ordinals.addAll(this.getOrdinals(nodeIndex));
                        }
                        if (left != 0L) {
                            queue.add(left);
                        }
                        if (mid != 0L) {
                            queue.add(mid);
                        }
                        if (right == 0L) continue;
                        queue.add(right);
                    }
                }
            }
            return new HollowOrdinalIterator(){
                private Iterator<Integer> it;
                {
                    this.it = ordinals.iterator();
                }

                @Override
                public int next() {
                    if (this.it.hasNext()) {
                        return this.it.next();
                    }
                    return Integer.MAX_VALUE;
                }
            };
        }

        private static enum NodeType {
            Left,
            Right,
            Middle;

        }
    }
}

