/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.index;

import com.netflix.hollow.core.index.GrowingSegmentedLongArray;
import com.netflix.hollow.core.index.HollowHashIndexField;
import com.netflix.hollow.core.index.HollowPreindexer;
import com.netflix.hollow.core.index.MultiLinkedElementArray;
import com.netflix.hollow.core.index.traversal.HollowIndexerValueTraverser;
import com.netflix.hollow.core.memory.FixedLengthData;
import com.netflix.hollow.core.memory.encoding.FixedLengthElementArray;
import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import com.netflix.hollow.core.memory.pool.WastefulRecycler;
import com.netflix.hollow.core.read.HollowReadFieldUtils;
import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.engine.PopulatedOrdinalListener;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;
import java.util.BitSet;

public class HollowHashIndexBuilder {
    private final HollowPreindexer preindexer;
    private final int[] bitsPerTraverserField;
    private final int[] offsetPerTraverserField;
    private final int bitsPerMatchHashKey;
    final int bitsPerSelectHashEntry;
    private final ArraySegmentRecycler memoryRecycler;
    private FixedLengthElementArray finalMatchHashTable;
    FixedLengthElementArray finalSelectHashArray;
    private long finalMatchHashMask;
    private int finalBitsPerMatchHashEntry;
    private int finalBitsPerSelectTableSize;
    private int finalBitsPerSelectTablePointer;
    private GrowingSegmentedLongArray matchIndexHashAndSizeArray;
    private FixedLengthElementArray intermediateMatchHashTable;
    private MultiLinkedElementArray intermediateSelectLists;
    private int intermediateMatchHashTableSize;
    private int bitsPerIntermediateListIdentifier;
    private int bitsPerIntermediateMatchHashEntry;
    private int intermediateMatchHashMask;
    private int intermediateMatchHashTableSizeBeforeGrow;
    private int matchCount;

    public HollowHashIndexBuilder(HollowReadStateEngine stateEngine, String type, String selectField, String ... matchFields) {
        this.preindexer = new HollowPreindexer(stateEngine, type, selectField, matchFields);
        this.preindexer.buildFieldSpecifications();
        this.memoryRecycler = WastefulRecycler.DEFAULT_INSTANCE;
        HollowIndexerValueTraverser traverser = this.preindexer.getTraverser();
        this.bitsPerTraverserField = new int[traverser.getNumFieldPaths()];
        this.offsetPerTraverserField = new int[traverser.getNumFieldPaths()];
        int bitsPerMatchHashKey = 0;
        for (int i = 0; i < traverser.getNumFieldPaths(); ++i) {
            int maxOrdinalForTypeState = ((HollowTypeReadState)traverser.getFieldTypeDataAccess(i)).maxOrdinal();
            this.bitsPerTraverserField[i] = FixedLengthData.bitsRequiredToRepresentValue(maxOrdinalForTypeState + 1);
            this.offsetPerTraverserField[i] = bitsPerMatchHashKey;
            if (i >= this.preindexer.getNumMatchTraverserFields()) continue;
            bitsPerMatchHashKey += this.bitsPerTraverserField[i];
        }
        this.bitsPerMatchHashKey = bitsPerMatchHashKey;
        this.bitsPerSelectHashEntry = this.bitsPerTraverserField[this.preindexer.getSelectFieldSpec().getBaseIteratorFieldIdx()];
    }

    public void buildIndex() {
        this.matchIndexHashAndSizeArray = new GrowingSegmentedLongArray(this.memoryRecycler);
        BitSet populatedOrdinals = this.preindexer.getTypeState().getListener(PopulatedOrdinalListener.class).getPopulatedOrdinals();
        int guessNumberOfMatches = populatedOrdinals.cardinality();
        this.intermediateMatchHashTableSize = HashCodes.hashTableSize(guessNumberOfMatches);
        this.bitsPerIntermediateListIdentifier = FixedLengthData.bitsRequiredToRepresentValue(this.intermediateMatchHashTableSize - 1);
        this.bitsPerIntermediateMatchHashEntry = this.bitsPerMatchHashKey + this.bitsPerIntermediateListIdentifier;
        this.intermediateMatchHashMask = this.intermediateMatchHashTableSize - 1;
        this.intermediateMatchHashTableSizeBeforeGrow = this.intermediateMatchHashTableSize * 7 / 10;
        this.matchCount = 0;
        this.intermediateMatchHashTable = new FixedLengthElementArray(this.memoryRecycler, (long)this.intermediateMatchHashTableSize * (long)this.bitsPerIntermediateMatchHashEntry);
        this.intermediateSelectLists = new MultiLinkedElementArray(this.memoryRecycler);
        HollowIndexerValueTraverser traverser = this.preindexer.getTraverser();
        int ordinal = populatedOrdinals.nextSetBit(0);
        while (ordinal != -1) {
            traverser.traverse(ordinal);
            for (int i = 0; i < traverser.getNumMatches(); ++i) {
                int matchListIdx;
                int matchHash = this.getMatchHash(i);
                long bucket = matchHash & this.intermediateMatchHashMask;
                long hashBucketBit = bucket * (long)this.bitsPerIntermediateMatchHashEntry;
                boolean bucketIsEmpty = this.intermediateMatchHashTable.getElementValue(hashBucketBit, this.bitsPerTraverserField[0]) == 0L;
                long bucketMatchListIdx = this.intermediateMatchHashTable.getElementValue(hashBucketBit + (long)this.bitsPerMatchHashKey, this.bitsPerIntermediateListIdentifier);
                int bucketMatchHashCode = (int)this.matchIndexHashAndSizeArray.get(bucketMatchListIdx);
                while (!(bucketIsEmpty || bucketMatchHashCode == (matchHash & Integer.MAX_VALUE) && this.intermediateMatchIsEqual(i, hashBucketBit))) {
                    hashBucketBit = (bucket = bucket + 1L & (long)this.intermediateMatchHashMask) * (long)this.bitsPerIntermediateMatchHashEntry;
                    bucketIsEmpty = this.intermediateMatchHashTable.getElementValue(hashBucketBit, this.bitsPerTraverserField[0]) == 0L;
                    bucketMatchListIdx = this.intermediateMatchHashTable.getElementValue(hashBucketBit + (long)this.bitsPerMatchHashKey, this.bitsPerIntermediateListIdentifier);
                    bucketMatchHashCode = (int)this.matchIndexHashAndSizeArray.get(bucketMatchListIdx);
                }
                if (bucketIsEmpty) {
                    matchListIdx = this.intermediateSelectLists.newList();
                    for (int j = 0; j < this.preindexer.getNumMatchTraverserFields(); ++j) {
                        this.intermediateMatchHashTable.setElementValue(hashBucketBit + (long)this.offsetPerTraverserField[j], this.bitsPerTraverserField[j], traverser.getMatchOrdinal(i, j) + 1);
                    }
                    this.intermediateMatchHashTable.setElementValue(hashBucketBit + (long)this.bitsPerMatchHashKey, this.bitsPerIntermediateListIdentifier, matchListIdx);
                    this.matchIndexHashAndSizeArray.set(matchListIdx, matchHash & Integer.MAX_VALUE);
                    ++this.matchCount;
                    if (this.matchCount > this.intermediateMatchHashTableSizeBeforeGrow) {
                        this.growIntermediateHashTable();
                    }
                } else {
                    matchListIdx = (int)this.intermediateMatchHashTable.getElementValue(hashBucketBit + (long)this.bitsPerMatchHashKey, this.bitsPerIntermediateListIdentifier);
                }
                this.intermediateSelectLists.add(matchListIdx, traverser.getMatchOrdinal(i, this.preindexer.getSelectFieldSpec().getBaseIteratorFieldIdx()));
            }
            ordinal = populatedOrdinals.nextSetBit(ordinal + 1);
        }
        long totalNumberOfSelectBucketsAndBitsRequiredForSelectTableSize = this.calculateDedupedSizesAndTotalNumberOfSelectBuckets(this.intermediateSelectLists, this.matchIndexHashAndSizeArray);
        long totalNumberOfSelectBuckets = totalNumberOfSelectBucketsAndBitsRequiredForSelectTableSize & 0xFFFFFFFFFFFFFFL;
        long totalNumberOfMatchBuckets = HashCodes.hashTableSize(this.matchCount);
        int bitsPerFinalSelectBucketPointer = FixedLengthData.bitsRequiredToRepresentValue(totalNumberOfSelectBuckets);
        int bitsPerSelectTableSize = (int)(totalNumberOfSelectBucketsAndBitsRequiredForSelectTableSize >>> 56);
        int finalBitsPerMatchHashEntry = this.bitsPerMatchHashKey + bitsPerSelectTableSize + bitsPerFinalSelectBucketPointer;
        FixedLengthElementArray finalMatchArray = new FixedLengthElementArray(this.memoryRecycler, totalNumberOfMatchBuckets * (long)finalBitsPerMatchHashEntry);
        FixedLengthElementArray finalSelectArray = new FixedLengthElementArray(this.memoryRecycler, totalNumberOfSelectBuckets * (long)this.bitsPerSelectHashEntry);
        long finalMatchHashMask = totalNumberOfMatchBuckets - 1L;
        long currentSelectArrayBucket = 0L;
        for (int i = 0; i < this.matchCount; ++i) {
            long matchIndexHashAndSize = this.matchIndexHashAndSizeArray.get(i);
            int matchIndexSize = (int)(matchIndexHashAndSize >> 32);
            int matchIndexTableSize = HashCodes.hashTableSize(matchIndexSize);
            int matchIndexBucketMask = matchIndexTableSize - 1;
            HollowOrdinalIterator selectOrdinalIter = this.intermediateSelectLists.iterator(i);
            int selectOrdinal = selectOrdinalIter.next();
            while (selectOrdinal != Integer.MAX_VALUE) {
                int selectBucket = HashCodes.hashInt(selectOrdinal) & matchIndexBucketMask;
                int bucketOrdinal = (int)finalSelectArray.getElementValue((currentSelectArrayBucket + (long)selectBucket) * (long)this.bitsPerSelectHashEntry, this.bitsPerSelectHashEntry) - 1;
                while (bucketOrdinal != -1 && bucketOrdinal != selectOrdinal) {
                    selectBucket = selectBucket + 1 & matchIndexBucketMask;
                    bucketOrdinal = (int)finalSelectArray.getElementValue((currentSelectArrayBucket + (long)selectBucket) * (long)this.bitsPerSelectHashEntry, this.bitsPerSelectHashEntry) - 1;
                }
                if (bucketOrdinal == -1) {
                    finalSelectArray.setElementValue((currentSelectArrayBucket + (long)selectBucket) * (long)this.bitsPerSelectHashEntry, this.bitsPerSelectHashEntry, selectOrdinal + 1);
                }
                selectOrdinal = selectOrdinalIter.next();
            }
            long finalMatchIndexBucket = matchIndexHashAndSize & finalMatchHashMask;
            long finalMatchIndexBucketBit = finalMatchIndexBucket * (long)finalBitsPerMatchHashEntry;
            while (finalMatchArray.getElementValue(finalMatchIndexBucketBit, this.bitsPerTraverserField[0]) != 0L) {
                finalMatchIndexBucket = finalMatchIndexBucket + 1L & finalMatchHashMask;
                finalMatchIndexBucketBit = finalMatchIndexBucket * (long)finalBitsPerMatchHashEntry;
            }
            long intermediateMatchHashBucket = matchIndexHashAndSize & (long)this.intermediateMatchHashMask;
            long intermediateMatchIndexBucketBit = intermediateMatchHashBucket * (long)this.bitsPerIntermediateMatchHashEntry;
            while (this.intermediateMatchHashTable.getElementValue(intermediateMatchIndexBucketBit + (long)this.bitsPerMatchHashKey, this.bitsPerIntermediateListIdentifier) != (long)i) {
                intermediateMatchHashBucket = intermediateMatchHashBucket + 1L & (long)this.intermediateMatchHashMask;
                intermediateMatchIndexBucketBit = intermediateMatchHashBucket * (long)this.bitsPerIntermediateMatchHashEntry;
            }
            if (this.bitsPerMatchHashKey < 56) {
                long matchHashKey = this.intermediateMatchHashTable.getElementValue(intermediateMatchIndexBucketBit, this.bitsPerMatchHashKey);
                finalMatchArray.setElementValue(finalMatchIndexBucketBit, this.bitsPerMatchHashKey, matchHashKey);
            } else {
                finalMatchArray.copyBits(this.intermediateMatchHashTable, intermediateMatchIndexBucketBit, finalMatchIndexBucketBit, this.bitsPerMatchHashKey);
            }
            finalMatchArray.setElementValue(finalMatchIndexBucketBit + (long)this.bitsPerMatchHashKey, bitsPerSelectTableSize, matchIndexSize);
            finalMatchArray.setElementValue(finalMatchIndexBucketBit + (long)this.bitsPerMatchHashKey + (long)bitsPerSelectTableSize, bitsPerFinalSelectBucketPointer, currentSelectArrayBucket);
            currentSelectArrayBucket += (long)matchIndexTableSize;
        }
        this.finalMatchHashTable = finalMatchArray;
        this.finalSelectHashArray = finalSelectArray;
        this.finalBitsPerMatchHashEntry = finalBitsPerMatchHashEntry;
        this.finalBitsPerSelectTablePointer = bitsPerFinalSelectBucketPointer;
        this.finalBitsPerSelectTableSize = bitsPerSelectTableSize;
        this.finalMatchHashMask = finalMatchHashMask;
    }

    private void growIntermediateHashTable() {
        int newMatchHashTableSize = this.intermediateMatchHashTableSize * 2;
        int newMatchHashMask = newMatchHashTableSize - 1;
        int newBitsForListIdentifier = FixedLengthData.bitsRequiredToRepresentValue(newMatchHashTableSize - 1);
        int newBitsPerMatchHashEntry = this.bitsPerMatchHashKey + newBitsForListIdentifier;
        FixedLengthElementArray newMatchHashTable = new FixedLengthElementArray(this.memoryRecycler, (long)newMatchHashTableSize * (long)newBitsPerMatchHashEntry);
        for (int j = 0; j < this.matchCount; ++j) {
            boolean rehashBucketIsEmpty;
            int rehashCode = (int)this.matchIndexHashAndSizeArray.get(j);
            long oldHashBucket = rehashCode & this.intermediateMatchHashMask;
            long oldHashBucketBit = oldHashBucket * (long)this.bitsPerIntermediateMatchHashEntry;
            while (this.intermediateMatchHashTable.getElementValue(oldHashBucketBit + (long)this.bitsPerMatchHashKey, this.bitsPerIntermediateListIdentifier) != (long)j) {
                oldHashBucket = oldHashBucket + 1L & (long)this.intermediateMatchHashMask;
                oldHashBucketBit = oldHashBucket * (long)this.bitsPerIntermediateMatchHashEntry;
            }
            long rehashBucket = rehashCode & newMatchHashMask;
            long rehashBucketBit = rehashBucket * (long)newBitsPerMatchHashEntry;
            boolean bl = rehashBucketIsEmpty = newMatchHashTable.getElementValue(rehashBucketBit, this.bitsPerTraverserField[0]) == 0L;
            while (!rehashBucketIsEmpty) {
                rehashBucketBit = (rehashBucket = rehashBucket + 1L & (long)newMatchHashMask) * (long)newBitsPerMatchHashEntry;
                rehashBucketIsEmpty = newMatchHashTable.getElementValue(rehashBucketBit, this.bitsPerTraverserField[0]) == 0L;
            }
            if (this.bitsPerMatchHashKey < 56) {
                newMatchHashTable.setElementValue(rehashBucketBit, this.bitsPerMatchHashKey, this.intermediateMatchHashTable.getElementValue(oldHashBucketBit, this.bitsPerMatchHashKey));
            } else {
                newMatchHashTable.copyBits(this.intermediateMatchHashTable, oldHashBucketBit, rehashBucketBit, this.bitsPerMatchHashKey);
            }
            int listIdx = (int)this.intermediateMatchHashTable.getElementValue(oldHashBucketBit + (long)this.bitsPerMatchHashKey, this.bitsPerIntermediateListIdentifier);
            newMatchHashTable.setElementValue(rehashBucketBit + (long)this.bitsPerMatchHashKey, this.bitsPerIntermediateListIdentifier, listIdx);
        }
        this.intermediateMatchHashTable.destroy(this.memoryRecycler);
        this.memoryRecycler.swap();
        this.intermediateMatchHashTable = newMatchHashTable;
        this.intermediateMatchHashTableSize = newMatchHashTableSize;
        this.intermediateMatchHashTableSizeBeforeGrow = this.intermediateMatchHashTableSize * 7 / 10;
        this.bitsPerIntermediateListIdentifier = newBitsForListIdentifier;
        this.bitsPerIntermediateMatchHashEntry = newBitsPerMatchHashEntry;
        this.intermediateMatchHashMask = newMatchHashMask;
    }

    private long calculateDedupedSizesAndTotalNumberOfSelectBuckets(MultiLinkedElementArray elementArray, GrowingSegmentedLongArray matchIndexHashAndSizeArray) {
        long totalBuckets = 0L;
        long maxSize = 0L;
        int[] selectArray = new int[8];
        for (int i = 0; i < elementArray.numLists(); ++i) {
            int listSize = elementArray.listSize(i);
            int setSize = 0;
            int predictedBuckets = HashCodes.hashTableSize(listSize);
            int hashMask = predictedBuckets - 1;
            if (predictedBuckets > selectArray.length) {
                selectArray = new int[predictedBuckets];
            }
            for (int j = 0; j < predictedBuckets; ++j) {
                selectArray[j] = -1;
            }
            HollowOrdinalIterator iter = elementArray.iterator(i);
            int selectOrdinal = iter.next();
            while (selectOrdinal != Integer.MAX_VALUE) {
                int hash = HashCodes.hashInt(selectOrdinal);
                int bucket = hash & hashMask;
                while (selectArray[bucket] != selectOrdinal) {
                    if (selectArray[bucket] == -1) {
                        selectArray[bucket] = selectOrdinal;
                        ++setSize;
                        break;
                    }
                    bucket = bucket + 1 & hashMask;
                }
                selectOrdinal = iter.next();
            }
            long matchIndexHashAndSize = matchIndexHashAndSizeArray.get(i);
            matchIndexHashAndSizeArray.set(i, matchIndexHashAndSize |= (long)setSize << 32);
            totalBuckets += (long)HashCodes.hashTableSize(setSize);
            if ((long)setSize <= maxSize) continue;
            maxSize = setSize;
        }
        return totalBuckets | (long)FixedLengthData.bitsRequiredToRepresentValue(maxSize) << 56;
    }

    private boolean intermediateMatchIsEqual(int matchIdx, long hashBucketBit) {
        for (int i = 0; i < this.preindexer.getMatchFieldSpecs().length; ++i) {
            HollowHashIndexField field = this.preindexer.getMatchFieldSpecs()[i];
            int matchOrdinal = this.preindexer.getTraverser().getMatchOrdinal(matchIdx, field.getBaseIteratorFieldIdx());
            int hashOrdinal = (int)this.intermediateMatchHashTable.getElementValue(hashBucketBit + (long)this.offsetPerTraverserField[field.getBaseIteratorFieldIdx()], this.bitsPerTraverserField[field.getBaseIteratorFieldIdx()]) - 1;
            HollowTypeReadState readState = field.getBaseDataAccess();
            int[] fieldPath = field.getSchemaFieldPositionPath();
            if (fieldPath.length == 0) {
                if (matchOrdinal == hashOrdinal) continue;
                return false;
            }
            for (int j = 0; j < fieldPath.length - 1; ++j) {
                HollowObjectTypeReadState objectAccess = (HollowObjectTypeReadState)readState;
                readState = objectAccess.getSchema().getReferencedTypeState(fieldPath[j]);
                if (matchOrdinal != -1) {
                    matchOrdinal = objectAccess.readOrdinal(matchOrdinal, fieldPath[j]);
                }
                if (hashOrdinal == -1) continue;
                hashOrdinal = objectAccess.readOrdinal(hashOrdinal, fieldPath[j]);
            }
            if (matchOrdinal == hashOrdinal) continue;
            HollowObjectTypeReadState objectAccess = (HollowObjectTypeReadState)readState;
            int fieldIdx = fieldPath[fieldPath.length - 1];
            if (!this.isAnyFieldNull(matchOrdinal, hashOrdinal) && HollowReadFieldUtils.fieldsAreEqual(objectAccess, matchOrdinal, fieldIdx, objectAccess, hashOrdinal, fieldIdx)) continue;
            return false;
        }
        return true;
    }

    private boolean isAnyFieldNull(int matchOrdinal, int hashOrdinal) {
        return matchOrdinal == -1 || hashOrdinal == -1;
    }

    private int getMatchHash(int matchIdx) {
        int matchHash = 0;
        for (int i = 0; i < this.preindexer.getMatchFieldSpecs().length; ++i) {
            HollowHashIndexField field = this.preindexer.getMatchFieldSpecs()[i];
            int ordinal = this.preindexer.getTraverser().getMatchOrdinal(matchIdx, field.getBaseIteratorFieldIdx());
            HollowTypeReadState readState = field.getBaseDataAccess();
            int[] fieldPath = field.getSchemaFieldPositionPath();
            if (fieldPath.length == 0) {
                matchHash ^= HashCodes.hashInt(ordinal);
                continue;
            }
            for (int j = 0; j < fieldPath.length - 1; ++j) {
                HollowObjectTypeReadState objectAccess = (HollowObjectTypeReadState)readState;
                readState = objectAccess.getSchema().getReferencedTypeState(fieldPath[j]);
                if ((ordinal = objectAccess.readOrdinal(ordinal, fieldPath[j])) == -1) break;
            }
            int fieldHashCode = ordinal == -1 ? -1 : HollowReadFieldUtils.fieldHashCode((HollowObjectTypeDataAccess)((Object)readState), ordinal, fieldPath[fieldPath.length - 1]);
            matchHash ^= HashCodes.hashInt(fieldHashCode);
        }
        return matchHash;
    }

    public int getBitsPerMatchHashKey() {
        return this.bitsPerMatchHashKey;
    }

    public FixedLengthElementArray getFinalMatchHashTable() {
        return this.finalMatchHashTable;
    }

    public long getFinalMatchHashMask() {
        return this.finalMatchHashMask;
    }

    public int getFinalBitsPerMatchHashEntry() {
        return this.finalBitsPerMatchHashEntry;
    }

    public int getFinalBitsPerSelectTableSize() {
        return this.finalBitsPerSelectTableSize;
    }

    public int getFinalBitsPerSelectTablePointer() {
        return this.finalBitsPerSelectTablePointer;
    }

    public FixedLengthElementArray getFinalSelectHashArray() {
        return this.finalSelectHashArray;
    }

    public HollowHashIndexField getSelectField() {
        return this.preindexer.getSelectFieldSpec();
    }

    public HollowHashIndexField[] getMatchFields() {
        return this.preindexer.getMatchFieldSpecs();
    }

    public int[] getBitsPerTraverserField() {
        return this.bitsPerTraverserField;
    }

    public int[] getOffsetPerTraverserField() {
        return this.offsetPerTraverserField;
    }

    public int getBitsPerSelectHashEntry() {
        return this.bitsPerSelectHashEntry;
    }
}

