/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.index;

import com.netflix.hollow.core.index.HollowHashIndexBuilder;
import com.netflix.hollow.core.index.HollowHashIndexField;
import com.netflix.hollow.core.index.HollowHashIndexResult;
import com.netflix.hollow.core.memory.encoding.FixedLengthElementArray;
import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.read.HollowReadFieldUtils;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.engine.HollowTypeStateListener;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import java.util.Objects;

public class HollowHashIndex
implements HollowTypeStateListener {
    private volatile HollowHashIndexState hashStateVolatile;
    private final HollowReadStateEngine stateEngine;
    private final HollowObjectTypeReadState typeState;
    private final String type;
    private final String selectField;
    private final String[] matchFields;

    public HollowHashIndex(HollowReadStateEngine stateEngine, String type, String selectField, String ... matchFields) {
        Objects.requireNonNull(type, "Hollow Hash Index creation failed because type was null");
        Objects.requireNonNull(stateEngine, "Hollow Hash Index creation on type [" + type + "] failed because read state wasn't initialized");
        this.stateEngine = stateEngine;
        this.type = type;
        this.typeState = (HollowObjectTypeReadState)stateEngine.getTypeState(type);
        this.selectField = selectField;
        this.matchFields = matchFields;
        this.reindexHashIndex();
    }

    private void reindexHashIndex() {
        HollowHashIndexBuilder builder = new HollowHashIndexBuilder(this.stateEngine, this.type, this.selectField, this.matchFields);
        builder.buildIndex();
        this.hashStateVolatile = new HollowHashIndexState(builder);
    }

    public HollowHashIndexResult findMatches(Object ... query) {
        HollowHashIndexResult result;
        HollowHashIndexState hashState;
        int hashCode = 0;
        for (int i = 0; i < query.length; ++i) {
            if (query[i] == null) {
                throw new IllegalArgumentException("querying by null unsupported; i=" + i);
            }
            hashCode ^= HashCodes.hashInt(this.keyHashCode(query[i], i));
        }
        block1: do {
            boolean bucketIsEmpty;
            result = null;
            hashState = this.hashStateVolatile;
            long bucket = hashCode & hashState.getMatchHashMask();
            long hashBucketBit = bucket * (long)hashState.getBitsPerMatchHashEntry();
            boolean bl = bucketIsEmpty = hashState.getMatchHashTable().getElementValue(hashBucketBit, hashState.getBitsPerTraverserField()[0]) == 0L;
            while (!bucketIsEmpty) {
                if (this.matchIsEqual(hashState.getMatchHashTable(), hashBucketBit, query)) {
                    int selectSize = (int)hashState.getMatchHashTable().getElementValue(hashBucketBit + (long)hashState.getBitsPerMatchHashKey(), hashState.getBitsPerSelectTableSize());
                    long selectBucketPointer = hashState.getMatchHashTable().getElementValue(hashBucketBit + (long)hashState.getBitsPerMatchHashKey() + (long)hashState.getBitsPerSelectTableSize(), hashState.getBitsPerSelectTablePointer());
                    result = new HollowHashIndexResult(hashState, selectBucketPointer, selectSize);
                    continue block1;
                }
                bucket = bucket + 1L & (long)hashState.getMatchHashMask();
                hashBucketBit = bucket * (long)hashState.getBitsPerMatchHashEntry();
                bucketIsEmpty = hashState.getMatchHashTable().getElementValue(hashBucketBit, hashState.getBitsPerTraverserField()[0]) == 0L;
            }
        } while (hashState != this.hashStateVolatile);
        return result;
    }

    private int keyHashCode(Object key, int fieldIdx) {
        HollowHashIndexState hashState = this.hashStateVolatile;
        switch (hashState.getMatchFields()[fieldIdx].getFieldType()) {
            case BOOLEAN: {
                return HollowReadFieldUtils.booleanHashCode((Boolean)key);
            }
            case DOUBLE: {
                return HollowReadFieldUtils.doubleHashCode((Double)key);
            }
            case FLOAT: {
                return HollowReadFieldUtils.floatHashCode(((Float)key).floatValue());
            }
            case INT: {
                return HollowReadFieldUtils.intHashCode((Integer)key);
            }
            case LONG: {
                return HollowReadFieldUtils.longHashCode((Long)key);
            }
            case REFERENCE: {
                return (Integer)key;
            }
            case BYTES: {
                return HashCodes.hashCode((byte[])key);
            }
            case STRING: {
                return HashCodes.hashCode((String)key);
            }
        }
        throw new IllegalArgumentException("I don't know how to hash a " + (Object)((Object)hashState.getMatchFields()[fieldIdx].getFieldType()));
    }

    private boolean matchIsEqual(FixedLengthElementArray matchHashTable, long hashBucketBit, Object[] query) {
        HollowHashIndexState hashState = this.hashStateVolatile;
        for (int i = 0; i < hashState.getMatchFields().length; ++i) {
            HollowHashIndexField field = hashState.getMatchFields()[i];
            int hashOrdinal = (int)matchHashTable.getElementValue(hashBucketBit + (long)hashState.getOffsetPerTraverserField()[field.getBaseIteratorFieldIdx()], hashState.getBitsPerTraverserField()[field.getBaseIteratorFieldIdx()]) - 1;
            HollowTypeReadState readState = field.getBaseDataAccess();
            int[] fieldPath = field.getSchemaFieldPositionPath();
            if (fieldPath.length == 0) {
                if (query[i].equals(hashOrdinal)) continue;
                return false;
            }
            for (int j = 0; j < fieldPath.length - 1; ++j) {
                HollowObjectTypeReadState objectAccess = (HollowObjectTypeReadState)readState;
                readState = objectAccess.getSchema().getReferencedTypeState(fieldPath[j]);
                if ((hashOrdinal = objectAccess.readOrdinal(hashOrdinal, fieldPath[j])) == -1) break;
            }
            HollowObjectTypeReadState objectAccess = (HollowObjectTypeReadState)readState;
            int fieldIdx = fieldPath[fieldPath.length - 1];
            if (hashOrdinal != -1 && HollowReadFieldUtils.fieldValueEquals(objectAccess, hashOrdinal, fieldIdx, query[i])) continue;
            return false;
        }
        return true;
    }

    public void listenForDeltaUpdates() {
        this.typeState.addListener(this);
    }

    public void detachFromDeltaUpdates() {
        this.typeState.removeListener(this);
    }

    @Override
    public void beginUpdate() {
    }

    @Override
    public void addedOrdinal(int ordinal) {
    }

    @Override
    public void removedOrdinal(int ordinal) {
    }

    @Override
    public void endUpdate() {
        this.reindexHashIndex();
    }

    public HollowReadStateEngine getStateEngine() {
        return this.stateEngine;
    }

    public String getType() {
        return this.type;
    }

    public String getSelectField() {
        return this.selectField;
    }

    public String[] getMatchFields() {
        return this.matchFields;
    }

    protected static class HollowHashIndexState {
        final FixedLengthElementArray selectHashArray;
        final int bitsPerSelectHashEntry;
        private final FixedLengthElementArray matchHashTable;
        private final HollowHashIndexField[] matchFields;
        private final int matchHashMask;
        private final int bitsPerMatchHashKey;
        private final int bitsPerMatchHashEntry;
        private final int[] bitsPerTraverserField;
        private final int[] offsetPerTraverserField;
        private final int bitsPerSelectTableSize;
        private final int bitsPerSelectTablePointer;

        public HollowHashIndexState(HollowHashIndexBuilder builder) {
            this.matchHashTable = builder.getFinalMatchHashTable();
            this.selectHashArray = builder.getFinalSelectHashArray();
            this.matchFields = builder.getMatchFields();
            this.matchHashMask = (int)builder.getFinalMatchHashMask();
            this.bitsPerMatchHashKey = builder.getBitsPerMatchHashKey();
            this.bitsPerMatchHashEntry = builder.getFinalBitsPerMatchHashEntry();
            this.bitsPerTraverserField = builder.getBitsPerTraverserField();
            this.offsetPerTraverserField = builder.getOffsetPerTraverserField();
            this.bitsPerSelectTableSize = builder.getFinalBitsPerSelectTableSize();
            this.bitsPerSelectTablePointer = builder.getFinalBitsPerSelectTablePointer();
            this.bitsPerSelectHashEntry = builder.getBitsPerSelectHashEntry();
        }

        public FixedLengthElementArray getSelectHashArray() {
            return this.selectHashArray;
        }

        public int getBitsPerSelectHashEntry() {
            return this.bitsPerSelectHashEntry;
        }

        public FixedLengthElementArray getMatchHashTable() {
            return this.matchHashTable;
        }

        public HollowHashIndexField[] getMatchFields() {
            return this.matchFields;
        }

        public int getMatchHashMask() {
            return this.matchHashMask;
        }

        public int getBitsPerMatchHashKey() {
            return this.bitsPerMatchHashKey;
        }

        public int getBitsPerMatchHashEntry() {
            return this.bitsPerMatchHashEntry;
        }

        public int[] getBitsPerTraverserField() {
            return this.bitsPerTraverserField;
        }

        public int[] getOffsetPerTraverserField() {
            return this.offsetPerTraverserField;
        }

        public int getBitsPerSelectTableSize() {
            return this.bitsPerSelectTableSize;
        }

        public int getBitsPerSelectTablePointer() {
            return this.bitsPerSelectTablePointer;
        }
    }
}

