/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.index;

import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import java.util.Arrays;

public class GrowingSegmentedLongArray {
    private long[][] segments;
    private final int log2OfSegmentSize;
    private final int bitmask;
    private final ArraySegmentRecycler memoryRecycler;

    public GrowingSegmentedLongArray(ArraySegmentRecycler memoryRecycler) {
        this.memoryRecycler = memoryRecycler;
        this.log2OfSegmentSize = memoryRecycler.getLog2OfLongSegmentSize();
        this.bitmask = (1 << this.log2OfSegmentSize) - 1;
        this.segments = new long[64][];
    }

    public void set(long index, long value) {
        int segmentIndex = (int)(index >> this.log2OfSegmentSize);
        if (segmentIndex >= this.segments.length) {
            int nextPowerOfTwo = 1 << 32 - Integer.numberOfLeadingZeros(segmentIndex);
            this.segments = (long[][])Arrays.copyOf(this.segments, nextPowerOfTwo);
        }
        if (this.segments[segmentIndex] == null) {
            this.segments[segmentIndex] = this.memoryRecycler.getLongArray();
        }
        int longInSegment = (int)(index & (long)this.bitmask);
        this.segments[segmentIndex][longInSegment] = value;
    }

    public long get(long index) {
        int segmentIndex = (int)(index >> this.log2OfSegmentSize);
        if (segmentIndex >= this.segments.length || this.segments[segmentIndex] == null) {
            return 0L;
        }
        int longInSegment = (int)(index & (long)this.bitmask);
        return this.segments[segmentIndex][longInSegment];
    }

    public void destroy() {
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.segments[i] == null) continue;
            this.memoryRecycler.recycleLongArray(this.segments[i]);
        }
    }
}

