/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.testdata;

import com.netflix.hollow.api.consumer.HollowConsumer;
import com.netflix.hollow.api.testdata.HollowTestBlobRetriever;
import com.netflix.hollow.api.testdata.HollowTestRecord;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.util.StateEngineRoundTripper;
import com.netflix.hollow.core.write.HollowBlobWriter;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class HollowTestDataset {
    private final HollowWriteStateEngine writeEngine = new HollowWriteStateEngine();
    private final List<HollowTestRecord<Void>> recsToAdd = new ArrayList<HollowTestRecord<Void>>();
    private HollowTestBlobRetriever blobRetriever;
    private long currentState = 0L;

    public void add(HollowTestRecord<Void> rec) {
        this.recsToAdd.add(rec);
    }

    public HollowConsumer.Builder<?> newConsumerBuilder() {
        this.blobRetriever = new HollowTestBlobRetriever();
        return HollowConsumer.newHollowConsumer().withBlobRetriever(this.blobRetriever);
    }

    public void buildSnapshot(HollowConsumer consumer) {
        for (HollowTestRecord<Void> rec : this.recsToAdd) {
            rec.addTo(this.writeEngine);
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            HollowBlobWriter writer = new HollowBlobWriter(this.writeEngine);
            writer.writeSnapshot(baos);
            this.writeEngine.prepareForNextCycle();
            this.blobRetriever.addSnapshot(this.currentState, new HollowTestBlobRetriever.TestBlob(this.currentState, baos.toByteArray()));
            consumer.triggerRefreshTo(this.currentState);
        }
        catch (IOException rethrow) {
            throw new RuntimeException(rethrow);
        }
    }

    public void buildDelta(HollowConsumer consumer) {
        for (HollowTestRecord<Void> rec : this.recsToAdd) {
            rec.addTo(this.writeEngine);
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            HollowBlobWriter writer = new HollowBlobWriter(this.writeEngine);
            writer.writeDelta(baos);
            this.writeEngine.prepareForNextCycle();
            long nextState = this.currentState + 1L;
            this.blobRetriever.addDelta(this.currentState, new HollowTestBlobRetriever.TestBlob(this.currentState, nextState, baos.toByteArray()));
            consumer.triggerRefreshTo(nextState);
            this.currentState = nextState;
        }
        catch (IOException rethrow) {
            throw new RuntimeException(rethrow);
        }
    }

    public HollowReadStateEngine buildSnapshot() {
        for (HollowTestRecord<Void> rec : this.recsToAdd) {
            rec.addTo(this.writeEngine);
        }
        try {
            return StateEngineRoundTripper.roundTripSnapshot(this.writeEngine);
        }
        catch (IOException rethrow) {
            throw new RuntimeException(rethrow);
        }
    }

    public void buildDelta(HollowReadStateEngine readEngine) {
        for (HollowTestRecord<Void> rec : this.recsToAdd) {
            rec.addTo(this.writeEngine);
        }
        try {
            StateEngineRoundTripper.roundTripDelta(this.writeEngine, readEngine);
        }
        catch (IOException rethrow) {
            throw new RuntimeException(rethrow);
        }
    }
}

