/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.testdata;

import com.netflix.hollow.api.consumer.HollowConsumer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

class HollowTestBlobRetriever
implements HollowConsumer.BlobRetriever {
    private final Map<Long, HollowConsumer.Blob> snapshots = new HashMap<Long, HollowConsumer.Blob>();
    private final Map<Long, HollowConsumer.Blob> deltas = new HashMap<Long, HollowConsumer.Blob>();
    private final Map<Long, HollowConsumer.Blob> reverseDeltas = new HashMap<Long, HollowConsumer.Blob>();

    HollowTestBlobRetriever() {
    }

    @Override
    public HollowConsumer.Blob retrieveSnapshotBlob(long desiredVersion) {
        return this.snapshots.get(desiredVersion);
    }

    @Override
    public HollowConsumer.Blob retrieveDeltaBlob(long currentVersion) {
        return this.deltas.get(currentVersion);
    }

    @Override
    public HollowConsumer.Blob retrieveReverseDeltaBlob(long currentVersion) {
        return this.reverseDeltas.get(currentVersion);
    }

    public void addSnapshot(long desiredVersion, HollowConsumer.Blob transition) {
        this.snapshots.put(desiredVersion, transition);
    }

    public void addDelta(long currentVersion, HollowConsumer.Blob transition) {
        this.deltas.put(currentVersion, transition);
    }

    public void addReverseDelta(long currentVersion, HollowConsumer.Blob transition) {
        this.reverseDeltas.put(currentVersion, transition);
    }

    public static class TestBlob
    extends HollowConsumer.Blob {
        private final byte[] data;

        public TestBlob(long snapshotVersion, byte[] data) {
            super(snapshotVersion);
            this.data = data;
        }

        public TestBlob(long fromVersion, long toVersion, byte[] data) {
            super(fromVersion, toVersion);
            this.data = data;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.data);
        }
    }
}

