/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.sampling;

import com.netflix.hollow.api.sampling.DisabledSamplingDirector;
import com.netflix.hollow.api.sampling.HollowSampler;
import com.netflix.hollow.api.sampling.HollowSamplingDirector;
import com.netflix.hollow.api.sampling.SampleResult;
import com.netflix.hollow.core.read.filter.HollowFilterConfig;
import java.util.ArrayList;
import java.util.Collection;

public class HollowSetSampler
implements HollowSampler {
    public static final HollowSetSampler NULL_SAMPLER = new HollowSetSampler("", DisabledSamplingDirector.INSTANCE);
    private final String typeName;
    private HollowSamplingDirector director;
    private long sizeSamples;
    private long getSamples;
    private long iteratorSamples;

    public HollowSetSampler(String typeName, HollowSamplingDirector director) {
        this.typeName = typeName;
        this.director = director;
    }

    @Override
    public void setSamplingDirector(HollowSamplingDirector director) {
        if (!"".equals(this.typeName)) {
            this.director = director;
        }
    }

    @Override
    public void setFieldSpecificSamplingDirector(HollowFilterConfig fieldSpec, HollowSamplingDirector director) {
        if (!"".equals(this.typeName) && fieldSpec.doesIncludeType(this.typeName)) {
            this.director = director;
        }
    }

    @Override
    public void setUpdateThread(Thread t) {
        this.director.setUpdateThread(t);
    }

    public void recordGet() {
        if (this.director.shouldRecord()) {
            ++this.getSamples;
        }
    }

    public void recordSize() {
        if (this.director.shouldRecord()) {
            ++this.sizeSamples;
        }
    }

    public void recordIterator() {
        if (this.director.shouldRecord()) {
            ++this.iteratorSamples;
        }
    }

    @Override
    public boolean hasSampleResults() {
        return this.sizeSamples > 0L || this.getSamples > 0L || this.iteratorSamples > 0L;
    }

    @Override
    public Collection<SampleResult> getSampleResults() {
        ArrayList<SampleResult> results = new ArrayList<SampleResult>(3);
        results.add(new SampleResult(this.typeName + ".size()", this.sizeSamples));
        results.add(new SampleResult(this.typeName + ".get()", this.getSamples));
        results.add(new SampleResult(this.typeName + ".iterator()", this.iteratorSamples));
        return results;
    }

    @Override
    public void reset() {
        this.sizeSamples = 0L;
        this.getSamples = 0L;
        this.iteratorSamples = 0L;
    }
}

