/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.sampling;

import com.netflix.hollow.api.sampling.DisabledSamplingDirector;
import com.netflix.hollow.api.sampling.HollowSampler;
import com.netflix.hollow.api.sampling.HollowSamplingDirector;
import com.netflix.hollow.api.sampling.SampleResult;
import com.netflix.hollow.core.read.filter.HollowFilterConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class HollowObjectCreationSampler
implements HollowSampler {
    private final String[] typeNames;
    private final long[] creationSamples;
    private final HollowSamplingDirector[] typeDirectors;

    public HollowObjectCreationSampler(String ... typeNames) {
        this.typeNames = typeNames;
        this.creationSamples = new long[typeNames.length];
        Object[] typeDirectors = new HollowSamplingDirector[typeNames.length];
        Arrays.fill(typeDirectors, DisabledSamplingDirector.INSTANCE);
        this.typeDirectors = typeDirectors;
    }

    public void recordCreation(int index) {
        if (this.typeDirectors[index].shouldRecord()) {
            int n = index;
            this.creationSamples[n] = this.creationSamples[n] + 1L;
        }
    }

    @Override
    public void setSamplingDirector(HollowSamplingDirector director) {
        Arrays.fill(this.typeDirectors, director);
    }

    @Override
    public void setFieldSpecificSamplingDirector(HollowFilterConfig fieldSpec, HollowSamplingDirector director) {
        for (int i = 0; i < this.typeNames.length; ++i) {
            if (!fieldSpec.doesIncludeType(this.typeNames[i])) continue;
            this.typeDirectors[i] = director;
        }
    }

    @Override
    public void setUpdateThread(Thread t) {
        for (int i = 0; i < this.typeDirectors.length; ++i) {
            this.typeDirectors[i].setUpdateThread(t);
        }
    }

    @Override
    public boolean hasSampleResults() {
        for (int i = 0; i < this.creationSamples.length; ++i) {
            if (this.creationSamples[i] <= 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<SampleResult> getSampleResults() {
        ArrayList<SampleResult> results = new ArrayList<SampleResult>(this.typeNames.length);
        for (int i = 0; i < this.typeNames.length; ++i) {
            results.add(new SampleResult(this.typeNames[i], this.creationSamples[i]));
        }
        Collections.sort(results);
        return results;
    }

    @Override
    public void reset() {
        Arrays.fill(this.creationSamples, 0L);
    }
}

