/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.producer.validation;

import com.netflix.hollow.api.producer.validation.ValidationResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ValidationStatus {
    private final List<ValidationResult> results;
    private final boolean passed;

    public ValidationStatus(List<ValidationResult> results) {
        this.results = Collections.unmodifiableList(new ArrayList<ValidationResult>(results));
        this.passed = this.results.stream().allMatch(ValidationResult::isPassed);
    }

    public boolean passed() {
        return this.passed;
    }

    public boolean failed() {
        return !this.passed;
    }

    public List<ValidationResult> getResults() {
        return this.results;
    }
}

