/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.producer.validation;

import com.netflix.hollow.api.producer.validation.ValidationResultType;
import com.netflix.hollow.api.producer.validation.ValidatorListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class ValidationResult {
    private final ValidationResultType type;
    private final String name;
    private final Throwable ex;
    private final String message;
    private final Map<String, String> details;

    ValidationResult(ValidationResultType type, String name, Throwable ex, String message, Map<String, String> details) {
        if (type == ValidationResultType.ERROR && ex == null) {
            throw new IllegalArgumentException();
        }
        if (type == ValidationResultType.PASSED && ex != null) {
            throw new IllegalArgumentException();
        }
        assert (name != null);
        this.name = name;
        this.type = type;
        assert (type != null);
        this.ex = ex;
        this.message = message;
        this.details = Collections.unmodifiableMap(details);
    }

    public ValidationResultType getResultType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Throwable getThrowable() {
        return this.ex;
    }

    public String getMessage() {
        return this.message;
    }

    public Map<String, String> getDetails() {
        return this.details;
    }

    public boolean isPassed() {
        return this.type == ValidationResultType.PASSED;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ValidationResult[").append("name=\"").append(this.name).append("\" ").append("result=").append((Object)this.type).append(" ");
        if (this.message == null) {
            sb.append("message=null ");
        } else {
            sb.append("message=\"").append(this.message).append("\" ");
        }
        sb.append("details=").append(this.details).append(" ").append("throwable=").append(this.ex).append(" ").append("]");
        return sb.toString();
    }

    public static ValidationResultBuilder from(ValidatorListener v) {
        return ValidationResult.from(v.getName());
    }

    public static ValidationResultBuilder from(String name) {
        return new ValidationResultBuilder(name);
    }

    public static class ValidationResultBuilder {
        private final String name;
        private Map<String, String> details;

        ValidationResultBuilder(String name) {
            this.name = Objects.requireNonNull(name);
            this.details = new HashMap<String, String>();
        }

        public ValidationResultBuilder detail(String name, Object value) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(value);
            this.details.put(name, String.valueOf(value));
            return this;
        }

        public ValidationResult passed() {
            return new ValidationResult(ValidationResultType.PASSED, this.name, null, null, this.details);
        }

        public ValidationResult passed(String message) {
            return this.build(ValidationResultType.PASSED, this.name, null, message, this.details);
        }

        public ValidationResult failed(String message) {
            return this.build(ValidationResultType.FAILED, this.name, null, message, this.details);
        }

        public ValidationResult error(Throwable t) {
            return this.build(ValidationResultType.ERROR, this.name, t, t.getMessage(), this.details);
        }

        private ValidationResult build(ValidationResultType type, String name, Throwable ex, String message, Map<String, String> details) {
            this.reset();
            return new ValidationResult(type, name, ex, message, details);
        }

        private void reset() {
            this.details = new HashMap<String, String>();
        }
    }
}

