/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.producer.validation;

import com.netflix.hollow.api.producer.HollowProducer;
import com.netflix.hollow.api.producer.validation.ValidationResult;
import com.netflix.hollow.api.producer.validation.ValidatorListener;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;

public class RecordCountVarianceValidator
implements ValidatorListener {
    private static final String ZERO_PREVIOUS_COUNT_WARN_MSG_FORMAT = "Previous record count is 0. Not running RecordCountVarianceValidator for type %s. This scenario is not expected except when starting a new namespace.";
    private static final String FAILED_RECORD_COUNT_VALIDATION = "Record count validation for type %s has failed as actual change percent %s is greater than allowed change percent %s.";
    private static final String DATA_TYPE_NAME = "Typename";
    private static final String ALLOWABLE_VARIANCE_PERCENT_NAME = "AllowableVariancePercent";
    private static final String LATEST_CARDINALITY_NAME = "LatestRecordCount";
    private static final String PREVIOUS_CARDINALITY_NAME = "PreviousRecordCount";
    private static final String ACTUAL_CHANGE_PERCENT_NAME = "ActualChangePercent";
    private static final String NAME = RecordCountVarianceValidator.class.getName();
    private final String typeName;
    private final float allowableVariancePercent;

    public RecordCountVarianceValidator(String typeName, float allowableVariancePercent) {
        this.typeName = typeName;
        if (allowableVariancePercent < 0.0f) {
            throw new IllegalArgumentException("RecordCountVarianceValidator for type " + typeName + ": cannot have allowableVariancePercent less than 0. Value provided: " + allowableVariancePercent);
        }
        this.allowableVariancePercent = allowableVariancePercent;
    }

    @Override
    public String getName() {
        return NAME + "_" + this.typeName;
    }

    @Override
    public ValidationResult onValidate(HollowProducer.ReadState readState) {
        ValidationResult.ValidationResultBuilder vrb = ValidationResult.from(this);
        vrb.detail(ALLOWABLE_VARIANCE_PERCENT_NAME, Float.valueOf(this.allowableVariancePercent)).detail(DATA_TYPE_NAME, this.typeName);
        HollowTypeReadState typeState = readState.getStateEngine().getTypeState(this.typeName);
        int latestCardinality = typeState.getPopulatedOrdinals().cardinality();
        int previousCardinality = typeState.getPreviousOrdinals().cardinality();
        vrb.detail(LATEST_CARDINALITY_NAME, latestCardinality).detail(PREVIOUS_CARDINALITY_NAME, previousCardinality);
        if (previousCardinality == 0) {
            return vrb.detail("skipped", Boolean.TRUE).passed(String.format(ZERO_PREVIOUS_COUNT_WARN_MSG_FORMAT, this.typeName));
        }
        float actualChangePercent = this.getChangePercent(latestCardinality, previousCardinality);
        vrb.detail(ACTUAL_CHANGE_PERCENT_NAME, Float.valueOf(actualChangePercent));
        if (Float.compare(actualChangePercent, this.allowableVariancePercent) > 0) {
            String message = String.format(FAILED_RECORD_COUNT_VALIDATION, this.typeName, Float.valueOf(actualChangePercent), Float.valueOf(this.allowableVariancePercent));
            return vrb.failed(message);
        }
        return vrb.passed();
    }

    float getChangePercent(int latestCardinality, int previousCardinality) {
        int diff = Math.abs(latestCardinality - previousCardinality);
        return 100.0f * (float)diff / (float)previousCardinality;
    }
}

