/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.producer.metrics;

import java.util.OptionalLong;

public class AnnouncementMetrics {
    private long dataSizeBytes;
    private long announcementDurationMillis;
    private boolean isAnnouncementSuccess;
    private OptionalLong lastAnnouncementSuccessTimeNano;

    public long getDataSizeBytes() {
        return this.dataSizeBytes;
    }

    public long getAnnouncementDurationMillis() {
        return this.announcementDurationMillis;
    }

    public boolean getIsAnnouncementSuccess() {
        return this.isAnnouncementSuccess;
    }

    public OptionalLong getLastAnnouncementSuccessTimeNano() {
        return this.lastAnnouncementSuccessTimeNano;
    }

    private AnnouncementMetrics(Builder builder) {
        this.dataSizeBytes = builder.dataSizeBytes;
        this.announcementDurationMillis = builder.announcementDurationMillis;
        this.isAnnouncementSuccess = builder.isAnnouncementSuccess;
        this.lastAnnouncementSuccessTimeNano = builder.lastAnnouncementSuccessTimeNano;
    }

    public static final class Builder {
        private long dataSizeBytes;
        private long announcementDurationMillis;
        private boolean isAnnouncementSuccess;
        private OptionalLong lastAnnouncementSuccessTimeNano = OptionalLong.empty();

        public Builder setDataSizeBytes(long dataSizeBytes) {
            this.dataSizeBytes = dataSizeBytes;
            return this;
        }

        public Builder setAnnouncementDurationMillis(long announcementDurationMillis) {
            this.announcementDurationMillis = announcementDurationMillis;
            return this;
        }

        public Builder setIsAnnouncementSuccess(boolean isAnnouncementSuccess) {
            this.isAnnouncementSuccess = isAnnouncementSuccess;
            return this;
        }

        public Builder setLastAnnouncementSuccessTimeNano(long lastAnnouncementSuccessTimeNano) {
            this.lastAnnouncementSuccessTimeNano = OptionalLong.of(lastAnnouncementSuccessTimeNano);
            return this;
        }

        public AnnouncementMetrics build() {
            return new AnnouncementMetrics(this);
        }
    }
}

