/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.producer.fs;

import com.netflix.hollow.api.producer.HollowProducer;
import com.netflix.hollow.api.producer.ProducerOptionalBlobPartConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class HollowFilesystemPublisher
implements HollowProducer.Publisher {
    private final Path blobStorePath;

    public HollowFilesystemPublisher(Path blobStorePath) {
        this.blobStorePath = blobStorePath;
        try {
            if (!Files.exists(this.blobStorePath, new LinkOption[0])) {
                Files.createDirectories(this.blobStorePath, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create folder for publisher; path=" + this.blobStorePath, e);
        }
    }

    @Override
    public void publish(HollowProducer.Blob blob) {
        Path destination = null;
        switch (blob.getType()) {
            case SNAPSHOT: {
                destination = this.blobStorePath.resolve(String.format("%s-%d", blob.getType().prefix, blob.getToVersion()));
                break;
            }
            case DELTA: 
            case REVERSE_DELTA: {
                destination = this.blobStorePath.resolve(String.format("%s-%d-%d", blob.getType().prefix, blob.getFromVersion(), blob.getToVersion()));
            }
        }
        try {
            InputStream is = blob.newInputStream();
            Object object = null;
            try (OutputStream os2 = Files.newOutputStream(destination, new OpenOption[0]);){
                int n;
                byte[] buf = new byte[4096];
                while (-1 != (n = is.read(buf))) {
                    os2.write(buf, 0, n);
                }
            }
            catch (Throwable os2) {
                object = os2;
                throw os2;
            }
            finally {
                if (is != null) {
                    if (object != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable os2) {
                            ((Throwable)object).addSuppressed(os2);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to publish file!", e);
        }
        ProducerOptionalBlobPartConfig optionalPartConfig = blob.getOptionalPartConfig();
        if (optionalPartConfig != null) {
            for (String partName : optionalPartConfig.getParts()) {
                Path partDestination = null;
                switch (blob.getType()) {
                    case SNAPSHOT: {
                        partDestination = this.blobStorePath.resolve(String.format("%s_%s-%d", blob.getType().prefix, partName, blob.getToVersion()));
                        break;
                    }
                    case DELTA: 
                    case REVERSE_DELTA: {
                        partDestination = this.blobStorePath.resolve(String.format("%s_%s-%d-%d", blob.getType().prefix, partName, blob.getFromVersion(), blob.getToVersion()));
                    }
                }
                try {
                    InputStream is = blob.newOptionalPartInputStream(partName);
                    Throwable throwable = null;
                    try {
                        OutputStream os = Files.newOutputStream(partDestination, new OpenOption[0]);
                        Throwable throwable2 = null;
                        try {
                            int n;
                            byte[] buf = new byte[4096];
                            while (-1 != (n = is.read(buf))) {
                                os.write(buf, 0, n);
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (os == null) continue;
                            if (throwable2 != null) {
                                try {
                                    os.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            os.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to publish optional part file: " + partName, e);
                }
            }
        }
    }
}

