/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.producer.fs;

import com.netflix.hollow.api.producer.HollowProducer;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Logger;

public class HollowFilesystemBlobStorageCleaner
extends HollowProducer.BlobStorageCleaner {
    private final Logger log = Logger.getLogger(HollowFilesystemBlobStorageCleaner.class.getName());
    private int numOfSnapshotsToKeep;
    private final File blobStoreDir;

    public HollowFilesystemBlobStorageCleaner(File blobStoreDir) {
        this(blobStoreDir, 5);
    }

    public HollowFilesystemBlobStorageCleaner(File blobStoreDir, int numOfSnapshotsToKeep) {
        this.blobStoreDir = blobStoreDir;
        this.numOfSnapshotsToKeep = numOfSnapshotsToKeep;
    }

    @Override
    public void cleanSnapshots() {
        File[] files = this.getFilesByType(HollowProducer.Blob.Type.SNAPSHOT.prefix);
        if (files == null || files.length <= this.numOfSnapshotsToKeep) {
            return;
        }
        this.sortByLastModified(files);
        for (int i = this.numOfSnapshotsToKeep; i < files.length; ++i) {
            File file = files[i];
            boolean deleted = file.delete();
            if (deleted) continue;
            this.log.warning("Could not delete snapshot " + file.getPath());
        }
    }

    @Override
    public void cleanDeltas() {
    }

    @Override
    public void cleanReverseDeltas() {
    }

    private void sortByLastModified(File[] files) {
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                Long lastModifiedF2 = f2.lastModified();
                Long lastModifiedF1 = f1.lastModified();
                return lastModifiedF2.compareTo(lastModifiedF1);
            }
        });
        Arrays.sort(files, Collections.reverseOrder());
    }

    private File[] getFilesByType(final String blobType) {
        return this.blobStoreDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contains(blobType);
            }
        });
    }
}

