/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.producer.enforcer;

import com.netflix.hollow.api.producer.AbstractHollowProducerListener;
import com.netflix.hollow.api.producer.HollowProducerListener;
import com.netflix.hollow.api.producer.enforcer.SingleProducerEnforcer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractSingleProducerEnforcer
extends AbstractHollowProducerListener
implements SingleProducerEnforcer {
    private boolean hasCycleStarted = false;
    private boolean doStopUponCycleComplete = false;
    private boolean wasPrimary = false;
    private final Logger logger = Logger.getLogger(AbstractSingleProducerEnforcer.class.getName());
    private final Lock lock = new ReentrantLock();

    protected abstract void _enable();

    protected abstract void _disable();

    protected abstract boolean _isPrimary();

    protected void _force() {
        throw new UnsupportedOperationException("forcing a producer to become primary is not supported");
    }

    @Override
    public void enable() {
        if (this._isPrimary()) {
            return;
        }
        this.lock.lock();
        try {
            this._enable();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void disable() {
        if (!this.hasCycleStarted) {
            this.disableNow();
        } else {
            this.doStopUponCycleComplete = true;
        }
    }

    @Override
    public boolean isPrimary() {
        boolean primary = this._isPrimary();
        if (!primary) {
            if (this.wasPrimary) {
                this.logger.log(Level.WARNING, "SingleProducerEnforcer: lost primary producer status");
            }
        } else {
            this.wasPrimary = true;
        }
        return primary;
    }

    @Override
    public void force() {
        if (this._isPrimary()) {
            return;
        }
        this._force();
    }

    @Override
    public void lock() {
        this.lock.lock();
    }

    @Override
    public void unlock() {
        this.lock.unlock();
    }

    @Override
    public void onCycleStart(long version) {
        this.hasCycleStarted = true;
    }

    @Override
    public void onCycleComplete(HollowProducerListener.ProducerStatus status, long elapsed, TimeUnit unit) {
        this.hasCycleStarted = false;
        if (this.doStopUponCycleComplete) {
            this.disableNow();
        }
    }

    private void disableNow() {
        if (this._isPrimary()) {
            this.lock.lock();
            try {
                this._disable();
            }
            finally {
                this.lock.unlock();
            }
        }
        this.doStopUponCycleComplete = false;
        this.wasPrimary = false;
    }

    protected boolean getWasPrimary() {
        return this.wasPrimary;
    }
}

