/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.producer;

import java.util.EventListener;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@Deprecated
public interface IncrementalCycleListener
extends EventListener {
    public void onCycleComplete(IncrementalCycleStatus var1, long var2, TimeUnit var4);

    public void onCycleFail(IncrementalCycleStatus var1, long var2, TimeUnit var4);

    public static enum Status {
        SUCCESS,
        FAIL;

    }

    public static class IncrementalCycleStatus {
        private final Status status;
        private final long version;
        private final long recordsAddedOrModified;
        private final long recordsRemoved;
        private final Map<String, Object> cycleMetadata;
        private final Throwable throwable;

        public IncrementalCycleStatus(Status status, long version, Throwable throwable, long recordsAddedOrModified, long recordsRemoved, Map<String, Object> cycleMetadata) {
            this.status = status;
            this.version = version;
            this.recordsAddedOrModified = recordsAddedOrModified;
            this.recordsRemoved = recordsRemoved;
            this.cycleMetadata = cycleMetadata;
            this.throwable = throwable;
        }

        public long getVersion() {
            return this.version;
        }

        public Status getStatus() {
            return this.status;
        }

        public long getRecordsAddedOrModified() {
            return this.recordsAddedOrModified;
        }

        public long getRecordsRemoved() {
            return this.recordsRemoved;
        }

        public Map<String, Object> getCycleMetadata() {
            return this.cycleMetadata;
        }

        public Throwable getCause() {
            return this.throwable;
        }

        public static final class Builder {
            private final long start;
            private long end;
            private long version = Long.MIN_VALUE;
            private Status status = Status.FAIL;
            private Throwable cause = null;
            private long recordsAddedOrModified;
            private long recordsRemoved;
            private Map<String, Object> cycleMetadata;

            Builder() {
                this.start = System.currentTimeMillis();
            }

            Builder success(long version, long recordsAddedOrModified, long recordsRemoved, Map<String, Object> cycleMetadata) {
                this.status = Status.SUCCESS;
                this.version = version;
                this.recordsAddedOrModified = recordsAddedOrModified;
                this.recordsRemoved = recordsRemoved;
                this.cycleMetadata = cycleMetadata;
                return this;
            }

            Builder fail(Throwable cause, long recordsAddedOrModified, long recordsRemoved, Map<String, Object> cycleMetadata) {
                this.status = Status.FAIL;
                this.cause = cause;
                this.recordsAddedOrModified = recordsAddedOrModified;
                this.recordsRemoved = recordsRemoved;
                this.cycleMetadata = cycleMetadata;
                return this;
            }

            IncrementalCycleStatus build() {
                this.end = System.currentTimeMillis();
                return new IncrementalCycleStatus(this.status, this.version, this.cause, this.recordsAddedOrModified, this.recordsRemoved, this.cycleMetadata);
            }

            long elapsed() {
                return this.end - this.start;
            }
        }
    }
}

